/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.IFFChunk;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.imageio.IIOException;

final class BMHDChunk
extends IFFChunk {
    static final int MASK_NONE = 0;
    static final int MASK_HAS_MASK = 1;
    static final int MASK_TRANSPARENT_COLOR = 2;
    static final int MASK_LASSO = 3;
    static final int COMPRESSION_NONE = 0;
    static final int COMPRESSION_BYTE_RUN = 1;
    int width;
    int height;
    int xPos;
    int yPos;
    int bitplanes;
    int maskType;
    int compressionType;
    int transparentIndex;
    int xAspect;
    int yAspect;
    int pageWidth;
    int pageHeight;

    protected BMHDChunk(int n) {
        super(1112361028, n);
    }

    protected BMHDChunk(int n, int n2, int n3, int n4, int n5, int n6) {
        super(1112361028, 20);
        this.width = n;
        this.height = n2;
        this.xPos = 0;
        this.yPos = 0;
        this.bitplanes = n3;
        this.maskType = n4;
        this.compressionType = n5;
        this.transparentIndex = n6;
        this.xAspect = 1;
        this.yAspect = 1;
        this.pageWidth = Math.min(n, Short.MAX_VALUE);
        this.pageHeight = Math.min(n2, Short.MAX_VALUE);
    }

    void readChunk(DataInput dataInput) throws IOException {
        if (this.chunkLength != 20) {
            throw new IIOException("Unknown BMHD chunk length: " + this.chunkLength);
        }
        this.width = dataInput.readUnsignedShort();
        this.height = dataInput.readUnsignedShort();
        this.xPos = dataInput.readShort();
        this.yPos = dataInput.readShort();
        this.bitplanes = dataInput.readUnsignedByte();
        this.maskType = dataInput.readUnsignedByte();
        this.compressionType = dataInput.readUnsignedByte();
        dataInput.readByte();
        this.transparentIndex = dataInput.readUnsignedShort();
        this.xAspect = dataInput.readUnsignedByte();
        this.yAspect = dataInput.readUnsignedByte();
        this.pageWidth = dataInput.readShort();
        this.pageHeight = dataInput.readShort();
    }

    void writeChunk(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.chunkId);
        dataOutput.writeInt(this.chunkLength);
        dataOutput.writeShort(this.width);
        dataOutput.writeShort(this.height);
        dataOutput.writeShort(this.xPos);
        dataOutput.writeShort(this.yPos);
        dataOutput.writeByte(this.bitplanes);
        dataOutput.writeByte(this.maskType);
        dataOutput.writeByte(this.compressionType);
        dataOutput.writeByte(0);
        dataOutput.writeShort(this.transparentIndex);
        dataOutput.writeByte(this.xAspect);
        dataOutput.writeByte(this.yAspect);
        dataOutput.writeShort(this.pageWidth);
        dataOutput.writeShort(this.pageHeight);
    }

    public String toString() {
        return super.toString() + " {w=" + this.width + ", h=" + this.height + ", x=" + this.xPos + ", y=" + this.yPos + ", planes=" + this.bitplanes + ", mask=" + this.maskType + ", compression=" + this.compressionType + ", trans=" + this.transparentIndex + ", xAspect=" + this.xAspect + ", yAspect=" + this.yAspect + ", pageWidth=" + this.pageWidth + ", pageHeight=" + this.pageHeight + "}";
    }
}

