/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.iff;

import com.twelvemonkeys.imageio.plugins.iff.IFFImageReader;
import com.twelvemonkeys.imageio.spi.ProviderInfo;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class IFFImageReaderSpi
extends ImageReaderSpi {
    static IFFImageReaderSpi mSharedInstance;

    public IFFImageReaderSpi() {
        this(IIOUtil.getProviderInfo(IFFImageReaderSpi.class));
    }

    private IFFImageReaderSpi(ProviderInfo providerInfo) {
        super(providerInfo.getVendorName(), providerInfo.getVersion(), new String[]{"iff", "IFF"}, new String[]{"iff", "lbm", "ham", "ham8", "ilbm"}, new String[]{"image/iff", "image/x-iff"}, "com.twelvemonkeys.imageio.plugins.iff.IFFImageReader", new Class[]{ImageInputStream.class}, new String[]{"com.twelvemonkeys.imageio.plugins.iff.IFFImageWriterSpi"}, true, null, null, null, null, true, null, null, null, null);
        if (mSharedInstance == null) {
            mSharedInstance = this;
        }
    }

    public boolean canDecodeInput(Object object) throws IOException {
        return object instanceof ImageInputStream && IFFImageReaderSpi.canDecode((ImageInputStream)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canDecode(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.mark();
        try {
            if (imageInputStream.readInt() == 1179603533) {
                imageInputStream.readInt();
                int n = imageInputStream.readInt();
                if (n == 1229734477 || n == 1346522400) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            imageInputStream.reset();
        }
        return false;
    }

    public ImageReader createReaderInstance(Object object) throws IOException {
        return new IFFImageReader(this);
    }

    public String getDescription(Locale locale) {
        return "Commodore Amiga/Electronic Arts Image Interchange Format (IFF) image reader";
    }

    public static ImageReaderSpi sharedProvider() {
        if (mSharedInstance == null) {
            new IFFImageReaderSpi();
        }
        return mSharedInstance;
    }
}

