/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.icns;

import com.twelvemonkeys.imageio.plugins.icns.ICNSImageReader;
import com.twelvemonkeys.imageio.spi.ProviderInfo;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class ICNSImageReaderSpi
extends ImageReaderSpi {
    public ICNSImageReaderSpi() {
        this(IIOUtil.getProviderInfo(ICNSImageReaderSpi.class));
    }

    private ICNSImageReaderSpi(ProviderInfo providerInfo) {
        super(providerInfo.getVendorName(), providerInfo.getVersion(), new String[]{"icns", "ICNS"}, new String[]{"icns"}, new String[]{"image/x-apple-icons"}, "com.twelvemonkeys.imageio.plugins.icns.ICNSImageReader", new Class[]{ImageInputStream.class}, null, true, null, null, null, null, true, null, null, null, null);
    }

    public boolean canDecodeInput(Object object) throws IOException {
        return object instanceof ImageInputStream && ICNSImageReaderSpi.canDecode((ImageInputStream)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canDecode(ImageInputStream imageInputStream) throws IOException {
        try {
            imageInputStream.mark();
            boolean bl = imageInputStream.readInt() == 1768124019;
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    public ImageReader createReaderInstance(Object object) throws IOException {
        return new ICNSImageReader(this);
    }

    public String getDescription(Locale locale) {
        return "Apple Icon Image (icns) format Reader";
    }
}

