/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.hdr;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class RGBE {
    private static final int VALID_PROGRAMTYPE = 1;
    private static final int VALID_GAMMA = 2;
    private static final int VALID_EXPOSURE = 4;
    private static final String gammaString = "GAMMA=";
    private static final String exposureString = "EXPOSURE=";
    private static final Pattern widthHeightPattern = Pattern.compile("-Y (\\d+) \\+X (\\d+)");
    private static final double two54 = 1.8014398509481984E16;
    private static final double twom54 = 5.551115123125783E-17;
    private static final double huge = 1.0E300;
    private static final double tiny = 1.0E-300;

    RGBE() {
    }

    public static Header readHeader(DataInput dataInput) throws IOException {
        int n = 0;
        String string = null;
        float f = 1.0f;
        float f2 = 1.0f;
        int n2 = 0;
        int n3 = 0;
        String string2 = dataInput.readLine();
        if (string2 == null) {
            throw new IOException("Unexpected EOF reading magic token");
        }
        if (string2.charAt(0) == '#' && string2.charAt(1) == '?') {
            n |= 1;
            string = string2.substring(2);
            string2 = dataInput.readLine();
            if (string2 == null) {
                throw new IOException("Unexpected EOF reading line after magic token");
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2) {
            if (string2.equals("FORMAT=32-bit_rle_rgbe")) {
                bl = true;
            } else if (string2.startsWith(gammaString)) {
                n |= 2;
                f = Float.parseFloat(string2.substring(gammaString.length()));
            } else if (string2.startsWith(exposureString)) {
                n |= 4;
                f2 = Float.parseFloat(string2.substring(exposureString.length()));
            } else {
                Matcher matcher = widthHeightPattern.matcher(string2);
                if (matcher.matches()) {
                    n2 = Integer.parseInt(matcher.group(2));
                    n3 = Integer.parseInt(matcher.group(1));
                    bl2 = true;
                }
            }
            if (bl2 || (string2 = dataInput.readLine()) != null) continue;
            throw new IOException("Unexpected EOF reading header");
        }
        if (!bl) {
            throw new IOException("No FORMAT specifier found");
        }
        return new Header(n, string, f, f2, n2, n3);
    }

    public static void readPixels(DataInput dataInput, float[] fArray, int n) throws IOException {
        byte[] byArray = new byte[4];
        float[] fArray2 = new float[3];
        int n2 = 0;
        while (n-- > 0) {
            dataInput.readFully(byArray);
            RGBE.rgbe2float(fArray2, byArray, 0);
            fArray[n2++] = fArray2[0];
            fArray[n2++] = fArray2[1];
            fArray[n2++] = fArray2[2];
        }
    }

    public static void readPixelsRaw(DataInput dataInput, byte[] byArray, int n, int n2) throws IOException {
        int n3 = 4 * n2;
        dataInput.readFully(byArray, n, n3);
    }

    public static void readPixelsRawRLE(DataInput dataInput, byte[] byArray, int n, int n2, int n3) throws IOException {
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = null;
        byte[] byArray4 = new byte[2];
        if (n2 < 8 || n2 > Short.MAX_VALUE) {
            RGBE.readPixelsRaw(dataInput, byArray, n, n2 * n3);
        }
        while (n3 > 0) {
            int n4;
            dataInput.readFully(byArray2);
            if (byArray2[0] != 2 || byArray2[1] != 2 || (byArray2[2] & 0x80) != 0) {
                byArray[n++] = byArray2[0];
                byArray[n++] = byArray2[1];
                byArray[n++] = byArray2[2];
                byArray[n++] = byArray2[3];
                RGBE.readPixelsRaw(dataInput, byArray, n, n2 * n3 - 1);
            }
            if (((byArray2[2] & 0xFF) << 8 | byArray2[3] & 0xFF) != n2) {
                throw new IOException("Wrong scanline width " + ((byArray2[2] & 0xFF) << 8 | byArray2[3] & 0xFF) + ", expected " + n2);
            }
            if (byArray3 == null) {
                byArray3 = new byte[4 * n2];
            }
            int n5 = 0;
            for (n4 = 0; n4 < 4; ++n4) {
                int n6 = (n4 + 1) * n2;
                while (n5 < n6) {
                    int n7;
                    dataInput.readFully(byArray4);
                    if ((byArray4[0] & 0xFF) > 128) {
                        n7 = (byArray4[0] & 0xFF) - 128;
                        if (n7 == 0 || n7 > n6 - n5) {
                            throw new IOException("Bad scanline data");
                        }
                        while (n7-- > 0) {
                            byArray3[n5++] = byArray4[1];
                        }
                        continue;
                    }
                    n7 = byArray4[0] & 0xFF;
                    if (n7 == 0 || n7 > n6 - n5) {
                        throw new IOException("Bad scanline data");
                    }
                    byArray3[n5++] = byArray4[1];
                    if (--n7 <= 0) continue;
                    dataInput.readFully(byArray3, n5, n7);
                    n5 += n7;
                }
            }
            for (n4 = 0; n4 < n2; ++n4) {
                byArray[n++] = byArray3[n4];
                byArray[n++] = byArray3[n4 + n2];
                byArray[n++] = byArray3[n4 + 2 * n2];
                byArray[n++] = byArray3[n4 + 3 * n2];
            }
            --n3;
        }
    }

    public static void float2rgbe(byte[] byArray, float f, float f2, float f3) {
        float f4 = f;
        if (f2 > f4) {
            f4 = f2;
        }
        if (f3 > f4) {
            f4 = f3;
        }
        if (f4 < 1.0E-32f) {
            byArray[3] = 0;
            byArray[2] = 0;
            byArray[1] = 0;
            byArray[0] = 0;
        } else {
            FracExp fracExp = RGBE.frexp(f4);
            f4 = (float)(fracExp.getFraction() * 256.0 / (double)f4);
            byArray[0] = (byte)(f * f4);
            byArray[1] = (byte)(f2 * f4);
            byArray[2] = (byte)(f3 * f4);
            byArray[3] = (byte)(fracExp.getExponent() + 128);
        }
    }

    public static void rgbe2float(float[] fArray, byte[] byArray, int n) {
        if (byArray[n + 3] != 0) {
            float f = (float)RGBE.ldexp(1.0, (byArray[n + 3] & 0xFF) - 136);
            fArray[0] = (float)(byArray[n + 0] & 0xFF) * f;
            fArray[1] = (float)(byArray[n + 1] & 0xFF) * f;
            fArray[2] = (float)(byArray[n + 2] & 0xFF) * f;
        } else {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
        }
    }

    public static double ldexp(double d, int n) {
        if (!RGBE.finite(d) || d == 0.0) {
            return d;
        }
        d = RGBE.scalbn(d, n);
        return d;
    }

    private static int hi(double d) {
        long l = Double.doubleToRawLongBits(d);
        return (int)(l >>> 32);
    }

    private static int lo(double d) {
        long l = Double.doubleToRawLongBits(d);
        return (int)l;
    }

    private static double fromhilo(int n, int n2) {
        return Double.longBitsToDouble((long)n << 32 | (long)n2 & 0xFFFFFFFFL);
    }

    private static FracExp frexp(double d) {
        int n = RGBE.hi(d);
        int n2 = Integer.MAX_VALUE & n;
        int n3 = RGBE.lo(d);
        int n4 = 0;
        if (n2 >= 0x7FF00000 || (n2 | n3) == 0) {
            return new FracExp(d, n4);
        }
        if (n2 < 0x100000) {
            n = RGBE.hi(d *= 1.8014398509481984E16);
            n2 = n & Integer.MAX_VALUE;
            n4 = -54;
        }
        n = n & 0x800FFFFF | 0x3FE00000;
        n3 = RGBE.lo(d);
        return new FracExp(RGBE.fromhilo(n, n3), n4 += (n2 >> 20) - 1022);
    }

    private static boolean finite(double d) {
        int n = RGBE.hi(d);
        return (n & Integer.MAX_VALUE) - 0x7FF00000 >> 31 != 0;
    }

    private static double copysign(double d, double d2) {
        return RGBE.fromhilo(RGBE.hi(d) & Integer.MAX_VALUE | RGBE.hi(d2) & Integer.MIN_VALUE, RGBE.lo(d));
    }

    private static double scalbn(double d, int n) {
        int n2 = RGBE.hi(d);
        int n3 = RGBE.lo(d);
        int n4 = (n2 & 0x7FF00000) >> 20;
        if (n4 == 0) {
            if ((n3 | n2 & Integer.MAX_VALUE) == 0) {
                return d;
            }
            n2 = RGBE.hi(d *= 1.8014398509481984E16);
            n4 = ((n2 & 0x7FF00000) >> 20) - 54;
            if (n < -50000) {
                return 1.0E-300 * d;
            }
        }
        if (n4 == 2047) {
            return d + d;
        }
        if ((n4 += n) > 2046) {
            return 1.0E300 * RGBE.copysign(1.0E300, d);
        }
        if (n4 > 0) {
            return RGBE.fromhilo(n2 & 0x800FFFFF | n4 << 20, RGBE.lo(d));
        }
        if (n4 <= -54) {
            if (n > 50000) {
                return 1.0E300 * RGBE.copysign(1.0E300, d);
            }
            return 1.0E-300 * RGBE.copysign(1.0E-300, d);
        }
        d = RGBE.fromhilo(n2 & 0x800FFFFF | (n4 += 54) << 20, RGBE.lo(d));
        return d * 5.551115123125783E-17;
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(stringArray[i])));
                Header header = RGBE.readHeader(dataInputStream);
                System.err.println("Header for file \"" + stringArray[i] + "\":");
                System.err.println("  " + header);
                byte[] byArray = new byte[header.getWidth() * header.getHeight() * 4];
                RGBE.readPixelsRawRLE(dataInputStream, byArray, 0, header.getWidth(), header.getHeight());
                dataInputStream.close();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    static class FracExp {
        private double fraction;
        private int exponent;

        public FracExp(double d, int n) {
            this.fraction = d;
            this.exponent = n;
        }

        public double getFraction() {
            return this.fraction;
        }

        public int getExponent() {
            return this.exponent;
        }
    }

    public static class Header {
        private int valid;
        private String programType;
        private float gamma;
        private float exposure;
        private int width;
        private int height;

        private Header(int n, String string, float f, float f2, int n2, int n3) {
            this.valid = n;
            this.programType = string;
            this.gamma = f;
            this.exposure = f2;
            this.width = n2;
            this.height = n3;
        }

        public boolean isProgramTypeValid() {
            return (this.valid & 1) != 0;
        }

        public boolean isGammaValid() {
            return (this.valid & 2) != 0;
        }

        public boolean isExposureValid() {
            return (this.valid & 4) != 0;
        }

        public String getProgramType() {
            return this.programType;
        }

        public float getGamma() {
            return this.gamma;
        }

        public float getExposure() {
            return this.exposure;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.isProgramTypeValid()) {
                stringBuffer.append(" Program type: ");
                stringBuffer.append(this.getProgramType());
            }
            stringBuffer.append(" Gamma");
            if (this.isGammaValid()) {
                stringBuffer.append(" [valid]");
            }
            stringBuffer.append(": ");
            stringBuffer.append(this.getGamma());
            stringBuffer.append(" Exposure");
            if (this.isExposureValid()) {
                stringBuffer.append(" [valid]");
            }
            stringBuffer.append(": ");
            stringBuffer.append(this.getExposure());
            stringBuffer.append(" Width: ");
            stringBuffer.append(this.getWidth());
            stringBuffer.append(" Height: ");
            stringBuffer.append(this.getHeight());
            return stringBuffer.toString();
        }
    }
}

