/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.hdr;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.hdr.HDRHeader;
import com.twelvemonkeys.imageio.plugins.hdr.HDRImageReadParam;
import com.twelvemonkeys.imageio.plugins.hdr.HDRMetadata;
import com.twelvemonkeys.imageio.plugins.hdr.RGBE;
import com.twelvemonkeys.imageio.plugins.hdr.tonemap.ToneMapper;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;

public final class HDRImageReader
extends ImageReaderBase {
    private HDRHeader header;

    HDRImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected void resetMembers() {
        this.header = null;
    }

    private void readHeader() throws IOException {
        if (this.header == null) {
            this.header = HDRHeader.read(this.imageInput);
            this.imageInput.flushBefore(this.imageInput.getStreamPosition());
        }
        this.imageInput.seek(this.imageInput.getFlushedPosition());
    }

    public int getWidth(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.header.getWidth();
    }

    public int getHeight(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        return this.header.getHeight();
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        this.checkBounds(n);
        this.readHeader();
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        return Collections.singletonList(ImageTypeSpecifiers.createInterleaved((ColorSpace)colorSpace, (int[])new int[]{0, 1, 2}, (int)4, (boolean)false, (boolean)false)).iterator();
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        int n2;
        this.checkBounds(n);
        this.readHeader();
        int n3 = this.getWidth(n);
        int n4 = this.getHeight(n);
        BufferedImage bufferedImage = HDRImageReader.getDestination((ImageReadParam)imageReadParam, this.getImageTypes(n), (int)n3, (int)n4);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        HDRImageReader.computeRegions((ImageReadParam)imageReadParam, (int)n3, (int)n4, (BufferedImage)bufferedImage, (Rectangle)rectangle, (Rectangle)rectangle2);
        WritableRaster writableRaster = bufferedImage.getRaster().createWritableChild(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, 0, 0, null);
        int n5 = imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1;
        int n6 = imageReadParam != null ? imageReadParam.getSourceYSubsampling() : 1;
        ToneMapper toneMapper = imageReadParam instanceof HDRImageReadParam ? ((HDRImageReadParam)imageReadParam).getToneMapper() : HDRImageReadParam.DEFAULT_TONE_MAPPER;
        byte[] byArray = new byte[n3 * 4];
        float[] fArray = new float[3];
        this.processImageStarted(n);
        for (int i = 0; i < n4 && (n2 = (i - rectangle.y) / n6 + rectangle2.y) < rectangle2.height; ++i) {
            RGBE.readPixelsRawRLE(this.imageInput, byArray, 0, n3, 1);
            if (i % n6 == 0 && n2 >= rectangle2.y) {
                int n7;
                for (int j = rectangle.x; j < rectangle.x + rectangle.width && (n7 = (j - rectangle.x) / n5 + rectangle2.x) < rectangle2.width; j += n5) {
                    RGBE.rgbe2float(fArray, byArray, j * 4);
                    toneMapper.map(fArray);
                    writableRaster.setDataElements(n7, n2, fArray);
                }
            }
            this.processImageProgress((float)i * 100.0f / (float)n4);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            break;
        }
        this.processImageComplete();
        return bufferedImage;
    }

    public boolean canReadRaster() {
        return true;
    }

    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        int n2;
        this.checkBounds(n);
        this.readHeader();
        int n3 = this.getWidth(n);
        int n4 = this.getHeight(n);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        HDRImageReader.computeRegions((ImageReadParam)imageReadParam, (int)n3, (int)n4, null, (Rectangle)rectangle, (Rectangle)rectangle2);
        rectangle2 = rectangle;
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 6);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n5 = imageReadParam != null ? imageReadParam.getSourceXSubsampling() : 1;
        int n6 = imageReadParam != null ? imageReadParam.getSourceYSubsampling() : 1;
        byte[] byArray = new byte[n3 * 4];
        byte[] byArray2 = new byte[4];
        this.processImageStarted(n);
        for (int i = 0; i < n4 && (n2 = (i - rectangle.y) / n6 + rectangle2.y) < rectangle2.height; ++i) {
            RGBE.readPixelsRawRLE(this.imageInput, byArray, 0, n3, 1);
            if (i % n6 == 0 && n2 >= rectangle2.y) {
                int n7;
                for (int j = rectangle.x; j < rectangle.x + rectangle.width && (n7 = (j - rectangle.x) / n5 + rectangle2.x) < rectangle2.width; j += n5) {
                    System.arraycopy(byArray, j * 4, byArray2, 0, 4);
                    writableRaster.setDataElements(n7, n2, byArray2);
                }
            }
            this.processImageProgress((float)i * 100.0f / (float)n4);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            break;
        }
        this.processImageComplete();
        return writableRaster;
    }

    public ImageReadParam getDefaultReadParam() {
        return new HDRImageReadParam();
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        return new HDRMetadata(this.getRawImageType(n), this.header);
    }

    public static void main(String[] stringArray) throws IOException {
        File file = new File(stringArray[0]);
        BufferedImage bufferedImage = ImageIO.read(file);
        HDRImageReader.showIt((BufferedImage)bufferedImage, (String)file.getName());
    }
}

