/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.dds;

import com.twelvemonkeys.imageio.plugins.dds.DDS;
import com.twelvemonkeys.imageio.plugins.dds.DDSImageReader;
import com.twelvemonkeys.imageio.plugins.dds.DDSProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageReaderSpiBase;
import com.twelvemonkeys.imageio.spi.ReaderWriterProviderInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class DDSImageReaderSpi
extends ImageReaderSpiBase {
    public DDSImageReaderSpi() {
        super((ReaderWriterProviderInfo)new DDSProviderInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        imageInputStream.mark();
        try {
            byte[] byArray = new byte[DDS.MAGIC.length];
            imageInputStream.readFully(byArray);
            boolean bl = Arrays.equals(DDS.MAGIC, byArray);
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    public ImageReader createReaderInstance(Object object) {
        return new DDSImageReader((ImageReaderSpi)((Object)this));
    }

    public String getDescription(Locale locale) {
        return "Direct DrawSurface (DDS) Image Reader";
    }
}

