/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.dds;

import com.twelvemonkeys.imageio.plugins.dds.DDS;
import java.awt.Dimension;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class DDSHeader {
    private int flags;
    private int mipMapCount;
    private Dimension[] dimensions;
    private int pixelFormatFlags;
    private int fourCC;
    private int bitCount;
    private int redMask;
    private int greenMask;
    private int blueMask;
    private int alphaMask;

    DDSHeader() {
    }

    static DDSHeader read(ImageInputStream imageInputStream) throws IOException {
        DDSHeader dDSHeader = new DDSHeader();
        byte[] byArray = new byte[DDS.MAGIC.length];
        imageInputStream.readFully(byArray);
        if (!Arrays.equals(DDS.MAGIC, byArray)) {
            throw new IIOException(String.format("Not a DDS file. Expected DDS magic 0x%08x', read 0x%08x", new BigInteger(DDS.MAGIC), new BigInteger(byArray)));
        }
        int n = imageInputStream.readInt();
        if (n != 124) {
            throw new IIOException(String.format("Invalid DDS header size (expected %d): %d", 124, n));
        }
        dDSHeader.flags = imageInputStream.readInt();
        if (!dDSHeader.getFlag(4103)) {
            throw new IIOException("Required DDS Flag missing in header: " + Integer.toBinaryString(dDSHeader.flags));
        }
        int n2 = imageInputStream.readInt();
        int n3 = imageInputStream.readInt();
        int n4 = imageInputStream.readInt();
        int n5 = imageInputStream.readInt();
        dDSHeader.mipMapCount = Math.max(1, imageInputStream.readInt());
        dDSHeader.addDimensions(n3, n2);
        byte[] byArray2 = new byte[44];
        imageInputStream.readFully(byArray2);
        int n6 = imageInputStream.readInt();
        dDSHeader.pixelFormatFlags = imageInputStream.readInt();
        dDSHeader.fourCC = imageInputStream.readInt();
        dDSHeader.bitCount = imageInputStream.readInt();
        dDSHeader.redMask = imageInputStream.readInt();
        dDSHeader.greenMask = imageInputStream.readInt();
        dDSHeader.blueMask = imageInputStream.readInt();
        dDSHeader.alphaMask = imageInputStream.readInt();
        int n7 = imageInputStream.readInt();
        int n8 = imageInputStream.readInt();
        int n9 = imageInputStream.readInt();
        int n10 = imageInputStream.readInt();
        int n11 = imageInputStream.readInt();
        return dDSHeader;
    }

    private void addDimensions(int n, int n2) {
        this.dimensions = new Dimension[this.mipMapCount];
        int n3 = n;
        int n4 = n2;
        for (int i = 0; i < this.mipMapCount; ++i) {
            this.dimensions[i] = new Dimension(n3, n4);
            n3 /= 2;
            n4 /= 2;
        }
    }

    private boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    int getWidth(int n) {
        int n2 = this.dimensions[n].width;
        return n2 <= 0 ? 1 : n2;
    }

    int getHeight(int n) {
        int n2 = this.dimensions[n].height;
        return n2 <= 0 ? 1 : n2;
    }

    int getMipMapCount() {
        return this.mipMapCount;
    }

    int getBitCount() {
        return this.bitCount;
    }

    int getFourCC() {
        return this.fourCC;
    }

    int getPixelFormatFlags() {
        return this.pixelFormatFlags;
    }

    int getRedMask() {
        return this.redMask;
    }

    int getGreenMask() {
        return this.greenMask;
    }

    int getBlueMask() {
        return this.blueMask;
    }

    int getAlphaMask() {
        return this.alphaMask;
    }
}

