/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.path;

import com.twelvemonkeys.lang.Validate;

final class AdobePathSegment {
    public static final int CLOSED_SUBPATH_LENGTH_RECORD = 0;
    public static final int CLOSED_SUBPATH_BEZIER_LINKED = 1;
    public static final int CLOSED_SUBPATH_BEZIER_UNLINKED = 2;
    public static final int OPEN_SUBPATH_LENGTH_RECORD = 3;
    public static final int OPEN_SUBPATH_BEZIER_LINKED = 4;
    public static final int OPEN_SUBPATH_BEZIER_UNLINKED = 5;
    public static final int PATH_FILL_RULE_RECORD = 6;
    public static final int CLIPBOARD_RECORD = 7;
    public static final int INITIAL_FILL_RULE_RECORD = 8;
    public static final String[] SELECTOR_NAMES = new String[]{"Closed subpath length record", "Closed subpath Bezier knot, linked", "Closed subpath Bezier knot, unlinked", "Open subpath length record", "Open subpath Bezier knot, linked", "Open subpath Bezier knot, unlinked", "Path fill rule record", "Clipboard record", "Initial fill rule record"};
    final int selector;
    final int length;
    final double cppy;
    final double cppx;
    final double apy;
    final double apx;
    final double cply;
    final double cplx;

    AdobePathSegment(int n, double d, double d2, double d3, double d4, double d5, double d6) {
        this(n, -1, d, d2, d3, d4, d5, d6);
    }

    AdobePathSegment(int n, int n2) {
        this(n, n2, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0);
    }

    private AdobePathSegment(int n, int n2, double d, double d2, double d3, double d4, double d5, double d6) {
        switch (n) {
            case 0: 
            case 3: {
                Validate.isTrue((n2 >= 0 ? 1 : 0) != 0, (Object)n2, (String)"Bad size: %d");
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                Validate.isTrue((d2 >= 0.0 && d2 <= 1.0 && d >= 0.0 && d <= 1.0 ? 1 : 0) != 0, (String)String.format("Unexpected point: [%f, %f]", d2, d));
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad selector: " + n);
            }
        }
        this.selector = n;
        this.length = n2;
        this.cppy = d;
        this.cppx = d2;
        this.apy = d3;
        this.apx = d4;
        this.cply = d5;
        this.cplx = d6;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AdobePathSegment adobePathSegment = (AdobePathSegment)object;
        return Double.compare(adobePathSegment.apx, this.apx) == 0 && Double.compare(adobePathSegment.apy, this.apy) == 0 && Double.compare(adobePathSegment.cplx, this.cplx) == 0 && Double.compare(adobePathSegment.cply, this.cply) == 0 && Double.compare(adobePathSegment.cppx, this.cppx) == 0 && Double.compare(adobePathSegment.cppy, this.cppy) == 0 && this.selector == adobePathSegment.selector && this.length == adobePathSegment.length;
    }

    public int hashCode() {
        int n = this.selector;
        n = 31 * n + this.length;
        long l = Double.doubleToLongBits(this.cppy);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.cppx);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.apy);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.apx);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.cply);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.cplx);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public String toString() {
        switch (this.selector) {
            case 6: 
            case 8: {
                return String.format("Rule(selector=%s, rule=%d)", SELECTOR_NAMES[this.selector], this.length);
            }
            case 0: 
            case 3: {
                return String.format("Len(selector=%s, totalPoints=%d)", SELECTOR_NAMES[this.selector], this.length);
            }
        }
        return String.format("Pt(preX=%.3f, preY=%.3f, knotX=%.3f, knotY=%.3f, postX=%.3f, postY=%.3f, selector=%s)", this.cppx, this.cppy, this.apx, this.apy, this.cplx, this.cply, SELECTOR_NAMES[this.selector]);
    }
}

