/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util.service;

import com.twelvemonkeys.util.CollectionUtil;
import com.twelvemonkeys.util.service.DummySPI;
import com.twelvemonkeys.util.service.DummySPIImpl;
import com.twelvemonkeys.util.service.DummySPIToo;
import com.twelvemonkeys.util.service.ServiceConfigurationError;
import com.twelvemonkeys.util.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class ServiceRegistryTest {
    private final TestRegistry registry = new TestRegistry();

    @Test(expected=IllegalArgumentException.class)
    public void testCreateNull() {
        new ServiceRegistry(null);
    }

    @Test
    public void testCreateEmptyIterator() {
        ServiceRegistry serviceRegistry = new ServiceRegistry(Collections.emptyList().iterator());
        serviceRegistry.registerApplicationClasspathSPIs();
        while (serviceRegistry.categories().hasNext()) {
            Assert.fail((String)"No categories");
        }
    }

    @Test(expected=ServiceConfigurationError.class)
    public void testCreateBadConfig() {
        ServiceRegistry serviceRegistry = new ServiceRegistry(Arrays.asList(BadSPI.class).iterator());
        serviceRegistry.registerApplicationClasspathSPIs();
    }

    @Test
    public void testCategories() {
        Iterator iterator = this.registry.categories();
        Assert.assertTrue((boolean)iterator.hasNext());
        Class clazz = (Class)iterator.next();
        Assert.assertEquals(DummySPI.class, (Object)clazz);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testProviders() {
        Iterator iterator = this.registry.providers(DummySPI.class);
        ArrayList arrayList = new ArrayList();
        CollectionUtil.addAll(arrayList, (Iterator)iterator);
        Assert.assertEquals((long)2L, (long)arrayList.size());
        Assert.assertNotNull(arrayList.get(0));
        Assert.assertEquals(DummySPIImpl.class, ((DummySPI)arrayList.get(0)).getClass());
        Assert.assertNotNull(arrayList.get(1));
        Assert.assertEquals(DummySPIToo.class, ((DummySPI)arrayList.get(1)).getClass());
    }

    @Test
    public void testCompatibleCategoriesNull() {
        Iterator iterator = this.registry.compatibleCategories(null);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testCompatibleCategoriesImpl() {
        Iterator iterator = this.registry.compatibleCategories(new DummySPIImpl());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals(DummySPI.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testCompatibleCategoriesToo() {
        Iterator iterator = this.registry.compatibleCategories(new DummySPIToo());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals(DummySPI.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testCompatibleCategoriesNonRegistered() {
        Iterator iterator = this.registry.compatibleCategories(new DummySPI(){});
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals(DummySPI.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testCompatibleCategoriesUnknownType() {
        Iterator iterator = this.registry.compatibleCategories(new Object());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testContainingCategoriesNull() {
        Iterator iterator = this.registry.containingCategories(null);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testContainingCategoriesKnownInstanceImpl() {
        Iterator iterator = this.registry.providers(DummySPI.class);
        Assert.assertTrue((boolean)iterator.hasNext());
        Iterator iterator2 = this.registry.containingCategories(iterator.next());
        Assert.assertTrue((boolean)iterator2.hasNext());
        Assert.assertEquals(DummySPI.class, iterator2.next());
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    @Test
    public void testContainingCategoriesKnownInstanceToo() {
        Iterator iterator = this.registry.providers(DummySPI.class);
        iterator.next();
        Assert.assertTrue((boolean)iterator.hasNext());
        Iterator iterator2 = this.registry.containingCategories(iterator.next());
        Assert.assertTrue((boolean)iterator2.hasNext());
        Assert.assertEquals(DummySPI.class, iterator2.next());
        Assert.assertFalse((boolean)iterator2.hasNext());
    }

    @Test
    public void testContainingCategoriesNewInstanceRegisteredImpl() {
        Iterator iterator = this.registry.containingCategories(new DummySPIImpl());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals(DummySPI.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testContainingCategoriesNewInstanceRegisteredToo() {
        Iterator iterator = this.registry.containingCategories(new DummySPIToo());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals(DummySPI.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testContainingCategoriesCompatibleNonRegisteredType() {
        Iterator iterator = this.registry.containingCategories(new DummySPI(){});
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testContainingCategoriesUnknownType() {
        Iterator iterator = this.registry.containingCategories(new Object());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testRegister() {
        DummySPI dummySPI = new DummySPI(){};
        Assert.assertTrue((boolean)this.registry.register(dummySPI));
        Iterator iterator = this.registry.containingCategories(dummySPI);
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals(DummySPI.class, iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = this.registry.providers(DummySPI.class);
        ArrayList arrayList = new ArrayList();
        CollectionUtil.addAll(arrayList, (Iterator)iterator2);
        Assert.assertEquals((long)3L, (long)arrayList.size());
        Assert.assertNotNull(arrayList.get(1));
        Assert.assertSame((Object)dummySPI, arrayList.get(2));
    }

    @Test
    public void testRegisterAlreadyRegistered() {
        Iterator iterator = this.registry.providers(DummySPI.class);
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertFalse((boolean)this.registry.register(iterator.next()));
    }

    @Test
    public void testRegisterNull() {
        Assert.assertFalse((boolean)this.registry.register(null));
    }

    @Test
    public void testRegisterIncompatible() {
        Assert.assertFalse((boolean)this.registry.register(new Object()));
    }

    @Test
    public void testDeregisterNull() {
        Assert.assertFalse((boolean)this.registry.deregister(null));
    }

    @Test
    public void testDeregisterIncompatible() {
        Assert.assertFalse((boolean)this.registry.deregister(new Object()));
    }

    @Test
    public void testDeregisterCompatibleNonRegistered() {
        DummySPI dummySPI = new DummySPI(){};
        Assert.assertFalse((boolean)this.registry.deregister(dummySPI));
    }

    @Test
    public void testDeregister() {
        Iterator iterator = this.registry.providers(DummySPI.class);
        Assert.assertTrue((boolean)iterator.hasNext());
        DummySPI dummySPI = (DummySPI)iterator.next();
        Assert.assertTrue((boolean)this.registry.deregister(dummySPI));
        iterator = this.registry.providers(DummySPI.class);
        int n = 0;
        while (iterator.hasNext()) {
            DummySPI dummySPI2 = (DummySPI)iterator.next();
            Assert.assertNotSame((Object)dummySPI, (Object)dummySPI2);
            ++n;
        }
        Assert.assertEquals((long)1L, (long)n);
    }

    public static class BadSPI {
    }

    private static class TestRegistry
    extends ServiceRegistry {
        public TestRegistry() {
            super(Arrays.asList(DummySPI.class).iterator());
            this.registerApplicationClasspathSPIs();
        }
    }
}

