/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.CollectionAbstractTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public abstract class SetAbstractTest
extends CollectionAbstractTest {
    @Override
    public void verifyAll() {
        super.verifyAll();
        Assert.assertEquals((String)"Sets should be equal", (Object)this.confirmed, (Object)this.collection);
        Assert.assertEquals((String)"Sets should have equal hashCodes", (long)this.confirmed.hashCode(), (long)this.collection.hashCode());
        Collection collection = this.makeConfirmedCollection();
        Iterator iterator = this.collection.iterator();
        while (iterator.hasNext()) {
            Assert.assertTrue((String)"Set.iterator should only return unique elements", (boolean)collection.add(iterator.next()));
        }
    }

    @Override
    public boolean isEqualsCheckable() {
        return true;
    }

    @Override
    public Collection makeConfirmedCollection() {
        return new HashSet();
    }

    @Override
    public Collection makeConfirmedFullCollection() {
        Collection collection = this.makeConfirmedCollection();
        collection.addAll(Arrays.asList(this.getFullElements()));
        return collection;
    }

    public abstract Set makeEmptySet();

    public Set makeFullSet() {
        Set set = this.makeEmptySet();
        set.addAll(Arrays.asList(this.getFullElements()));
        return set;
    }

    @Override
    public final Collection makeCollection() {
        return this.makeEmptySet();
    }

    @Override
    public final Collection makeFullCollection() {
        return this.makeFullSet();
    }

    public Set getSet() {
        return (Set)this.collection;
    }

    public Set getConfirmedSet() {
        return (Set)this.confirmed;
    }

    @Test
    public void testSetEquals() {
        this.resetEmpty();
        Assert.assertEquals((String)"Empty sets should be equal", (Object)this.getSet(), (Object)this.getConfirmedSet());
        this.verifyAll();
        Collection collection = this.makeConfirmedCollection();
        collection.add("foo");
        Assert.assertTrue((String)"Empty set shouldn't equal nonempty set", (!this.getSet().equals(collection) ? 1 : 0) != 0);
        this.resetFull();
        Assert.assertEquals((String)"Full sets should be equal", (Object)this.getSet(), (Object)this.getConfirmedSet());
        this.verifyAll();
        collection.clear();
        collection.addAll(Arrays.asList(this.getOtherElements()));
        Assert.assertTrue((String)"Sets with different contents shouldn't be equal", (!this.getSet().equals(collection) ? 1 : 0) != 0);
    }

    @Test
    public void testSetHashCode() {
        this.resetEmpty();
        Assert.assertEquals((String)"Empty sets have equal hashCodes", (long)this.getSet().hashCode(), (long)this.getConfirmedSet().hashCode());
        this.resetFull();
        Assert.assertEquals((String)"Equal sets have equal hashCodes", (long)this.getSet().hashCode(), (long)this.getConfirmedSet().hashCode());
    }
}

