/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;

public abstract class ObjectAbstractTest {
    public abstract Object makeObject();

    public boolean supportsEmptyCollections() {
        return true;
    }

    public boolean supportsFullCollections() {
        return true;
    }

    public boolean isTestSerialization() {
        return true;
    }

    public boolean isEqualsCheckable() {
        return true;
    }

    @Test
    public void testObjectEqualsSelf() {
        Object object = this.makeObject();
        Assert.assertEquals((String)"A Object should equal itself", (Object)object, (Object)object);
    }

    @Test
    public void testEqualsNull() {
        Object object = this.makeObject();
        Assert.assertEquals((Object)false, (Object)object.equals(null));
    }

    @Test
    public void testObjectHashCodeEqualsSelfHashCode() {
        Object object = this.makeObject();
        Assert.assertEquals((String)"hashCode should be repeatable", (long)object.hashCode(), (long)object.hashCode());
    }

    @Test
    public void testObjectHashCodeEqualsContract() {
        Object object;
        Object object2 = this.makeObject();
        if (object2.equals(object2)) {
            Assert.assertEquals((String)"[1] When two objects are equal, their hashCodes should be also.", (long)object2.hashCode(), (long)object2.hashCode());
        }
        if (object2.equals(object = this.makeObject())) {
            Assert.assertEquals((String)"[2] When two objects are equal, their hashCodes should be also.", (long)object2.hashCode(), (long)object.hashCode());
            Assert.assertTrue((String)"When obj1.equals(obj2) is true, then obj2.equals(obj1) should also be true", (boolean)object.equals(object2));
        }
    }

    @Test
    public void testSerializeDeserializeThenCompare() throws Exception {
        Object object = this.makeObject();
        if (object instanceof Serializable && this.isTestSerialization()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            Object object2 = objectInputStream.readObject();
            objectInputStream.close();
            if (this.isEqualsCheckable()) {
                Assert.assertEquals((String)"obj != deserialize(serialize(obj))", (Object)object, (Object)object2);
            }
        }
    }

    @Test
    public void testSimpleSerialization() throws Exception {
        Object object = this.makeObject();
        if (object instanceof Serializable && this.isTestSerialization()) {
            byte[] byArray = this.writeExternalFormToBytes((Serializable)object);
            Object object2 = this.readExternalFormFromBytes(byArray);
        }
    }

    @Test
    public void testCanonicalEmptyCollectionExists() {
        Object object;
        if (this.supportsEmptyCollections() && this.isTestSerialization() && !this.skipSerializedCanonicalTests() && (object = this.makeObject()) instanceof Serializable) {
            String string = this.getCanonicalEmptyCollectionName(object);
            Assert.assertTrue((String)("Canonical empty collection (" + string + ") is not in CVS"), (boolean)new File(string).exists());
        }
    }

    @Test
    public void testCanonicalFullCollectionExists() {
        Object object;
        if (this.supportsFullCollections() && this.isTestSerialization() && !this.skipSerializedCanonicalTests() && (object = this.makeObject()) instanceof Serializable) {
            String string = this.getCanonicalFullCollectionName(object);
            Assert.assertTrue((String)("Canonical full collection (" + string + ") is not in CVS"), (boolean)new File(string).exists());
        }
    }

    public String getCompatibilityVersion() {
        return "1";
    }

    protected String getCanonicalEmptyCollectionName(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("data/test/");
        String string = object.getClass().getName();
        string = string.substring(string.lastIndexOf(".") + 1, string.length());
        stringBuilder.append(string);
        stringBuilder.append(".emptyCollection.version");
        stringBuilder.append(this.getCompatibilityVersion());
        stringBuilder.append(".obj");
        return stringBuilder.toString();
    }

    protected String getCanonicalFullCollectionName(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("data/test/");
        String string = object.getClass().getName();
        string = string.substring(string.lastIndexOf(".") + 1, string.length());
        stringBuilder.append(string);
        stringBuilder.append(".fullCollection.version");
        stringBuilder.append(this.getCompatibilityVersion());
        stringBuilder.append(".obj");
        return stringBuilder.toString();
    }

    protected void writeExternalFormToDisk(Serializable serializable, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        this.writeExternalFormToStream(serializable, fileOutputStream);
    }

    protected byte[] writeExternalFormToBytes(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeExternalFormToStream(serializable, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected Object readExternalFormFromDisk(String string) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(string);
        return this.readExternalFormFromStream(fileInputStream);
    }

    protected Object readExternalFormFromBytes(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return this.readExternalFormFromStream(byteArrayInputStream);
    }

    protected boolean skipSerializedCanonicalTests() {
        return Boolean.getBoolean("org.apache.commons.collections:with-clover");
    }

    private Object readExternalFormFromStream(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        return objectInputStream.readObject();
    }

    private void writeExternalFormToStream(Serializable serializable, OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(serializable);
    }
}

