/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.util;

import com.twelvemonkeys.util.CollectionAbstractTest;
import com.twelvemonkeys.util.ObjectAbstractTest;
import com.twelvemonkeys.util.SetAbstractTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public abstract class MapAbstractTest
extends ObjectAbstractTest {
    private static final boolean JDK12;
    protected Map map;
    protected Set entrySet;
    protected Set keySet;
    protected Collection values;
    protected Map confirmed;

    @Override
    protected boolean skipSerializedCanonicalTests() {
        return true;
    }

    public boolean isPutAddSupported() {
        return true;
    }

    public boolean isPutChangeSupported() {
        return true;
    }

    public boolean isSetValueSupported() {
        return this.isPutChangeSupported();
    }

    public boolean isRemoveSupported() {
        return true;
    }

    public boolean isGetStructuralModify() {
        return false;
    }

    public boolean isSubMapViewsSerializable() {
        return true;
    }

    public boolean isAllowNullKey() {
        return true;
    }

    public boolean isAllowNullValue() {
        return true;
    }

    public boolean isAllowDuplicateValues() {
        return true;
    }

    public Object[] getSampleKeys() {
        Object[] objectArray = new Object[]{"blah", "foo", "bar", "baz", "tmp", "gosh", "golly", "gee", "hello", "goodbye", "we'll", "see", "you", "all", "again", "key", "key2", this.isAllowNullKey() && !JDK12 ? null : "nonnullkey"};
        return objectArray;
    }

    public Object[] getOtherKeys() {
        return this.getOtherNonNullStringElements();
    }

    public Object[] getOtherValues() {
        return this.getOtherNonNullStringElements();
    }

    public Object[] getOtherNonNullStringElements() {
        return new Object[]{"For", "then", "despite", "space", "I", "would", "be", "brought", "From", "limits", "far", "remote", "where", "thou", "dost", "stay"};
    }

    public Object[] getSampleValues() {
        Object[] objectArray = new Object[]{"blahv", "foov", "barv", "bazv", "tmpv", "goshv", "gollyv", "geev", "hellov", "goodbyev", "we'llv", "seev", "youv", "allv", "againv", this.isAllowNullValue() && !JDK12 ? null : "nonnullvalue", "value", this.isAllowDuplicateValues() ? "value" : "value2"};
        return objectArray;
    }

    public Object[] getNewSampleValues() {
        Object[] objectArray = new Object[]{this.isAllowNullValue() && !JDK12 && this.isAllowDuplicateValues() ? null : "newnonnullvalue", "newvalue", this.isAllowDuplicateValues() ? "newvalue" : "newvalue2", "newblahv", "newfoov", "newbarv", "newbazv", "newtmpv", "newgoshv", "newgollyv", "newgeev", "newhellov", "newgoodbyev", "newwe'llv", "newseev", "newyouv", "newallv", "newagainv"};
        return objectArray;
    }

    public void addSampleMappings(Map map) {
        Object[] objectArray = this.getSampleKeys();
        Object[] objectArray2 = this.getSampleValues();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                map.put(objectArray[i], objectArray2[i]);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                Assert.assertTrue((String)"NullPointerException only allowed to be thrown if either the key or value is null.", (objectArray[i] == null || objectArray2[i] == null ? 1 : 0) != 0);
                Assert.assertTrue((String)"NullPointerException on null key, but isAllowNullKey is not overridden to return false.", (objectArray[i] == null || !this.isAllowNullKey() ? 1 : 0) != 0);
                Assert.assertTrue((String)"NullPointerException on null value, but isAllowNullValue is not overridden to return false.", (objectArray2[i] == null || !this.isAllowNullValue() ? 1 : 0) != 0);
                Assert.assertTrue((String)"Unknown reason for NullPointer.", (boolean)false);
            }
        }
        Assert.assertEquals((String)"size must reflect number of mappings added.", (long)objectArray.length, (long)map.size());
    }

    public abstract Map makeEmptyMap();

    public Map makeFullMap() {
        Map map = this.makeEmptyMap();
        this.addSampleMappings(map);
        return map;
    }

    @Override
    public Object makeObject() {
        return this.makeEmptyMap();
    }

    public Map makeConfirmedMap() {
        return new HashMap();
    }

    public Map.Entry cloneMapEntry(Map.Entry entry) {
        HashMap hashMap = new HashMap();
        hashMap.put(entry.getKey(), entry.getValue());
        return hashMap.entrySet().iterator().next();
    }

    @Override
    public String getCompatibilityVersion() {
        return super.getCompatibilityVersion();
    }

    @Test
    public void testSampleMappings() {
        Object[] objectArray = this.getSampleKeys();
        Object[] objectArray2 = this.getSampleValues();
        Object[] objectArray3 = this.getNewSampleValues();
        Assert.assertTrue((String)"failure in test: Must have keys returned from getSampleKeys.", (objectArray != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"failure in test: Must have values returned from getSampleValues.", (objectArray2 != null ? 1 : 0) != 0);
        Assert.assertEquals((String)"failure in test: not the same number of sample keys and values.", (long)objectArray.length, (long)objectArray2.length);
        Assert.assertEquals((String)"failure in test: not the same number of values and new values.", (long)objectArray2.length, (long)objectArray3.length);
        for (int i = 0; i < objectArray.length - 1; ++i) {
            for (int j = i + 1; j < objectArray.length; ++j) {
                Assert.assertTrue((String)"failure in test: duplicate null keys.", (objectArray[i] != null || objectArray[j] != null ? 1 : 0) != 0);
                Assert.assertTrue((String)"failure in test: duplicate non-null key.", (objectArray[i] == null || objectArray[j] == null || !objectArray[i].equals(objectArray[j]) && !objectArray[j].equals(objectArray[i]) ? 1 : 0) != 0);
            }
            Assert.assertTrue((String)"failure in test: found null key, but isNullKeySupported is false.", (objectArray[i] != null || this.isAllowNullKey() ? 1 : 0) != 0);
            Assert.assertTrue((String)"failure in test: found null value, but isNullValueSupported is false.", (objectArray2[i] != null || this.isAllowNullValue() ? 1 : 0) != 0);
            Assert.assertTrue((String)"failure in test: found null new value, but isNullValueSupported is false.", (objectArray3[i] != null || this.isAllowNullValue() ? 1 : 0) != 0);
            Assert.assertTrue((String)"failure in test: values should not be the same as new value", (objectArray2[i] != objectArray3[i] && (objectArray2[i] == null || !objectArray2[i].equals(objectArray3[i])) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMakeMap() {
        Map map = this.makeEmptyMap();
        Assert.assertTrue((String)"failure in test: makeEmptyMap must return a non-null map.", (map != null ? 1 : 0) != 0);
        Map map2 = this.makeEmptyMap();
        Assert.assertTrue((String)"failure in test: makeEmptyMap must return a non-null map.", (map2 != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"failure in test: makeEmptyMap must return a new map with each invocation.", (map != map2 ? 1 : 0) != 0);
        Map map3 = this.makeFullMap();
        Assert.assertTrue((String)"failure in test: makeFullMap must return a non-null map.", (map3 != null ? 1 : 0) != 0);
        Map map4 = this.makeFullMap();
        Assert.assertTrue((String)"failure in test: makeFullMap must return a non-null map.", (map4 != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"failure in test: makeFullMap must return a new map with each invocation.", (map3 != map4 ? 1 : 0) != 0);
    }

    @Test
    public void testMapIsEmpty() {
        this.resetEmpty();
        Assert.assertEquals((String)"Map.isEmpty() should return true with an empty map", (Object)true, (Object)this.map.isEmpty());
        this.verifyAll();
        this.resetFull();
        Assert.assertEquals((String)"Map.isEmpty() should return false with a non-empty map", (Object)false, (Object)this.map.isEmpty());
        this.verifyAll();
    }

    @Test
    public void testMapSize() {
        this.resetEmpty();
        Assert.assertEquals((String)"Map.size() should be 0 with an empty map", (long)0L, (long)this.map.size());
        this.verifyAll();
        this.resetFull();
        Assert.assertEquals((String)"Map.size() should equal the number of entries in the map", (long)this.getSampleKeys().length, (long)this.map.size());
        this.verifyAll();
    }

    @Test
    public void testMapClear() {
        if (!this.isRemoveSupported()) {
            try {
                this.resetFull();
                this.map.clear();
                Assert.fail((String)"Expected UnsupportedOperationException on clear");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return;
        }
        this.resetEmpty();
        this.map.clear();
        this.confirmed.clear();
        this.verifyAll();
        this.resetFull();
        this.map.clear();
        this.confirmed.clear();
        this.verifyAll();
    }

    @Test
    public void testMapContainsKey() {
        Object[] objectArray = this.getSampleKeys();
        this.resetEmpty();
        for (Object object : objectArray) {
            Assert.assertTrue((String)"Map must not contain key when map is empty", (!this.map.containsKey(object) ? 1 : 0) != 0);
        }
        this.verifyAll();
        this.resetFull();
        for (Object object : objectArray) {
            Assert.assertTrue((String)("Map must contain key for a mapping in the map. Missing: " + object), (boolean)this.map.containsKey(object));
        }
        this.verifyAll();
    }

    @Test
    public void testMapContainsValue() {
        Object[] objectArray = this.getSampleValues();
        this.resetEmpty();
        for (Object object : objectArray) {
            Assert.assertTrue((String)"Empty map must not contain value", (!this.map.containsValue(object) ? 1 : 0) != 0);
        }
        this.verifyAll();
        this.resetFull();
        for (Object object : objectArray) {
            Assert.assertTrue((String)"Map must contain value for a mapping in the map.", (boolean)this.map.containsValue(object));
        }
        this.verifyAll();
    }

    @Test
    public void testMapEquals() {
        this.resetEmpty();
        Assert.assertTrue((String)"Empty maps unequal.", (boolean)this.map.equals(this.confirmed));
        this.verifyAll();
        this.resetFull();
        Assert.assertTrue((String)"Full maps unequal.", (boolean)this.map.equals(this.confirmed));
        this.verifyAll();
        this.resetFull();
        Iterator iterator = this.confirmed.keySet().iterator();
        iterator.next();
        iterator.remove();
        Assert.assertTrue((String)"Different maps equal.", (!this.map.equals(this.confirmed) ? 1 : 0) != 0);
        this.resetFull();
        Assert.assertTrue((String)"equals(null) returned true.", (!this.map.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals(new Object()) returned true.", (!this.map.equals(new Object()) ? 1 : 0) != 0);
        this.verifyAll();
    }

    @Test
    public void testMapGet() {
        this.resetEmpty();
        Object[] objectArray = this.getSampleKeys();
        Object[] objectArray2 = this.getSampleValues();
        for (Object object : objectArray) {
            Assert.assertTrue((String)"Empty map.get() should return null.", (this.map.get(object) == null ? 1 : 0) != 0);
        }
        this.verifyAll();
        this.resetFull();
        for (int i = 0; i < objectArray.length; ++i) {
            Assert.assertEquals((String)"Full map.get() should return value from mapping.", (Object)objectArray2[i], this.map.get(objectArray[i]));
        }
    }

    @Test
    public void testMapHashCode() {
        this.resetEmpty();
        Assert.assertTrue((String)"Empty maps have different hashCodes.", (this.map.hashCode() == this.confirmed.hashCode() ? 1 : 0) != 0);
        this.resetFull();
        Assert.assertTrue((String)"Equal maps have different hashCodes.", (this.map.hashCode() == this.confirmed.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testMapToString() {
        this.resetEmpty();
        Assert.assertTrue((String)"Empty map toString() should not return null", (this.map.toString() != null ? 1 : 0) != 0);
        this.verifyAll();
        this.resetFull();
        Assert.assertTrue((String)"Empty map toString() should not return null", (this.map.toString() != null ? 1 : 0) != 0);
        this.verifyAll();
    }

    @Test
    public void testMapPut() {
        this.resetEmpty();
        Object[] objectArray = this.getSampleKeys();
        Object[] objectArray2 = this.getSampleValues();
        Object[] objectArray3 = this.getNewSampleValues();
        if (this.isPutAddSupported()) {
            Object object;
            int n;
            for (n = 0; n < objectArray.length; ++n) {
                object = this.map.put(objectArray[n], objectArray2[n]);
                this.confirmed.put(objectArray[n], objectArray2[n]);
                this.verifyAll();
                Assert.assertTrue((String)"First map.put should return null", (object == null ? 1 : 0) != 0);
                Assert.assertTrue((String)"Map should contain key after put", (boolean)this.map.containsKey(objectArray[n]));
                Assert.assertTrue((String)"Map should contain value after put", (boolean)this.map.containsValue(objectArray2[n]));
            }
            if (this.isPutChangeSupported()) {
                for (n = 0; n < objectArray.length; ++n) {
                    object = this.map.put(objectArray[n], objectArray3[n]);
                    this.confirmed.put(objectArray[n], objectArray3[n]);
                    this.verifyAll();
                    Assert.assertEquals((String)"Map.put should return previous value when changed", (Object)objectArray2[n], (Object)object);
                    Assert.assertTrue((String)"Map should still contain key after put when changed", (boolean)this.map.containsKey(objectArray[n]));
                    Assert.assertTrue((String)"Map should contain new value after put when changed", (boolean)this.map.containsValue(objectArray3[n]));
                    if (this.isAllowDuplicateValues()) continue;
                    Assert.assertTrue((String)"Map should not contain old value after put when changed", (!this.map.containsValue(objectArray2[n]) ? 1 : 0) != 0);
                }
            } else {
                try {
                    this.map.put(objectArray[0], objectArray3[0]);
                    Assert.fail((String)"Expected IllegalArgumentException or UnsupportedOperationException on put (change)");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        } else if (this.isPutChangeSupported()) {
            this.resetEmpty();
            try {
                this.map.put(objectArray[0], objectArray2[0]);
                Assert.fail((String)"Expected UnsupportedOperationException or IllegalArgumentException on put (add) when fixed size");
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.resetFull();
            Iterator iterator = this.map.keySet().iterator();
            for (int i = 0; iterator.hasNext() && i < objectArray3.length; ++i) {
                Object k = iterator.next();
                Object object = this.map.put(k, objectArray3[i]);
                Object object2 = this.confirmed.put(k, objectArray3[i]);
                this.verifyAll();
                Assert.assertEquals((String)"Map.put should return previous value when changed", (Object)object2, (Object)object);
                Assert.assertTrue((String)"Map should still contain key after put when changed", (boolean)this.map.containsKey(k));
                Assert.assertTrue((String)"Map should contain new value after put when changed", (boolean)this.map.containsValue(objectArray3[i]));
                if (this.isAllowDuplicateValues()) continue;
                Assert.assertTrue((String)"Map should not contain old value after put when changed", (!this.map.containsValue(objectArray2[i]) ? 1 : 0) != 0);
            }
        } else {
            try {
                this.map.put(objectArray[0], objectArray2[0]);
                Assert.fail((String)"Expected UnsupportedOperationException on put (add)");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testMapPutNullKey() {
        this.resetFull();
        Object[] objectArray = this.getSampleValues();
        if (this.isPutAddSupported()) {
            if (this.isAllowNullKey()) {
                this.map.put(null, objectArray[0]);
            } else {
                try {
                    this.map.put(null, objectArray[0]);
                    Assert.fail((String)"put(null, value) should throw NPE/IAE");
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testMapPutNullValue() {
        this.resetFull();
        Object[] objectArray = this.getSampleKeys();
        if (this.isPutAddSupported()) {
            if (this.isAllowNullValue()) {
                this.map.put(objectArray[0], null);
            } else {
                try {
                    this.map.put(objectArray[0], null);
                    Assert.fail((String)"put(key, null) should throw NPE/IAE");
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    public void testMapPutAll() {
        if (!this.isPutAddSupported()) {
            if (!this.isPutChangeSupported()) {
                Map map = this.makeFullMap();
                this.resetEmpty();
                try {
                    this.map.putAll(map);
                    Assert.fail((String)"Expected UnsupportedOperationException on putAll");
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            return;
        }
        this.resetEmpty();
        Map map = this.makeFullMap();
        this.map.putAll(map);
        this.confirmed.putAll(map);
        this.verifyAll();
        this.resetEmpty();
        map = this.makeConfirmedMap();
        Object[] objectArray = this.getSampleKeys();
        Object[] objectArray2 = this.getSampleValues();
        for (int i = 0; i < objectArray.length; ++i) {
            map.put(objectArray[i], objectArray2[i]);
        }
        this.map.putAll(map);
        this.confirmed.putAll(map);
        this.verifyAll();
    }

    @Test
    public void testMapRemove() {
        Object v;
        int n;
        if (!this.isRemoveSupported()) {
            try {
                this.resetFull();
                this.map.remove(this.map.keySet().iterator().next());
                Assert.fail((String)"Expected UnsupportedOperationException on remove");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return;
        }
        this.resetEmpty();
        Object[] objectArray = this.getSampleKeys();
        Object[] objectArray2 = this.getSampleValues();
        for (n = 0; n < objectArray.length; ++n) {
            v = this.map.remove(objectArray[n]);
            Assert.assertTrue((String)"First map.remove should return null", (v == null ? 1 : 0) != 0);
        }
        this.verifyAll();
        this.resetFull();
        for (n = 0; n < objectArray.length; ++n) {
            v = this.map.remove(objectArray[n]);
            this.confirmed.remove(objectArray[n]);
            this.verifyAll();
            Assert.assertEquals((String)"map.remove with valid key should return value", (Object)objectArray2[n], v);
        }
        Object[] objectArray3 = this.getOtherKeys();
        this.resetFull();
        int n2 = this.map.size();
        for (int i = 0; i < objectArray3.length; ++i) {
            Object v2 = this.map.remove(objectArray3[i]);
            Assert.assertEquals((String)"map.remove for nonexistent key should return null", v2, null);
            Assert.assertEquals((String)"map.remove for nonexistent key should not shrink map", (long)n2, (long)this.map.size());
        }
        this.verifyAll();
    }

    @Test
    public void testValuesClearChangesMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Collection collection = this.map.values();
        Assert.assertTrue((this.map.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((collection.size() > 0 ? 1 : 0) != 0);
        collection.clear();
        Assert.assertTrue((this.map.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((collection.size() == 0 ? 1 : 0) != 0);
        this.resetFull();
        collection = this.map.values();
        Assert.assertTrue((this.map.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((collection.size() > 0 ? 1 : 0) != 0);
        this.map.clear();
        Assert.assertTrue((this.map.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((collection.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testKeySetClearChangesMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Set set = this.map.keySet();
        Assert.assertTrue((this.map.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((set.size() > 0 ? 1 : 0) != 0);
        set.clear();
        Assert.assertTrue((this.map.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((set.size() == 0 ? 1 : 0) != 0);
        this.resetFull();
        set = this.map.keySet();
        Assert.assertTrue((this.map.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((set.size() > 0 ? 1 : 0) != 0);
        this.map.clear();
        Assert.assertTrue((this.map.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((set.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEntrySetClearChangesMap() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        Set set = this.map.entrySet();
        Assert.assertTrue((this.map.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((set.size() > 0 ? 1 : 0) != 0);
        set.clear();
        Assert.assertTrue((this.map.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((set.size() == 0 ? 1 : 0) != 0);
        this.resetFull();
        set = this.map.entrySet();
        Assert.assertTrue((this.map.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((set.size() > 0 ? 1 : 0) != 0);
        this.map.clear();
        Assert.assertTrue((this.map.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((set.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEntrySetContains1() {
        this.resetFull();
        Set set = this.map.entrySet();
        Map.Entry entry = set.iterator().next();
        Assert.assertEquals((Object)true, (Object)set.contains(entry));
    }

    @Test
    public void testEntrySetContains2() {
        this.resetFull();
        Set set = this.map.entrySet();
        Map.Entry entry = set.iterator().next();
        Map.Entry entry2 = this.cloneMapEntry(entry);
        Assert.assertEquals((Object)true, (Object)set.contains(entry2));
    }

    @Test
    public void testEntrySetContains3() {
        this.resetFull();
        Set set = this.map.entrySet();
        Map.Entry entry = set.iterator().next();
        HashMap hashMap = new HashMap();
        hashMap.put(entry.getKey(), "A VERY DIFFERENT VALUE");
        Map.Entry entry2 = hashMap.entrySet().iterator().next();
        Assert.assertEquals((Object)false, (Object)set.contains(entry2));
    }

    @Test
    public void testEntrySetRemove1() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int n = this.map.size();
        Set set = this.map.entrySet();
        Map.Entry entry = set.iterator().next();
        Object k = entry.getKey();
        Assert.assertEquals((Object)true, (Object)set.remove(entry));
        Assert.assertEquals((Object)false, (Object)this.map.containsKey(k));
        Assert.assertEquals((long)(n - 1), (long)this.map.size());
    }

    @Test
    public void testEntrySetRemove2() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int n = this.map.size();
        Set set = this.map.entrySet();
        Map.Entry entry = set.iterator().next();
        Object k = entry.getKey();
        Map.Entry entry2 = this.cloneMapEntry(entry);
        Assert.assertEquals((Object)true, (Object)set.remove(entry2));
        Assert.assertEquals((Object)false, (Object)this.map.containsKey(k));
        Assert.assertEquals((long)(n - 1), (long)this.map.size());
    }

    @Test
    public void testEntrySetRemove3() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetFull();
        int n = this.map.size();
        Set set = this.map.entrySet();
        Map.Entry entry = set.iterator().next();
        Object k = entry.getKey();
        HashMap hashMap = new HashMap();
        hashMap.put(entry.getKey(), "A VERY DIFFERENT VALUE");
        Map.Entry entry2 = hashMap.entrySet().iterator().next();
        Assert.assertEquals((Object)false, (Object)set.remove(entry2));
        Assert.assertEquals((Object)true, (Object)this.map.containsKey(k));
        Assert.assertEquals((long)n, (long)this.map.size());
    }

    @Test
    public void testValuesRemoveChangesMap() {
        this.resetFull();
        Object[] objectArray = this.getSampleValues();
        Collection collection = this.map.values();
        for (int i = 0; i < objectArray.length; ++i) {
            int n;
            if (!this.map.containsValue(objectArray[i])) continue;
            for (n = 0; collection.contains(objectArray[i]) && n < 10000; ++n) {
                try {
                    collection.remove(objectArray[i]);
                    continue;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    return;
                }
            }
            Assert.assertTrue((String)"values().remove(obj) is broken", (n < 10000 ? 1 : 0) != 0);
            Assert.assertTrue((String)"Value should have been removed from the underlying map.", (!this.map.containsValue(objectArray[i]) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testKeySetRemoveChangesMap() {
        this.resetFull();
        Object[] objectArray = this.getSampleKeys();
        Set set = this.map.keySet();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                set.remove(objectArray[i]);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return;
            }
            Assert.assertTrue((String)"Key should have been removed from the underlying map.", (!this.map.containsKey(objectArray[i]) ? 1 : 0) != 0);
        }
    }

    private Map.Entry[] makeEntryArray(Object[] objectArray, Object[] objectArray2) {
        Map.Entry[] entryArray = new Map.Entry[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Map map = this.makeConfirmedMap();
            map.put(objectArray[i], objectArray2[i]);
            entryArray[i] = map.entrySet().iterator().next();
        }
        return entryArray;
    }

    public void resetEmpty() {
        this.map = this.makeEmptyMap();
        this.views();
        this.confirmed = this.makeConfirmedMap();
    }

    public void resetFull() {
        this.map = this.makeFullMap();
        this.views();
        this.confirmed = this.makeConfirmedMap();
        Object[] objectArray = this.getSampleKeys();
        Object[] objectArray2 = this.getSampleValues();
        for (int i = 0; i < objectArray.length; ++i) {
            this.confirmed.put(objectArray[i], objectArray2[i]);
        }
    }

    private void views() {
        this.keySet = this.map.keySet();
        this.values = this.map.values();
        this.entrySet = this.map.entrySet();
    }

    public void verifyAll() {
        this.verifyMap();
        this.verifyEntrySet();
        this.verifyKeySet();
        this.verifyValues();
    }

    public void verifyMap() {
        int n = this.confirmed.size();
        boolean bl = this.confirmed.isEmpty();
        Assert.assertEquals((String)"Map should be same size as HashMap", (long)n, (long)this.map.size());
        Assert.assertEquals((String)"Map should be empty if HashMap is", (Object)bl, (Object)this.map.isEmpty());
        Assert.assertEquals((String)"hashCodes should be the same", (long)this.confirmed.hashCode(), (long)this.map.hashCode());
        Assert.assertTrue((String)"Map should still equal HashMap", (boolean)this.map.equals(this.confirmed));
    }

    public void verifyEntrySet() {
        int n = this.confirmed.size();
        boolean bl = this.confirmed.isEmpty();
        Assert.assertEquals((String)("entrySet should be same size as HashMap's\nTest: " + this.entrySet + "\nReal: " + this.confirmed.entrySet()), (long)n, (long)this.entrySet.size());
        Assert.assertEquals((String)("entrySet should be empty if HashMap is\nTest: " + this.entrySet + "\nReal: " + this.confirmed.entrySet()), (Object)bl, (Object)this.entrySet.isEmpty());
        Assert.assertTrue((String)("entrySet should contain all HashMap's elements\nTest: " + this.entrySet + "\nReal: " + this.confirmed.entrySet()), (boolean)this.entrySet.containsAll(this.confirmed.entrySet()));
        Assert.assertEquals((String)("entrySet hashCodes should be the same\nTest: " + this.entrySet + "\nReal: " + this.confirmed.entrySet()), (long)this.confirmed.entrySet().hashCode(), (long)this.entrySet.hashCode());
        Assert.assertEquals((String)"Map's entry set should still equal HashMap's", this.confirmed.entrySet(), (Object)this.entrySet);
    }

    public void verifyKeySet() {
        int n = this.confirmed.size();
        boolean bl = this.confirmed.isEmpty();
        Assert.assertEquals((String)("keySet should be same size as HashMap's\nTest: " + this.keySet + "\nReal: " + this.confirmed.keySet()), (long)n, (long)this.keySet.size());
        Assert.assertEquals((String)("keySet should be empty if HashMap is\nTest: " + this.keySet + "\nReal: " + this.confirmed.keySet()), (Object)bl, (Object)this.keySet.isEmpty());
        Assert.assertTrue((String)("keySet should contain all HashMap's elements\nTest: " + this.keySet + "\nReal: " + this.confirmed.keySet()), (boolean)this.keySet.containsAll(this.confirmed.keySet()));
        Assert.assertEquals((String)("keySet hashCodes should be the same\nTest: " + this.keySet + "\nReal: " + this.confirmed.keySet()), (long)this.confirmed.keySet().hashCode(), (long)this.keySet.hashCode());
        Assert.assertEquals((String)"Map's key set should still equal HashMap's", this.confirmed.keySet(), (Object)this.keySet);
    }

    public void verifyValues() {
        ArrayList arrayList = new ArrayList(this.confirmed.values());
        ArrayList arrayList2 = new ArrayList(this.values);
        int n = this.confirmed.size();
        boolean bl = this.confirmed.isEmpty();
        Assert.assertEquals((String)("values should be same size as HashMap's\nTest: " + arrayList2 + "\nReal: " + arrayList), (long)n, (long)this.values.size());
        Assert.assertEquals((String)("values should be empty if HashMap is\nTest: " + arrayList2 + "\nReal: " + arrayList), (Object)bl, (Object)this.values.isEmpty());
        Assert.assertTrue((String)("values should contain all HashMap's elements\nTest: " + arrayList2 + "\nReal: " + arrayList), (boolean)arrayList2.containsAll(arrayList));
        Assert.assertTrue((String)("values should contain all HashMap's elements\nTest: " + arrayList2 + "\nReal: " + arrayList), (boolean)arrayList.containsAll(arrayList2));
        for (Object e : arrayList) {
            boolean bl2 = arrayList2.remove(e);
            Assert.assertTrue((String)"Map's values should still equal HashMap's", (boolean)bl2);
        }
        Assert.assertTrue((String)"Map's values should still equal HashMap's", (boolean)arrayList2.isEmpty());
    }

    @After
    public void tearDown() throws Exception {
        this.map = null;
        this.keySet = null;
        this.entrySet = null;
        this.values = null;
        this.confirmed = null;
    }

    static {
        String string = System.getProperty("java.version");
        JDK12 = string.startsWith("1.2");
    }

    public class TestMapValues
    extends CollectionAbstractTest {
        @Override
        public Object[] getFullElements() {
            return MapAbstractTest.this.getSampleValues();
        }

        @Override
        public Object[] getOtherElements() {
            return MapAbstractTest.this.getOtherValues();
        }

        @Override
        public Collection makeCollection() {
            return MapAbstractTest.this.makeEmptyMap().values();
        }

        @Override
        public Collection makeFullCollection() {
            return MapAbstractTest.this.makeFullMap().values();
        }

        @Override
        public boolean isNullSupported() {
            return MapAbstractTest.this.isAllowNullKey();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return MapAbstractTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public boolean areEqualElementsDistinguishable() {
            return true;
        }

        @Override
        public Collection makeConfirmedCollection() {
            return null;
        }

        @Override
        public Collection makeConfirmedFullCollection() {
            return null;
        }

        @Override
        public void resetFull() {
            MapAbstractTest.this.resetFull();
            this.collection = MapAbstractTest.this.map.values();
            this.confirmed = MapAbstractTest.this.confirmed.values();
        }

        @Override
        public void resetEmpty() {
            MapAbstractTest.this.resetEmpty();
            this.collection = MapAbstractTest.this.map.values();
            this.confirmed = MapAbstractTest.this.confirmed.values();
        }

        @Override
        public void verifyAll() {
            super.verifyAll();
            MapAbstractTest.this.verifyAll();
        }
    }

    public class TestMapKeySet
    extends SetAbstractTest {
        @Override
        public Object[] getFullElements() {
            return MapAbstractTest.this.getSampleKeys();
        }

        @Override
        public Object[] getOtherElements() {
            return MapAbstractTest.this.getOtherKeys();
        }

        @Override
        public Set makeEmptySet() {
            return MapAbstractTest.this.makeEmptyMap().keySet();
        }

        @Override
        public Set makeFullSet() {
            return MapAbstractTest.this.makeFullMap().keySet();
        }

        @Override
        public boolean isNullSupported() {
            return MapAbstractTest.this.isAllowNullKey();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return MapAbstractTest.this.isRemoveSupported();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public void resetEmpty() {
            MapAbstractTest.this.resetEmpty();
            this.collection = MapAbstractTest.this.map.keySet();
            this.confirmed = MapAbstractTest.this.confirmed.keySet();
        }

        @Override
        public void resetFull() {
            MapAbstractTest.this.resetFull();
            this.collection = MapAbstractTest.this.map.keySet();
            this.confirmed = MapAbstractTest.this.confirmed.keySet();
        }

        @Override
        public void verifyAll() {
            super.verifyAll();
            MapAbstractTest.this.verifyAll();
        }
    }

    public class TestMapEntrySet
    extends SetAbstractTest {
        @Override
        public Object[] getFullElements() {
            Object[] objectArray = MapAbstractTest.this.getSampleKeys();
            Object[] objectArray2 = MapAbstractTest.this.getSampleValues();
            return MapAbstractTest.this.makeEntryArray(objectArray, objectArray2);
        }

        @Override
        public Object[] getOtherElements() {
            Object[] objectArray = MapAbstractTest.this.getOtherKeys();
            Object[] objectArray2 = MapAbstractTest.this.getOtherValues();
            return MapAbstractTest.this.makeEntryArray(objectArray, objectArray2);
        }

        @Override
        public Set makeEmptySet() {
            return MapAbstractTest.this.makeEmptyMap().entrySet();
        }

        @Override
        public Set makeFullSet() {
            return MapAbstractTest.this.makeFullMap().entrySet();
        }

        @Override
        public boolean isAddSupported() {
            return false;
        }

        @Override
        public boolean isRemoveSupported() {
            return MapAbstractTest.this.isRemoveSupported();
        }

        public boolean isGetStructuralModify() {
            return MapAbstractTest.this.isGetStructuralModify();
        }

        @Override
        public boolean isTestSerialization() {
            return false;
        }

        @Override
        public void resetFull() {
            MapAbstractTest.this.resetFull();
            this.collection = MapAbstractTest.this.map.entrySet();
            this.confirmed = MapAbstractTest.this.confirmed.entrySet();
        }

        @Override
        public void resetEmpty() {
            MapAbstractTest.this.resetEmpty();
            this.collection = MapAbstractTest.this.map.entrySet();
            this.confirmed = MapAbstractTest.this.confirmed.entrySet();
        }

        @Test
        public void testMapEntrySetIteratorEntry() {
            this.resetFull();
            Iterator iterator = this.collection.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Assert.assertEquals((Object)true, (Object)MapAbstractTest.this.map.containsKey(entry.getKey()));
                Assert.assertEquals((Object)true, (Object)MapAbstractTest.this.map.containsValue(entry.getValue()));
                if (!this.isGetStructuralModify()) {
                    Assert.assertEquals(MapAbstractTest.this.map.get(entry.getKey()), entry.getValue());
                }
                ++n;
            }
            Assert.assertEquals((long)this.collection.size(), (long)n);
        }

        @Test
        public void testMapEntrySetIteratorEntrySetValue() {
            Object object = MapAbstractTest.this.getSampleKeys()[0];
            Object object2 = MapAbstractTest.this.getSampleKeys().length == 1 ? MapAbstractTest.this.getSampleKeys()[0] : MapAbstractTest.this.getSampleKeys()[1];
            Object object3 = MapAbstractTest.this.getNewSampleValues()[0];
            Object object4 = MapAbstractTest.this.getNewSampleValues().length == 1 ? MapAbstractTest.this.getNewSampleValues()[0] : MapAbstractTest.this.getNewSampleValues()[1];
            this.resetFull();
            Iterator iterator = this.collection.iterator();
            Map.Entry entry = this.getEntry(iterator, object);
            iterator = this.collection.iterator();
            Map.Entry entry2 = this.getEntry(iterator, object2);
            Iterator iterator2 = this.confirmed.iterator();
            Map.Entry entry3 = this.getEntry(iterator2, object);
            iterator2 = this.confirmed.iterator();
            Map.Entry entry4 = this.getEntry(iterator2, object2);
            this.verifyAll();
            if (!MapAbstractTest.this.isSetValueSupported()) {
                try {
                    entry.setValue(object3);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                return;
            }
            entry.setValue(object3);
            entry3.setValue(object3);
            Assert.assertEquals((Object)object3, entry.getValue());
            Assert.assertEquals((Object)true, (Object)MapAbstractTest.this.map.containsKey(entry.getKey()));
            Assert.assertEquals((Object)true, (Object)MapAbstractTest.this.map.containsValue(object3));
            Assert.assertEquals((Object)object3, MapAbstractTest.this.map.get(entry.getKey()));
            this.verifyAll();
            entry.setValue(object3);
            entry3.setValue(object3);
            Assert.assertEquals((Object)object3, entry.getValue());
            Assert.assertEquals((Object)true, (Object)MapAbstractTest.this.map.containsKey(entry.getKey()));
            Assert.assertEquals((Object)true, (Object)MapAbstractTest.this.map.containsValue(object3));
            Assert.assertEquals((Object)object3, MapAbstractTest.this.map.get(entry.getKey()));
            this.verifyAll();
            entry2.setValue(object4);
            entry4.setValue(object4);
            Assert.assertEquals((Object)object4, entry2.getValue());
            Assert.assertEquals((Object)true, (Object)MapAbstractTest.this.map.containsKey(entry2.getKey()));
            Assert.assertEquals((Object)true, (Object)MapAbstractTest.this.map.containsValue(object4));
            Assert.assertEquals((Object)object4, MapAbstractTest.this.map.get(entry2.getKey()));
            this.verifyAll();
        }

        public Map.Entry getEntry(Iterator iterator, Object object) {
            Map.Entry entry = null;
            while (iterator.hasNext()) {
                Map.Entry entry2 = (Map.Entry)iterator.next();
                if (entry2.getKey() == null) {
                    if (object != null) continue;
                    entry = entry2;
                    break;
                }
                if (!entry2.getKey().equals(object)) continue;
                entry = entry2;
                break;
            }
            Assert.assertNotNull((String)("No matching entry in map for key '" + object + "'"), (Object)entry);
            return entry;
        }

        @Test
        public void testMapEntrySetRemoveNonMapEntry() {
            if (!this.isRemoveSupported()) {
                return;
            }
            this.resetFull();
            Assert.assertEquals((Object)false, (Object)this.getSet().remove(null));
            Assert.assertEquals((Object)false, (Object)this.getSet().remove(new Object()));
        }

        @Override
        public void verifyAll() {
            super.verifyAll();
            MapAbstractTest.this.verifyAll();
        }
    }
}

