/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

import com.twelvemonkeys.lang.Validate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.junit.Assert;
import org.junit.Test;

public class ValidateTest {
    @Test
    public void testNotNull() {
        Assert.assertEquals((Object)"foo", (Object)Validate.notNull((Object)"foo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotNullNull() {
        Validate.notNull(null);
    }

    @Test
    public void testNotNullWithParameter() {
        Assert.assertEquals((Object)"foo", (Object)Validate.notNull((Object)"foo", (String)"bar"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotNullWithParameterNull() {
        try {
            Validate.notNull(null, (String)"xyzzy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("xyzzy"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNotNullWithNullParameter() {
        Validate.notNull((Object)"foo", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotNullWithNullParameterNull() {
        Validate.notNull(null, null);
    }

    @Test
    public void testNotEmptyCharSequence() {
        Assert.assertEquals((Object)"foo", (Object)Validate.notEmpty((CharSequence)"foo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCharSequenceNull() {
        Validate.notEmpty((CharSequence)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCharSequenceEmpty() {
        Validate.notEmpty((CharSequence)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCharSequenceOnlyWS() {
        Validate.notEmpty((CharSequence)" \t\r");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCharSequenceNullWithParameter() {
        try {
            Validate.notEmpty((CharSequence)null, (String)"xyzzy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("xyzzy"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCharSequenceEmptyWithParameter() {
        try {
            Validate.notEmpty((CharSequence)"", (String)"xyzzy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("xyzzy"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCharSequenceOnlyWSWithParameter() {
        try {
            Validate.notEmpty((CharSequence)" \t", (String)"xyzzy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("xyzzy"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNotEmptyCharSequenceWithParameter() {
        Assert.assertEquals((Object)"foo", (Object)Validate.notEmpty((CharSequence)"foo", (String)"bar"));
    }

    @Test
    public void testNotEmptyCharSequenceWithParameterNull() {
        Assert.assertEquals((Object)"foo", (Object)Validate.notEmpty((CharSequence)"foo", null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCharSequenceNullWithParameterNull() {
        try {
            Validate.notEmpty((CharSequence)null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("parameter"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCharSequenceEmptyWithParameterNull() {
        try {
            Validate.notEmpty((CharSequence)"", null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("parameter"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCharSequenceOnlyWSWithParameterNull() {
        try {
            Validate.notEmpty((CharSequence)" \t\t  \n", null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("parameter"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNotEmptyArray() {
        Object[] objectArray = new Integer[2];
        Assert.assertSame((Object)objectArray, (Object)Validate.notEmpty((Object[])objectArray));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyArrayNull() {
        Validate.notEmpty((Object[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyArrayEmpty() {
        Validate.notEmpty((Object[])new String[0]);
    }

    @Test
    public void testNotEmptyArrayParameter() {
        Object[] objectArray = new Integer[2];
        Assert.assertSame((Object)objectArray, (Object)Validate.notEmpty((Object[])objectArray, (String)"bar"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyArrayNullParameter() {
        try {
            Validate.notEmpty((Object[])null, (String)"xyzzy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("xyzzy"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyArrayEmptyParameter() {
        try {
            Validate.notEmpty((Object[])new Float[0], (String)"xyzzy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("xyzzy"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNotEmptyArrayWithParameterNull() {
        Object[] objectArray = new Byte[1];
        Assert.assertSame((Object)objectArray, (Object)Validate.notEmpty((Object[])objectArray, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyArrayNullWithParameterNull() {
        try {
            Validate.notEmpty((Object[])null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("parameter"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyArrayEmptyWithParameterNull() {
        try {
            Validate.notEmpty((Object[])new Object[0], null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("parameter"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNotEmptyCollection() {
        List<Integer> list = Arrays.asList(new Integer[2]);
        Assert.assertSame(list, (Object)Validate.notEmpty(list));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCollectionNull() {
        Validate.notEmpty((Collection)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCollectionEmpty() {
        Validate.notEmpty(Collections.emptySet());
    }

    @Test
    public void testNotEmptyCollectionParameter() {
        List<Integer> list = Collections.singletonList(1);
        Assert.assertSame(list, (Object)Validate.notEmpty(list, (String)"bar"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCollectionNullParameter() {
        try {
            Validate.notEmpty((Collection)null, (String)"xyzzy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("xyzzy"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCollectionEmptyParameter() {
        try {
            Validate.notEmpty(new ArrayList(), (String)"xyzzy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("xyzzy"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNotEmptyCollectionWithParameterNull() {
        Set<Byte> set = Collections.singleton((byte)1);
        Assert.assertSame(set, (Object)Validate.notEmpty(set, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCollectionNullWithParameterNull() {
        try {
            Validate.notEmpty((Collection)null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("parameter"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyCollectionEmptyWithParameterNull() {
        try {
            Validate.notEmpty((Collection)null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("parameter"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNotEmptyMap() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>(){
            {
                this.put(1, null);
                this.put(2, null);
            }
        };
        Assert.assertSame((Object)hashMap, (Object)Validate.notEmpty((Map)hashMap));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyMapNull() {
        Validate.notEmpty((Map)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyMapEmpty() {
        Validate.notEmpty(Collections.emptyMap());
    }

    @Test
    public void testNotEmptyMapParameter() {
        Map<Integer, Object> map = Collections.singletonMap(1, null);
        Assert.assertSame(map, (Object)Validate.notEmpty(map, (String)"bar"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyMapNullParameter() {
        try {
            Validate.notEmpty((Map)null, (String)"xyzzy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("xyzzy"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyMapEmptyParameter() {
        try {
            Validate.notEmpty(new HashMap(), (String)"xyzzy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("xyzzy"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNotEmptyMapWithParameterNull() {
        Map<Byte, Object> map = Collections.singletonMap((byte)1, null);
        Assert.assertSame(map, (Object)Validate.notEmpty(map, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyMapNullWithParameterNull() {
        try {
            Validate.notEmpty((Map)null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("parameter"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNotEmptyMapEmptyWithParameterNull() {
        try {
            Validate.notEmpty((Map)null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("parameter"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNoNullElementsArray() {
        Object[] objectArray = new String[]{"foo", "bar", "baz"};
        Assert.assertSame((Object)objectArray, (Object)Validate.noNullElements((Object[])objectArray));
    }

    @Test
    public void testNoNullElementsArrayEmpty() {
        Object[] objectArray = new Object[]{};
        Assert.assertSame((Object)objectArray, (Object)Validate.noNullElements((Object[])objectArray));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsArrayNull() {
        Validate.noNullElements((Object[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsArrayNullElements() {
        Validate.noNullElements((Object[])new Object[3]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsArrayMixed() {
        Object[] objectArray = new String[]{"foo", null, "bar"};
        Validate.noNullElements((Object[])objectArray);
    }

    @Test
    public void testNoNullElementsArrayParameter() {
        Object[] objectArray = new String[]{"foo", "bar", "baz"};
        Assert.assertSame((Object)objectArray, (Object)Validate.noNullElements((Object[])objectArray, (String)"foo"));
    }

    @Test
    public void testNoNullElementsArrayEmptyParameter() {
        Object[] objectArray = new Object[]{};
        Assert.assertSame((Object)objectArray, (Object)Validate.noNullElements((Object[])objectArray, (String)"foo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsArrayNullParameter() {
        try {
            Validate.noNullElements((Object[])null, (String)"foo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("foo"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsArrayNullElementsParameter() {
        try {
            Validate.noNullElements((Object[])new Object[3], (String)"foo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("foo"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsArrayMixedParameter() {
        try {
            Validate.noNullElements((Object[])new String[]{"foo", null, "bar"}, (String)"foo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("foo"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNoNullElementsArrayParameterNull() {
        Object[] objectArray = new String[]{"foo", "bar", "baz"};
        Assert.assertSame((Object)objectArray, (Object)Validate.noNullElements((Object[])objectArray, null));
    }

    @Test
    public void testNoNullElementsArrayEmptyParameterNull() {
        Object[] objectArray = new Object[]{};
        Assert.assertSame((Object)objectArray, (Object)Validate.noNullElements((Object[])objectArray, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsArrayNullParameterNull() {
        try {
            Validate.noNullElements((Object[])null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("method parameter"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsArrayNullElementsParameterNull() {
        try {
            Validate.noNullElements((Object[])new Object[3], null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("method parameter"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsArrayMixedParameterNull() {
        try {
            Validate.noNullElements((Object[])new String[]{"foo", null, "bar"}, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("method parameter"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNoNullElementsCollection() {
        List<String> list = Arrays.asList("foo", "bar", "baz");
        Assert.assertSame(list, (Object)Validate.noNullElements(list));
    }

    @Test
    public void testNoNullElementsCollectionEmpty() {
        Set set = Collections.emptySet();
        Assert.assertSame(set, (Object)Validate.noNullElements(set));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsCollectionNull() {
        Validate.noNullElements((Collection)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsCollectionNullElements() {
        Validate.noNullElements(Arrays.asList(null, null, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsCollectionMixed() {
        Validate.noNullElements(Arrays.asList("foo", null, "bar"));
    }

    @Test
    public void testNoNullElementsCollectionParameter() {
        List<String> list = Arrays.asList("foo", "bar", "baz");
        Assert.assertSame(list, (Object)Validate.noNullElements(list, (String)"foo"));
    }

    @Test
    public void testNoNullElementsCollectionEmptyParameter() {
        CopyOnWriteArrayList copyOnWriteArrayList = new CopyOnWriteArrayList();
        Assert.assertSame(copyOnWriteArrayList, (Object)Validate.noNullElements(copyOnWriteArrayList, (String)"foo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsCollectionNullParameter() {
        try {
            Validate.noNullElements((Collection)null, (String)"foo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("foo"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsCollectionNullElementsParameter() {
        try {
            Validate.noNullElements(Collections.singletonList(null), (String)"foo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("foo"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsCollectionMixedParameter() {
        try {
            Validate.noNullElements(Arrays.asList("foo", null, "bar"), (String)"foo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("foo"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNoNullElementsCollectionParameterNull() {
        List<String> list = Arrays.asList("foo", "bar", "baz");
        Assert.assertSame(list, (Object)Validate.noNullElements(list, null));
    }

    @Test
    public void testNoNullElementsCollectionEmptyParameterNull() {
        Set set = Collections.emptySet();
        Assert.assertSame(set, (Object)Validate.noNullElements(set, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsCollectionNullParameterNull() {
        try {
            Validate.noNullElements((Collection)null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("method parameter"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsCollectionNullElementsParameterNull() {
        try {
            Validate.noNullElements(Collections.singleton(null), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("method parameter"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullElementsCollectionMixedParameterNull() {
        List<String> list = Arrays.asList("foo", null, "bar");
        try {
            Validate.noNullElements(list, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("method parameter"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNoNullValuesMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(){
            {
                this.put("foo", 1);
                this.put("bar", 2);
                this.put("baz", 3);
            }
        };
        Assert.assertSame((Object)hashMap, (Object)Validate.noNullValues((Map)hashMap));
    }

    @Test
    public void testNoNullValuesEmpty() {
        Map map = Collections.emptyMap();
        Assert.assertSame(map, (Object)Validate.noNullValues(map));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullValuesNull() {
        Validate.noNullValues((Map)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullValuesNullElements() {
        Validate.noNullValues(Collections.singletonMap("foo", null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullValuesMixed() {
        Validate.noNullValues((Map)new HashMap<String, Object>(){
            {
                this.put("foo", 1);
                this.put(null, null);
                this.put("baz", null);
            }
        });
    }

    @Test
    public void testNoNullValuesParameter() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(){
            {
                this.put("foo", 1);
                this.put("bar", 2);
                this.put("baz", 3);
            }
        };
        Assert.assertSame((Object)hashMap, (Object)Validate.noNullValues((Map)hashMap, (String)"foo"));
    }

    @Test
    public void testNoNullValuesEmptyParameter() {
        HashMap hashMap = new HashMap();
        Assert.assertSame(hashMap, (Object)Validate.noNullValues(hashMap, (String)"foo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullValuesNullParameter() {
        try {
            Validate.noNullValues((Map)null, (String)"foo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("foo"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullValuesNullElementsParameter() {
        try {
            Validate.noNullValues(Collections.singletonMap("bar", null), (String)"foo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("foo"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullValuesMixedParameter() {
        try {
            Validate.noNullValues((Map)new HashMap<String, Object>(){
                {
                    this.put("foo", 1);
                    this.put(null, null);
                    this.put("bar", null);
                }
            }, (String)"foo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("foo"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNoNullValuesParameterNull() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(){
            {
                this.put("foo", 1);
                this.put("bar", 2);
                this.put("baz", 3);
            }
        };
        Assert.assertSame((Object)hashMap, (Object)Validate.noNullValues((Map)hashMap, null));
    }

    @Test
    public void testNoNullValuesEmptyParameterNull() {
        Map map = Collections.emptyMap();
        Assert.assertSame(map, (Object)Validate.noNullValues(map, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullValuesNullParameterNull() {
        try {
            Validate.noNullValues((Map)null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("method parameter"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullValuesNullElementsParameterNull() {
        try {
            Validate.noNullValues(Collections.singletonMap(null, null), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("method parameter"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullValuesMixedParameterNull() {
        try {
            Validate.noNullValues((Map)new HashMap<String, Object>(){
                {
                    this.put("foo", 1);
                    this.put(null, null);
                    this.put("bar", null);
                }
            }, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("method parameter"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNoNullKeysMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(){
            {
                this.put("foo", 1);
                this.put("bar", 2);
                this.put("baz", 3);
            }
        };
        Assert.assertSame((Object)hashMap, (Object)Validate.noNullKeys((Map)hashMap));
    }

    @Test
    public void testNoNullKeysEmpty() {
        Map map = Collections.emptyMap();
        Assert.assertSame(map, (Object)Validate.noNullKeys(map));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullKeysNull() {
        Validate.noNullKeys((Map)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullKeysNullElements() {
        Validate.noNullKeys(Collections.singletonMap(null, "foo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullKeysMixed() {
        Validate.noNullKeys((Map)new HashMap<String, Object>(){
            {
                this.put("foo", 1);
                this.put(null, null);
                this.put("baz", null);
            }
        });
    }

    @Test
    public void testNoNullKeysParameter() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(){
            {
                this.put("foo", 1);
                this.put("bar", 2);
                this.put("baz", 3);
            }
        };
        Assert.assertSame((Object)hashMap, (Object)Validate.noNullKeys((Map)hashMap, (String)"foo"));
    }

    @Test
    public void testNoNullKeysEmptyParameter() {
        HashMap hashMap = new HashMap();
        Assert.assertSame(hashMap, (Object)Validate.noNullKeys(hashMap, (String)"foo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullKeysNullParameter() {
        try {
            Validate.noNullKeys((Map)null, (String)"foo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("foo"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullKeysNullElementsParameter() {
        try {
            Validate.noNullKeys(Collections.singletonMap(null, "bar"), (String)"foo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("foo"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullKeysMixedParameter() {
        try {
            Validate.noNullKeys((Map)new HashMap<String, Object>(){
                {
                    this.put("foo", 1);
                    this.put(null, null);
                    this.put("bar", null);
                }
            }, (String)"foo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("foo"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testNoNullKeysParameterNull() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(){
            {
                this.put("foo", 1);
                this.put("bar", 2);
                this.put("baz", 3);
            }
        };
        Assert.assertSame((Object)hashMap, (Object)Validate.noNullKeys((Map)hashMap, null));
    }

    @Test
    public void testNoNullKeysEmptyParameterNull() {
        Map map = Collections.emptyMap();
        Assert.assertSame(map, (Object)Validate.noNullKeys(map, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullKeysNullParameterNull() {
        try {
            Validate.noNullKeys((Map)null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("method parameter"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullKeysNullElementsParameterNull() {
        try {
            Validate.noNullKeys(Collections.singletonMap(null, null), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("method parameter"));
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullKeysMixedParameterNull() {
        try {
            Validate.noNullKeys((Map)new HashMap<String, Object>(){
                {
                    this.put("foo", 1);
                    this.put(null, null);
                    this.put("bar", null);
                }
            }, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("method parameter"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testIsTrue() {
        Assert.assertTrue((boolean)Validate.isTrue((boolean)true, (String)"%s"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsTrueFalse() {
        try {
            Validate.isTrue((boolean)false, (String)"is %s");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertEquals((Object)"is false", (Object)illegalArgumentException.getMessage());
            throw illegalArgumentException;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsTrueFalseNullParam() {
        try {
            Validate.isTrue((boolean)false, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("false"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testIsTrueValue() {
        Object object = new Object();
        Assert.assertSame((Object)object, (Object)Validate.isTrue((boolean)true, (Object)object, (String)"%s"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsTrueFalseValue() {
        try {
            Validate.isTrue((boolean)false, (Object)"baz", (String)"foo is '%s'");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertEquals((Object)"foo is 'baz'", (Object)illegalArgumentException.getMessage());
            throw illegalArgumentException;
        }
    }

    @Test
    public void testIsTrueValueParamNull() {
        Assert.assertEquals((Object)"foo", (Object)Validate.isTrue((boolean)true, (Object)"foo", null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsTrueFalseValueParamNull() {
        try {
            Validate.isTrue((boolean)false, (Object)"foo", null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("foo"));
            throw illegalArgumentException;
        }
    }

    @Test
    public void testIsTrueValueNullParamNull() {
        Assert.assertNull((Object)Validate.isTrue((boolean)true, null, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsTrueFalseValueNullParamNull() {
        try {
            Validate.isTrue((boolean)false, null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)illegalArgumentException.getMessage().contains("null"));
            throw illegalArgumentException;
        }
    }
}

