/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

import com.twelvemonkeys.lang.DateUtil;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DateUtilTest {
    private final TimeZone timeZone;

    @Parameterized.Parameters
    public static List<Object[]> timeZones() {
        return Arrays.asList({TimeZone.getTimeZone("UTC")}, {TimeZone.getTimeZone("CET")}, {TimeZone.getTimeZone("IST")});
    }

    public DateUtilTest(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    private Calendar getCalendar(long l) {
        return this.getCalendar(l, TimeZone.getDefault());
    }

    private Calendar getCalendar(long l, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTimeInMillis(l);
        return calendar;
    }

    @Test
    public void testRoundToSecond() {
        Calendar calendar = this.getCalendar(DateUtil.roundToSecond((long)System.currentTimeMillis()));
        Assert.assertEquals((long)0L, (long)calendar.get(14));
    }

    @Test
    public void testRoundToMinute() {
        Calendar calendar = this.getCalendar(DateUtil.roundToMinute((long)System.currentTimeMillis()));
        Assert.assertEquals((long)0L, (long)calendar.get(14));
        Assert.assertEquals((long)0L, (long)calendar.get(13));
    }

    @Test
    public void testRoundToHour() {
        Calendar calendar = this.getCalendar(DateUtil.roundToHour((long)System.currentTimeMillis()));
        Assert.assertEquals((long)0L, (long)calendar.get(14));
        Assert.assertEquals((long)0L, (long)calendar.get(13));
        Assert.assertEquals((long)0L, (long)calendar.get(12));
    }

    @Test
    public void testRoundToHourTZ() {
        Calendar calendar = this.getCalendar(DateUtil.roundToHour((long)System.currentTimeMillis(), (TimeZone)this.timeZone), this.timeZone);
        Assert.assertEquals((long)0L, (long)calendar.get(14));
        Assert.assertEquals((long)0L, (long)calendar.get(13));
        Assert.assertEquals((long)0L, (long)calendar.get(12));
    }

    @Test
    public void testRoundToDay() {
        Calendar calendar = this.getCalendar(DateUtil.roundToDay((long)System.currentTimeMillis()));
        Assert.assertEquals((long)0L, (long)calendar.get(14));
        Assert.assertEquals((long)0L, (long)calendar.get(13));
        Assert.assertEquals((long)0L, (long)calendar.get(12));
        Assert.assertEquals((long)0L, (long)calendar.get(11));
    }

    @Test
    public void testRoundToDayTZ() {
        Calendar calendar = this.getCalendar(DateUtil.roundToDay((long)System.currentTimeMillis(), (TimeZone)this.timeZone), this.timeZone);
        Assert.assertEquals((long)0L, (long)calendar.get(14));
        Assert.assertEquals((long)0L, (long)calendar.get(13));
        Assert.assertEquals((long)0L, (long)calendar.get(12));
        Assert.assertEquals((long)0L, (long)calendar.get(11));
    }

    @Test
    public void testCurrentTimeSecond() {
        Calendar calendar = this.getCalendar(DateUtil.currentTimeSecond());
        Assert.assertEquals((long)0L, (long)calendar.get(14));
    }

    @Test
    public void testCurrentTimeMinute() {
        Calendar calendar = this.getCalendar(DateUtil.currentTimeMinute());
        Assert.assertEquals((long)0L, (long)calendar.get(14));
        Assert.assertEquals((long)0L, (long)calendar.get(13));
    }

    @Test
    public void testCurrentTimeHour() {
        Calendar calendar = this.getCalendar(DateUtil.currentTimeHour());
        Assert.assertEquals((long)0L, (long)calendar.get(14));
        Assert.assertEquals((long)0L, (long)calendar.get(13));
        Assert.assertEquals((long)0L, (long)calendar.get(12));
    }

    @Test
    public void testCurrentTimeDay() {
        Calendar calendar = this.getCalendar(DateUtil.currentTimeDay());
        Assert.assertEquals((long)0L, (long)calendar.get(14));
        Assert.assertEquals((long)0L, (long)calendar.get(13));
        Assert.assertEquals((long)0L, (long)calendar.get(12));
        Assert.assertEquals((long)0L, (long)calendar.get(11));
    }
}

