/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.lang;

import com.twelvemonkeys.lang.BeanUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class BeanUtilTest {
    @Test
    public void testConfigureNoMehtod() {
        TestBean testBean = new TestBean();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("noSuchMethod", "jaffa");
        try {
            BeanUtil.configure((Object)testBean, hashMap);
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.fail((String)invocationTargetException.getMessage());
        }
    }

    @Test
    public void testConfigureNoMethodArgs() {
        TestBean testBean = new TestBean();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("doubleValue", new Object());
        try {
            BeanUtil.configure((Object)testBean, hashMap);
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.fail((String)invocationTargetException.getMessage());
        }
        Assert.assertNull((Object)testBean.getDoubleValue());
    }

    @Test
    public void testConfigureNullValue() {
        TestBean testBean = new TestBean();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("stringValue", null);
        try {
            BeanUtil.configure((Object)testBean, hashMap);
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.fail((String)invocationTargetException.getMessage());
        }
        Assert.assertNull((Object)testBean.getStringValue());
    }

    public void testConfigureSimple() {
        TestBean testBean = new TestBean();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("stringValue", "one");
        hashMap.put("intValue", 2);
        hashMap.put("doubleValue", 0.3);
        try {
            BeanUtil.configure((Object)testBean, hashMap);
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.fail((String)invocationTargetException.getMessage());
        }
        Assert.assertEquals((Object)"one", (Object)testBean.getStringValue());
        Assert.assertEquals((long)2L, (long)testBean.getIntValue());
        Assert.assertEquals((double)0.3, (double)testBean.getDoubleValue(), (double)0.0);
    }

    @Test
    public void testConfigureConvert() {
        TestBean testBean = new TestBean();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("stringValue", 1);
        hashMap.put("intValue", "2");
        hashMap.put("doubleValue", ".3");
        try {
            BeanUtil.configure((Object)testBean, hashMap);
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.fail((String)invocationTargetException.getMessage());
        }
        Assert.assertEquals((Object)"1", (Object)testBean.getStringValue());
        Assert.assertEquals((long)2L, (long)testBean.getIntValue());
        Assert.assertEquals((double)0.3, (double)testBean.getDoubleValue(), (double)0.0);
    }

    @Test
    public void testConfigureAmbiguous1() {
        TestBean testBean = new TestBean();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "one";
        hashMap.put("ambiguous", string);
        try {
            BeanUtil.configure((Object)testBean, hashMap);
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.fail((String)invocationTargetException.getMessage());
        }
        Assert.assertNotNull((Object)testBean.getAmbiguous());
        Assert.assertEquals((String)"String converted rather than invoking setAmbiguous(String), ordering not predictable", (Object)"one", (Object)testBean.getAmbiguous());
        Assert.assertSame((String)"String converted rather than invoking setAmbiguous(String), ordering not predictable", (Object)string, (Object)testBean.getAmbiguous());
    }

    @Test
    public void testConfigureAmbiguous2() {
        TestBean testBean = new TestBean();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Integer n = 2;
        hashMap.put("ambiguous", n);
        try {
            BeanUtil.configure((Object)testBean, hashMap);
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.fail((String)invocationTargetException.getMessage());
        }
        Assert.assertNotNull((Object)testBean.getAmbiguous());
        Assert.assertEquals((String)"Integer converted rather than invoking setAmbiguous(Integer), ordering not predictable", (Object)2, (Object)testBean.getAmbiguous());
        Assert.assertSame((String)"Integer converted rather than invoking setAmbiguous(Integer), ordering not predictable", (Object)n, (Object)testBean.getAmbiguous());
    }

    @Test
    public void testConfigureAmbiguous3() {
        TestBean testBean = new TestBean();
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        Double d = 0.3;
        hashMap.put("ambiguous", d);
        try {
            BeanUtil.configure((Object)testBean, hashMap);
        }
        catch (InvocationTargetException invocationTargetException) {
            Assert.fail((String)invocationTargetException.getMessage());
        }
        Assert.assertNotNull((Object)testBean.getAmbiguous());
        Assert.assertEquals((String)"Object converted rather than invoking setAmbiguous(Object), ordering not predictable", d.getClass(), testBean.getAmbiguous().getClass());
        Assert.assertSame((String)"Object converted rather than invoking setAmbiguous(Object), ordering not predictable", (Object)d, (Object)testBean.getAmbiguous());
    }

    static class TestBean {
        private String stringVal;
        private int intVal;
        private Double doubleVal;
        private Object ambiguous;

        TestBean() {
        }

        public Double getDoubleValue() {
            return this.doubleVal;
        }

        public int getIntValue() {
            return this.intVal;
        }

        public String getStringValue() {
            return this.stringVal;
        }

        public void setStringValue(String string) {
            this.stringVal = string;
        }

        public void setIntValue(int n) {
            this.intVal = n;
        }

        public void setDoubleValue(Double d) {
            this.doubleVal = d;
        }

        public void setAmbiguous(String string) {
            this.ambiguous = string;
        }

        public void setAmbiguous(Object object) {
            this.ambiguous = object;
        }

        public void setAmbiguous(Integer n) {
            this.ambiguous = n;
        }

        public void setAmbiguous(int n) {
            this.ambiguous = (long)n;
        }

        public Object getAmbiguous() {
            return this.ambiguous;
        }
    }
}

