/*
 * Decompiled with CFR 0.152.
 */
package com.tuyenmonkey.mkloader.type;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import com.tuyenmonkey.mkloader.model.Circle;
import com.tuyenmonkey.mkloader.type.LoaderView;

public class FishSpinner
extends LoaderView {
    private Circle[] circles;
    private int numberOfCircle = 5;
    private float[] rotates = new float[this.numberOfCircle];

    @Override
    public void initializeObjects() {
        float size = Math.min(this.width, this.height);
        float circleRadius = size / 10.0f;
        this.circles = new Circle[this.numberOfCircle];
        for (int i = 0; i < this.numberOfCircle; ++i) {
            this.circles[i] = new Circle();
            this.circles[i].setCenter(this.center.x, circleRadius);
            this.circles[i].setColor(this.color);
            this.circles[i].setRadius(circleRadius - circleRadius * (float)i / 6.0f);
        }
    }

    @Override
    public void setUpAnimation() {
        int i = 0;
        while (i < this.numberOfCircle) {
            final int index = i++;
            ValueAnimator fadeAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
            fadeAnimator.setRepeatCount(-1);
            fadeAnimator.setDuration(1700L);
            fadeAnimator.setStartDelay((long)(index * 100));
            fadeAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((FishSpinner)FishSpinner.this).rotates[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    if (FishSpinner.this.invalidateListener != null) {
                        FishSpinner.this.invalidateListener.reDraw();
                    }
                }
            });
            fadeAnimator.start();
        }
    }

    @Override
    public void draw(Canvas canvas) {
        for (int i = 0; i < this.numberOfCircle; ++i) {
            canvas.save();
            canvas.rotate(this.rotates[i], this.center.x, this.center.y);
            this.circles[i].draw(canvas);
            canvas.restore();
        }
    }
}

