/*
 * Decompiled with CFR 0.152.
 */
package com.tuyenmonkey.mkloader;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import com.tuyenmonkey.mkloader.R;
import com.tuyenmonkey.mkloader.callback.InvalidateListener;
import com.tuyenmonkey.mkloader.type.LoaderView;
import com.tuyenmonkey.mkloader.util.LoaderGenerator;

public class MKLoader
extends View
implements InvalidateListener {
    private LoaderView loaderView;

    public MKLoader(Context context) {
        super(context);
        this.initialize(context, null, 0);
    }

    public MKLoader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs, 0);
    }

    public MKLoader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr);
    }

    private void initialize(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MKLoader);
        int loaderType = typedArray.getInt(R.styleable.MKLoader_mk_type, -1);
        this.loaderView = LoaderGenerator.generateLoaderView(loaderType);
        this.loaderView.setColor(typedArray.getColor(R.styleable.MKLoader_mk_color, Color.parseColor((String)"#ffffff")));
        this.loaderView.setInvalidateListener(this);
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = MKLoader.resolveSize((int)this.loaderView.getDesiredWidth(), (int)widthMeasureSpec);
        int measuredHeight = MKLoader.resolveSize((int)this.loaderView.getDesiredHeight(), (int)heightMeasureSpec);
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.loaderView.setSize(this.getWidth(), this.getHeight());
        this.loaderView.initializeObjects();
        this.loaderView.setUpAnimation();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.loaderView.draw(canvas);
    }

    @Override
    public void reDraw() {
        this.invalidate();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.loaderView != null) {
            this.loaderView.onDetach();
        }
    }
}

