/*
 * Decompiled with CFR 0.152.
 */
package com.tuyenmonkey.mkloader.type;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.tuyenmonkey.mkloader.model.Arc;
import com.tuyenmonkey.mkloader.type.LoaderView;

public class Whirlpool
extends LoaderView {
    private Arc[] arcs;
    private int numberOfArc = 3;
    private float[] rotates;

    @Override
    public void initializeObjects() {
        float r = (float)Math.min(this.width, this.height) / 2.0f;
        this.arcs = new Arc[this.numberOfArc];
        this.rotates = new float[this.numberOfArc];
        for (int i = 0; i < this.numberOfArc; ++i) {
            float d = r / 4.0f + (float)i * r / 4.0f;
            this.arcs[i] = new Arc();
            this.arcs[i].setColor(this.color);
            this.arcs[i].setOval(new RectF(this.center.x - d, this.center.y - d, this.center.x + d, this.center.y + d));
            this.arcs[i].setStartAngle(i * 45);
            this.arcs[i].setSweepAngle(i * 45 + 90);
            this.arcs[i].setStyle(Paint.Style.STROKE);
            this.arcs[i].setWidth(r / 10.0f);
        }
    }

    @Override
    public void setUpAnimation() {
        for (int i = this.numberOfArc - 1; i >= 0; --i) {
            final int index = i;
            ValueAnimator fadeAnimator = ValueAnimator.ofFloat((float[])new float[]{this.arcs[i].getStartAngle(), this.arcs[i].getStartAngle() + (float)(360 * (i % 2 == 0 ? -1 : 1))});
            fadeAnimator.setRepeatCount(-1);
            fadeAnimator.setDuration((long)((i + 1) * 500));
            fadeAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ((Whirlpool)Whirlpool.this).rotates[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    Whirlpool.this.invalidateListener.reDraw();
                }
            });
            fadeAnimator.start();
        }
    }

    @Override
    public void draw(Canvas canvas) {
        for (int i = 0; i < this.numberOfArc; ++i) {
            canvas.save();
            canvas.rotate(this.rotates[i], this.center.x, this.center.y);
            this.arcs[i].draw(canvas);
            canvas.restore();
        }
    }
}

