/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.sdk.bean.cache;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class CacheObj<T> {
    @NonNull
    public String key;
    @Nullable
    public long maxAgeTimestamp;
    @Nullable
    public long maxStaleTimestamp;
    @NonNull
    public T content;

    public void copyFrom(@NonNull CacheObj<T> obj) {
        this.key = obj.key;
        this.maxAgeTimestamp = obj.maxAgeTimestamp;
        this.maxStaleTimestamp = obj.maxStaleTimestamp;
        this.content = obj.content;
    }

    public static final class Builder<T> {
        @NonNull
        private String key;
        private long maxAgeTimestamp;
        private long maxStaleTimestamp;
        private T content;

        @NonNull
        public Builder<T> withKey(@NonNull String key) {
            this.key = key;
            return this;
        }

        @NonNull
        public Builder<T> withMaxAgeTimestamp(long maxAgeTimestamp) {
            this.maxAgeTimestamp = maxAgeTimestamp;
            return this;
        }

        @NonNull
        public Builder<T> withMaxStaleTimestamp(long maxStaleTimestamp) {
            this.maxStaleTimestamp = maxStaleTimestamp;
            return this;
        }

        @NonNull
        public Builder<T> withContent(@NonNull T content) {
            this.content = content;
            return this;
        }

        public CacheObj<T> build() {
            CacheObj cacheObj = new CacheObj();
            cacheObj.content = this.content;
            cacheObj.maxStaleTimestamp = this.maxStaleTimestamp;
            cacheObj.key = this.key;
            cacheObj.maxAgeTimestamp = this.maxAgeTimestamp;
            return cacheObj;
        }
    }
}

