/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.home.sdk.bean.scene;

import androidx.annotation.NonNull;
import com.tuya.sdk.core.PluginManager;
import com.tuya.smart.home.sdk.bean.scene.SceneBean;
import com.tuya.smart.home.sdk.bean.scene.SceneIdBean;
import com.tuya.smart.interior.api.ITuyaDevicePlugin;
import com.tuya.smart.sdk.bean.DeviceBean;
import com.tuya.smart.sdk.bean.GroupBean;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SceneTask
implements Serializable {
    private static final long serialVersionUID = 2265313656820949794L;
    private String id;
    private String actionExecutor;
    private String entityId;
    private String entityName;
    private Map<String, List<String>> actionDisplayNew;
    private Map<String, Object> executorProperty;
    private Map<String, Object> extraProperty;
    private String devIcon;
    private boolean isDevOnline;
    private String uiid;
    private String productId;
    private String productPic;
    private boolean devDelMark;
    private String deleteDevIcon;

    public SceneTask() {
    }

    public SceneTask(SceneTask bean) {
        this.id = bean.getId();
        this.actionDisplayNew = bean.getActionDisplayNew();
        this.entityId = bean.getEntityId();
        this.entityName = bean.getEntityName();
        this.actionExecutor = bean.getActionExecutor();
        this.executorProperty = bean.getExecutorProperty();
    }

    @Deprecated
    public static SceneTask createSceneTask(SceneBean sceneBean) {
        SceneTask sceneTask = new SceneTask();
        if (sceneBean.getConditions() != null && sceneBean.getConditions().size() >= 1) {
            sceneTask.setActionExecutor(sceneBean.isEnabled() ? "ruleEnable" : "ruleDisable");
        } else {
            sceneTask.setActionExecutor("ruleTrigger");
        }
        sceneTask.setEntityId(sceneBean.getId());
        return sceneTask;
    }

    @Deprecated
    public static SceneTask createDpTask(@NonNull String devId, HashMap<String, Object> tasks) {
        SceneTask sceneTask = new SceneTask();
        sceneTask.setActionExecutor("dpIssue");
        sceneTask.setEntityId(devId);
        ITuyaDevicePlugin service = (ITuyaDevicePlugin)PluginManager.service(ITuyaDevicePlugin.class);
        if (service != null) {
            DeviceBean dev = service.getDataInstance().getDeviceBean(sceneTask.getEntityId());
            if (dev != null) {
                sceneTask.setDevIcon(dev.getIconUrl());
                sceneTask.setDevOnline(dev.getIsOnline());
                sceneTask.setEntityName(dev.getName());
            }
            if (tasks == null || tasks.size() == 0) {
                return null;
            }
        }
        sceneTask.setExecutorProperty(tasks);
        return sceneTask;
    }

    public static SceneTask createDpGroupTask(@NonNull long groupId, HashMap<String, Object> tasks) {
        SceneTask sceneTask = new SceneTask();
        sceneTask.setActionExecutor("deviceGroupDpIssue");
        sceneTask.setEntityId(String.valueOf(groupId));
        ITuyaDevicePlugin service = (ITuyaDevicePlugin)PluginManager.service(ITuyaDevicePlugin.class);
        if (service != null) {
            GroupBean groupBean = service.getDataInstance().getGroupBean(groupId);
            if (groupBean != null) {
                sceneTask.setDevIcon(groupBean.getIconUrl());
                sceneTask.setDevOnline(groupBean.getIsOnline());
                sceneTask.setEntityName(groupBean.getName());
            }
            if (tasks == null || tasks.size() == 0) {
                return null;
            }
        }
        sceneTask.setExecutorProperty(tasks);
        return sceneTask;
    }

    public static SceneTask createDelayTask(int minute, int second) {
        SceneTask sceneTask = new SceneTask();
        sceneTask.setActionExecutor("delay");
        HashMap<String, Object> executor = new HashMap<String, Object>();
        executor.put("minutes", minute + "");
        executor.put("seconds", second + "");
        sceneTask.setExecutorProperty(executor);
        sceneTask.setEntityId("delay");
        return sceneTask;
    }

    public static SceneTask createPushMessage() {
        SceneTask sceneTask = new SceneTask();
        sceneTask.setActionExecutor("appPushTrigger");
        return sceneTask;
    }

    public static SceneTask createPhoneNotice() {
        SceneTask sceneTask = new SceneTask();
        sceneTask.setActionExecutor("mobileVoiceSend");
        return sceneTask;
    }

    public boolean isDevDelMark() {
        return this.devDelMark;
    }

    public void setDevDelMark(boolean devDelMark) {
        this.devDelMark = devDelMark;
    }

    public String getDeleteDevIcon() {
        return this.deleteDevIcon;
    }

    public void setDeleteDevIcon(String deleteDevIcon) {
        this.deleteDevIcon = deleteDevIcon;
    }

    public String getActionExecutor() {
        return this.actionExecutor;
    }

    public void setActionExecutor(String actionExecutor) {
        this.actionExecutor = actionExecutor;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public Map<String, List<String>> getActionDisplayNew() {
        return this.actionDisplayNew;
    }

    public void setActionDisplayNew(Map<String, List<String>> actionDisplayNew) {
        this.actionDisplayNew = actionDisplayNew;
    }

    public Map<String, Object> getExecutorProperty() {
        return this.executorProperty;
    }

    public void setExecutorProperty(Map<String, Object> executorProperty) {
        this.executorProperty = executorProperty;
    }

    public String getDevIcon() {
        return this.devIcon;
    }

    public void setDevIcon(String devIcon) {
        this.devIcon = devIcon;
    }

    public boolean isDevOnline() {
        return this.isDevOnline;
    }

    public void setDevOnline(boolean devOnline) {
        this.isDevOnline = devOnline;
    }

    public Map<String, Object> getExtraProperty() {
        return this.extraProperty;
    }

    public void setExtraProperty(Map<String, Object> extraProperty) {
        this.extraProperty = extraProperty;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductPic() {
        return this.productPic;
    }

    public void setProductPic(String productPic) {
        this.productPic = productPic;
    }

    public SceneIdBean getSceneIdBean() {
        if (this.extraProperty == null) {
            return null;
        }
        SceneIdBean sceneIdBean = new SceneIdBean();
        sceneIdBean.setGid(String.valueOf(this.extraProperty.get("gid")));
        sceneIdBean.setSid(String.valueOf(this.extraProperty.get("sid")));
        sceneIdBean.setGwId(String.valueOf(this.extraProperty.get("gwId")));
        return sceneIdBean;
    }

    public void setSceneId(SceneIdBean sceneIdBean) {
        if (this.extraProperty == null) {
            this.extraProperty = new HashMap<String, Object>();
        }
        this.extraProperty.put("gid", sceneIdBean.getGid());
        this.extraProperty.put("sid", sceneIdBean.getSid());
        this.extraProperty.put("gwId", sceneIdBean.getGwId());
    }

    public String getUiid() {
        return this.uiid;
    }

    public void setUiid(String uiid) {
        this.uiid = uiid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SceneTask task = (SceneTask)o;
        if (this.isDevOnline != task.isDevOnline) {
            return false;
        }
        if (this.id != null ? !this.id.equals(task.id) : task.id != null) {
            return false;
        }
        if (this.actionExecutor != null ? !this.actionExecutor.equals(task.actionExecutor) : task.actionExecutor != null) {
            return false;
        }
        if (this.entityId != null ? !this.entityId.equals(task.entityId) : task.entityId != null) {
            return false;
        }
        if (this.entityName != null ? !this.entityName.equals(task.entityName) : task.entityName != null) {
            return false;
        }
        if (this.actionDisplayNew != null ? !this.actionDisplayNew.equals(task.actionDisplayNew) : task.actionDisplayNew != null) {
            return false;
        }
        if (this.executorProperty != null ? !this.executorProperty.equals(task.executorProperty) : task.executorProperty != null) {
            return false;
        }
        if (this.extraProperty != null ? !this.extraProperty.equals(task.extraProperty) : task.extraProperty != null) {
            return false;
        }
        return this.devIcon != null ? this.devIcon.equals(task.devIcon) : task.devIcon == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.actionExecutor != null ? this.actionExecutor.hashCode() : 0);
        result = 31 * result + (this.entityId != null ? this.entityId.hashCode() : 0);
        result = 31 * result + (this.entityName != null ? this.entityName.hashCode() : 0);
        result = 31 * result + (this.actionDisplayNew != null ? this.actionDisplayNew.hashCode() : 0);
        result = 31 * result + (this.executorProperty != null ? this.executorProperty.hashCode() : 0);
        result = 31 * result + (this.extraProperty != null ? this.extraProperty.hashCode() : 0);
        result = 31 * result + (this.devIcon != null ? this.devIcon.hashCode() : 0);
        result = 31 * result + (this.isDevOnline ? 1 : 0);
        return result;
    }
}

