/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.home.sdk.bean.scene;

import com.tuya.smart.home.sdk.bean.scene.ConditionExtraInfoBean;
import com.tuya.smart.home.sdk.bean.scene.PlaceFacadeBean;
import com.tuya.smart.home.sdk.bean.scene.condition.GeoType;
import com.tuya.smart.home.sdk.bean.scene.condition.rule.Rule;
import com.tuya.smart.sdk.bean.DeviceBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SceneCondition
implements Serializable {
    public static final String CONDITION_TYPE_TIMER = "timer";
    private static final long serialVersionUID = 8624400661890233596L;
    private String id;
    private String entitySubIds;
    private String entityId;
    private int entityType;
    private String entityName;
    private Integer condType;
    private String exprDisplay;
    private List<Object> expr;
    private String iconUrl;
    private ConditionExtraInfoBean extraInfo;
    private String productId;
    private String productPic;
    private boolean devDelMark;
    private String deleteDevIcon;

    public static SceneCondition createDevCondition(DeviceBean devBean, String dpId, Rule rule) {
        SceneCondition sceneCondition = new SceneCondition();
        sceneCondition.setEntityId(devBean.getDevId());
        sceneCondition.setEntityName(devBean.getName());
        sceneCondition.setEntityType(1);
        sceneCondition.setEntitySubIds(dpId);
        if (rule != null) {
            ArrayList<Object> exprs = new ArrayList<Object>();
            exprs.add(rule.getExpr());
            sceneCondition.setExpr(exprs);
        }
        return sceneCondition;
    }

    @Deprecated
    public static SceneCondition createDevCondition(DeviceBean devBean, String dpId, List<Rule> rules) {
        SceneCondition sceneCondition = new SceneCondition();
        sceneCondition.setEntityId(devBean.getDevId());
        sceneCondition.setEntityName(devBean.getName());
        sceneCondition.setEntityType(1);
        sceneCondition.setEntitySubIds(dpId);
        if (rules != null) {
            ArrayList<Object> exprs = new ArrayList<Object>();
            for (Rule rule : rules) {
                exprs.add(rule.getExpr());
            }
            sceneCondition.setExpr(exprs);
        }
        return sceneCondition;
    }

    public static SceneCondition createWeatherCondition(PlaceFacadeBean place, String type, Rule rule) {
        SceneCondition sceneCondition = new SceneCondition();
        sceneCondition.setEntityId(String.valueOf(place.getCityId()));
        sceneCondition.setEntityName(place.getCity());
        sceneCondition.setEntityType(3);
        sceneCondition.setEntitySubIds(type);
        ArrayList<Object> exprs = new ArrayList<Object>();
        exprs.add(rule.getExpr());
        sceneCondition.setExpr(exprs);
        return sceneCondition;
    }

    public static SceneCondition createTimerCondition(String display, String name, String type, Rule rule) {
        SceneCondition sceneCondition = new SceneCondition();
        sceneCondition.setEntityId(CONDITION_TYPE_TIMER);
        sceneCondition.setEntityName(name);
        sceneCondition.setExprDisplay(display);
        sceneCondition.setEntityType(6);
        sceneCondition.setEntitySubIds(type);
        sceneCondition.setExpr(rule.getExpr());
        return sceneCondition;
    }

    public static SceneCondition createGeoFenceCondition(double lat, double lng, int radius, String address, GeoType geoType) {
        SceneCondition sceneCondition = new SceneCondition();
        sceneCondition.setEntityName(address);
        sceneCondition.setEntityType(10);
        ConditionExtraInfoBean extraInfoBean = new ConditionExtraInfoBean();
        HashMap<String, Double> center = new HashMap<String, Double>();
        center.put("latitude", lat);
        center.put("longitude", lng);
        extraInfoBean.setRadius(radius);
        extraInfoBean.setCenter(center);
        extraInfoBean.setGeotitle(address);
        sceneCondition.setExtraInfo(extraInfoBean);
        ArrayList<Object> expr = new ArrayList<Object>();
        ArrayList<String> exprObj = new ArrayList<String>();
        exprObj.add("$action");
        exprObj.add("==");
        exprObj.add(geoType.getType());
        expr.add(exprObj);
        sceneCondition.setExpr(expr);
        return sceneCondition;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEntitySubIds() {
        return this.entitySubIds;
    }

    public void setEntitySubIds(String entitySubIds) {
        this.entitySubIds = entitySubIds;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public int getEntityType() {
        return this.entityType;
    }

    public void setEntityType(int entityType) {
        this.entityType = entityType;
    }

    public boolean isDevDelMark() {
        return this.devDelMark;
    }

    public void setDevDelMark(boolean devDelMark) {
        this.devDelMark = devDelMark;
    }

    public String getDeleteDevIcon() {
        return this.deleteDevIcon;
    }

    public void setDeleteDevIcon(String deleteDevIcon) {
        this.deleteDevIcon = deleteDevIcon;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getExprDisplay() {
        return this.exprDisplay;
    }

    public void setExprDisplay(String exprDisplay) {
        this.exprDisplay = exprDisplay;
    }

    public List<Object> getExpr() {
        return this.expr;
    }

    public void setExpr(List<Object> expr) {
        this.expr = expr;
    }

    public ConditionExtraInfoBean getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(ConditionExtraInfoBean extraInfo) {
        this.extraInfo = extraInfo;
    }

    public Integer getCondType() {
        return this.condType;
    }

    public void setCondType(Integer condType) {
        this.condType = condType;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductPic() {
        return this.productPic;
    }

    public void setProductPic(String productPic) {
        this.productPic = productPic;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SceneCondition that = (SceneCondition)o;
        if (this.entityType != that.entityType) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.entitySubIds != null ? !this.entitySubIds.equals(that.entitySubIds) : that.entitySubIds != null) {
            return false;
        }
        if (this.entityId != null ? !this.entityId.equals(that.entityId) : that.entityId != null) {
            return false;
        }
        if (this.entityName != null ? !this.entityName.equals(that.entityName) : that.entityName != null) {
            return false;
        }
        if (this.condType != null ? !this.condType.equals(that.condType) : that.condType != null) {
            return false;
        }
        if (this.exprDisplay != null ? !this.exprDisplay.equals(that.exprDisplay) : that.exprDisplay != null) {
            return false;
        }
        if (this.expr != null ? !this.expr.equals(that.expr) : that.expr != null) {
            return false;
        }
        if (this.iconUrl != null ? !this.iconUrl.equals(that.iconUrl) : that.iconUrl != null) {
            return false;
        }
        return this.extraInfo != null ? this.extraInfo.equals(that.extraInfo) : that.extraInfo == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.entitySubIds != null ? this.entitySubIds.hashCode() : 0);
        result = 31 * result + (this.entityId != null ? this.entityId.hashCode() : 0);
        result = 31 * result + this.entityType;
        result = 31 * result + (this.entityName != null ? this.entityName.hashCode() : 0);
        result = 31 * result + (this.condType != null ? this.condType.hashCode() : 0);
        result = 31 * result + (this.exprDisplay != null ? this.exprDisplay.hashCode() : 0);
        result = 31 * result + (this.expr != null ? this.expr.hashCode() : 0);
        result = 31 * result + (this.iconUrl != null ? this.iconUrl.hashCode() : 0);
        result = 31 * result + (this.extraInfo != null ? this.extraInfo.hashCode() : 0);
        return result;
    }
}

