/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.panel.base.utils;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import com.tuya.reactnative.utils.R;
import com.tuya.smart.android.common.utils.NetworkUtil;
import com.tuya.smart.api.MicroContext;
import com.tuya.smart.api.router.UrlBuilder;
import com.tuya.smart.api.router.UrlRouter;
import com.tuya.smart.home.sdk.TuyaHomeSdk;
import com.tuya.smart.sdk.bean.DeviceBean;
import com.tuya.smart.sdk.bean.GroupBean;
import com.tuya.smart.sdk.bean.ProductBean;
import com.tuyasmart.stencil.app.GlobalConfig;

public class PanelUtils {
    public static String checkCommandErrorCode(String code) {
        String error = code != null && code.equals("HTTP_ERROR") ? MicroContext.getApplication().getString(R.string.ty_network_error) : (code != null && code.equals("UPGRADEING") ? MicroContext.getApplication().getString(R.string.firmware_upgrading) : (code != null && code.equals("GW_OFFLINE") ? MicroContext.getApplication().getString(R.string.title_device_offline) : (code != null && code.equals("10201") ? MicroContext.getApplication().getString(R.string.title_device_offline) : (!GlobalConfig.DEBUG ? MicroContext.getApplication().getString(R.string.system_error) : code))));
        return error;
    }

    public static String getNetworkType() {
        return NetworkUtil.getNetConnType((Context)MicroContext.getApplication()).toUpperCase();
    }

    public static String getGroupNetworkType() {
        return NetworkUtil.getNetConnType((Context)MicroContext.getApplication()).toUpperCase();
    }

    public static void gotoFeedbackActivity(Context context, String productId) {
        Bundle b = new Bundle();
        b.putString("hdId", productId);
        b.putString("extra_from", "choose_feedback");
        b.putInt("hdType", 2);
        UrlRouter.execute((UrlBuilder)UrlRouter.makeBuilder((Context)context, (String)"add_feedback").putExtras(b));
    }

    public static void gotoFeedbackActivity2(Context context, String productId, String deviceName) {
        Bundle b = new Bundle();
        b.putString("hdId", productId);
        b.putString("key", "categorieLast");
        b.putInt("hdType", 2);
        b.putString("title", deviceName);
        UrlRouter.execute((UrlBuilder)UrlRouter.makeBuilder((Context)context, (String)"helpCenter").putExtras(b));
    }

    public static void gotoGroupFeedbackActivity(Context context, String keyword, String entryType) {
        Bundle b = new Bundle();
        b.putString("key", "search");
        b.putString("keyword", keyword);
        b.putString("entryType", entryType);
        UrlRouter.execute((UrlBuilder)UrlRouter.makeBuilder((Context)context, (String)"helpCenter").putExtras(b));
    }

    public static AlertDialog removeDeviceDialog(Context context, int msgResId, final DialogInterface.OnClickListener listener) {
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                if (listener != null) {
                    listener.onClick(dialog, which);
                }
            }
        };
        AlertDialog.Builder dialog = new AlertDialog.Builder(context, R.style.Dialog_Alert_NoTitle);
        dialog.setPositiveButton(R.string.ty_confirm, onClickListener);
        dialog.setMessage((CharSequence)context.getString(msgResId));
        dialog.setCancelable(false);
        AlertDialog alertDialog = dialog.create();
        alertDialog.show();
        return alertDialog;
    }

    public static DeviceBean getDeviceBeanInstance(GroupBean data) {
        ProductBean productBean = TuyaHomeSdk.getDataInstance().getProductBean(data.getProductId());
        DeviceBean deviceBean = new DeviceBean();
        deviceBean.setDevId(data.getId() + "");
        deviceBean.setDps(data.getDps());
        deviceBean.setIsShare(Boolean.valueOf(data.isShare()));
        deviceBean.setLocalKey(data.getLocalKey());
        deviceBean.setProductId(data.getProductId());
        deviceBean.setTime(data.getTime());
        deviceBean.setPv(data.getPv());
        deviceBean.setProductBean(productBean);
        deviceBean.setIsOnline(Boolean.valueOf(true));
        deviceBean.setName(data.getName());
        deviceBean.setIconUrl(data.getIconUrl());
        deviceBean.setPanelConfig(productBean.getPanelConfig());
        deviceBean.setDpCodes(data.getDpCodes());
        return deviceBean;
    }

    public static boolean isGlobalDebug() {
        return GlobalConfig.DEBUG;
    }
}

