/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.panel.reactnative.utils;

import android.os.Bundle;
import android.util.Log;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import java.util.Map;

public class TypesUtil {
    public static <T> Bundle mapToBundle(Map<String, T> mapData) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, T> set : mapData.entrySet()) {
            String key = set.getKey();
            T value = set.getValue();
            if (value == null) continue;
            if (value instanceof String) {
                bundle.putString(key, (String)value);
                continue;
            }
            if (value instanceof Number) {
                if (value instanceof Integer) {
                    bundle.putInt(key, ((Integer)value).intValue());
                    continue;
                }
                bundle.putDouble(key, ((Number)value).doubleValue());
                continue;
            }
            if (value instanceof Boolean) {
                bundle.putBoolean(key, ((Boolean)value).booleanValue());
                continue;
            }
            Log.e((String)"TypesUtil", (String)("Could not convert " + value.getClass()));
        }
        return bundle;
    }

    public static <T> WritableMap mapToNativeMap(Map<String, T> mapData) {
        WritableMap map = Arguments.createMap();
        for (Map.Entry<String, T> set : mapData.entrySet()) {
            String key = set.getKey();
            T value = set.getValue();
            if (value == null) {
                map.putNull(key);
            }
            if (value instanceof String) {
                map.putString(key, (String)value);
                continue;
            }
            if (value instanceof Number) {
                if (value instanceof Integer) {
                    map.putInt(key, ((Integer)value).intValue());
                    continue;
                }
                map.putDouble(key, ((Number)value).doubleValue());
                continue;
            }
            if (value instanceof Boolean) {
                map.putBoolean(key, ((Boolean)value).booleanValue());
                continue;
            }
            Log.e((String)"TypesUtil", (String)("Could not convert " + value.getClass()));
        }
        return map;
    }
}

