/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.panel.base.utils;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import com.tuya.reactnative.utils.R;
import com.tuya.smart.android.common.utils.NetworkUtil;
import com.tuya.smart.home.sdk.TuyaHomeSdk;
import com.tuya.smart.sdk.TuyaSdk;
import com.tuya.smart.sdk.bean.DeviceBean;
import com.tuya.smart.sdk.bean.GroupBean;
import com.tuya.smart.sdk.bean.ProductBean;

public class PanelUtils {
    public static String checkCommandErrorCode(String code) {
        String error = code != null && code.equals("HTTP_ERROR") ? TuyaSdk.getApplication().getString(R.string.ty_network_error) : (code != null && code.equals("UPGRADEING") ? TuyaSdk.getApplication().getString(R.string.firmware_upgrading) : (code != null && code.equals("GW_OFFLINE") ? TuyaSdk.getApplication().getString(R.string.title_device_offline) : (code != null && code.equals("10201") ? TuyaSdk.getApplication().getString(R.string.title_device_offline) : TuyaSdk.getApplication().getString(R.string.system_error))));
        return error;
    }

    public static boolean isTyNetworkOk(String gwId) {
        DeviceBean deviceBean = TuyaHomeSdk.getDataInstance().getDeviceBean(gwId);
        return deviceBean != null && deviceBean.getIsLocalOnline() != false || TuyaHomeSdk.getServerInstance().isServerConnect();
    }

    public static String getNetworkType(Context context, String gwId) {
        String networkType = NetworkUtil.getNetConnType((Context)context);
        String wifiType = "NONE";
        if (PanelUtils.isTyNetworkOk(gwId)) {
            switch (networkType) {
                case "gprs": {
                    wifiType = "GPRS";
                    break;
                }
                case "wifi": {
                    wifiType = "WIFI";
                    break;
                }
            }
        }
        return wifiType;
    }

    public static String getGroupNetworkType(Context context) {
        String networkType = NetworkUtil.getNetConnType((Context)context);
        String wifiType = "NONE";
        switch (networkType) {
            case "gprs": {
                wifiType = "GPRS";
                break;
            }
            case "wifi": {
                wifiType = "WIFI";
                break;
            }
        }
        return wifiType;
    }

    public static AlertDialog removeDeviceDialog(Context context, int msgResId, final DialogInterface.OnClickListener listener) {
        DialogInterface.OnClickListener onClickListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                if (listener != null) {
                    listener.onClick(dialog, which);
                }
            }
        };
        AlertDialog.Builder dialog = new AlertDialog.Builder(context, R.style.Dialog_Alert_NoTitle);
        dialog.setPositiveButton(R.string.ty_confirm, onClickListener);
        dialog.setMessage((CharSequence)context.getString(msgResId));
        dialog.setCancelable(false);
        AlertDialog alertDialog = dialog.create();
        alertDialog.show();
        return alertDialog;
    }

    public static DeviceBean getDeviceBeanIntance(GroupBean data) {
        ProductBean productBean = TuyaHomeSdk.getDataInstance().getProductBean(data.getProductId());
        DeviceBean deviceBean = new DeviceBean();
        deviceBean.setDevId(data.getId() + "");
        deviceBean.setDps(data.getDps());
        deviceBean.setIsShare(Boolean.valueOf(data.isShare()));
        deviceBean.setLocalKey(data.getLocalKey());
        deviceBean.setProductId(data.getProductId());
        deviceBean.setTime(data.getTime());
        deviceBean.setPv(data.getPv());
        deviceBean.setProductBean(productBean);
        deviceBean.setIsOnline(Boolean.valueOf(true));
        deviceBean.setName(data.getName());
        deviceBean.setIconUrl(data.getIconUrl());
        deviceBean.setPanelConfig(productBean.getPanelConfig());
        return deviceBean;
    }

    public static void gotoFeedbackActivity(Context context, String productId) {
    }

    public static void gotoFeedbackActivity2(Context context, String productId, String deviceName) {
    }

    public static void gotoGroupFeedbackActivity(Context context, String keyword, String entryType) {
    }
}

