/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.manager;

import android.text.TextUtils;
import android.util.Base64;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.tuya.reactnativesweeper.bean.MapPointsData;
import com.tuya.reactnativesweeper.manager.a;
import com.tuya.reactnativesweeper.manager.b;
import com.tuya.reactnativesweeper.manager.c;
import com.tuya.reactnativesweeper.manager.f;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.android.sweeper.ITuyaCloudConfigCallback;
import com.tuya.smart.android.sweeper.ITuyaSweeperDataListener;
import com.tuya.smart.home.sdk.TuyaHomeSdk;
import com.tuya.smart.home.sdk.callback.ITuyaResultCallback;
import com.tuya.smart.panel.reactnative.view.laserMap.Lz4Util;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public abstract class AbsLaserManager
extends ReactContextBaseJavaModule {
    private static final String TAG = "AbsLaserManager";

    public AbsLaserManager(ReactApplicationContext reactApplicationContext) {
        super(reactApplicationContext);
    }

    private static String byte2HexStr(byte[] byArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder("");
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(byArray[i2] & 0xFF);
            if (string.length() == 1) {
                string = "0" + string;
            }
            stringBuilder2.append(string);
        }
        return stringBuilder2.toString();
    }

    private String getDeviceID() {
        if ((this = this.getCurrentActivity()) == null) {
            return "";
        }
        return this.getIntent().getStringExtra("devId");
    }

    static /* synthetic */ String access$000(AbsLaserManager absLaserManager) {
        return absLaserManager.getDeviceID();
    }

    static /* synthetic */ ReactApplicationContext access$100(AbsLaserManager absLaserManager) {
        return absLaserManager.getReactApplicationContext();
    }

    public String getName() {
        return "TYRCTLaserManager";
    }

    protected abstract Object toErrorResult(String var1);

    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        TuyaHomeSdk.getSweeperInstance().onDestroy();
    }

    @ReactMethod
    public void setLaserMapState(int n2, Callback callback) {
        L.i((String)TAG, (String)("setLaserMapState is called status=" + n2 + " callback=" + callback));
        f.c().b(n2);
        callback.invoke(new Object[]{n2});
    }

    @ReactMethod
    public void addLaserMapRectWithType(int n2) {
        L.i((String)TAG, (String)("addLaserMapRectWithType is called state=" + n2));
        f.c().a(n2);
    }

    @ReactMethod
    public void getLaserMapPoints(Callback callback) {
        MapPointsData mapPointsData = f.c().f();
        if (mapPointsData.getData() == null) {
            mapPointsData.setData(new ArrayList());
        }
        if (mapPointsData != null) {
            L.i((String)TAG, (String)("getLaserMapPoints  " + mapPointsData));
        }
        callback.invoke(new Object[]{com.tuya.reactnativesweeper.b.c.a(mapPointsData)});
    }

    @ReactMethod
    public void refreshStateView() {
        f.c().a(true);
    }

    @ReactMethod
    public void updateCloudConfig(String string, Callback callback, Callback callback2) {
        TuyaHomeSdk.getSweeperInstance().updateCloudConfig(string, (ITuyaCloudConfigCallback)new a(this, callback, callback2));
    }

    @ReactMethod
    public void getSweeperCurrentPath(String string, Callback callback, Callback callback2) {
        TuyaHomeSdk.getSweeperInstance().getSweeperCurrentPath(string, (ITuyaResultCallback)new b(this, callback, callback2));
    }

    @ReactMethod
    public void startConnectSweeperDataChannel() {
        L.d((String)TAG, (String)" startConnectSweeperDataChannel ");
        TuyaHomeSdk.getSweeperInstance().startConnectSweeperDataChannel((ITuyaSweeperDataListener)new c(this));
    }

    @ReactMethod
    public void stopConnectSweeperDataChannel() {
        L.d((String)TAG, (String)"stop sweeper data channel");
    }

    @ReactMethod
    public void getCloudFileUrl(String string, String string2, Callback callback, Callback callback2) {
        Object object = TuyaHomeSdk.getSweeperInstance().getCloudFileUrl(string, string2);
        if (!TextUtils.isEmpty((CharSequence)object)) {
            callback.invoke(new Object[]{object});
        } else {
            callback2.invoke(new Object[]{"error"});
        }
    }

    @ReactMethod
    public void laserDecompressLZ4(String object, int n2, Callback callback, Callback callback2) {
        if (!TextUtils.isEmpty((CharSequence)object) && n2 > 0) {
            byte[] byArray = Base64.decode((String)object, (int)0);
            Object object2 = byArray;
            if (byArray == null) {
                callback2.invoke(new Object[]{""});
                return;
            }
            byte[] byArray2 = new byte[n2];
            object = byArray2;
            n2 = Lz4Util.lz4DecompressSafe((byte[])object2, byArray2);
            if (n2 <= 0) {
                L.w((String)TAG, (String)("laserDecompressLZ4 DecodeSize =" + n2 + " illegal"));
                callback2.invoke(new Object[]{""});
                return;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
            byteBuffer.put((byte[])object, 0, n2);
            byteBuffer.flip();
            object = AbsLaserManager.byte2HexStr(byteBuffer.array());
            callback.invoke(new Object[]{object});
            L.d((String)TAG, (String)(" i=" + ((AbsLaserManager)object2).length + " byte2HexStr size=" + ((String)object).length()));
            return;
        }
        callback2.invoke(new Object[]{""});
    }
}

