/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.laserMap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import com.tuya.reactnativesweeper.a.a;
import com.tuya.reactnativesweeper.b.b;
import com.tuya.reactnativesweeper.manager.f;
import com.tuya.reactnativesweeper.view.laserMap.LaserMapListener;
import com.tuya.reactnativesweeper.view.laserMap.LaserPoint;
import com.tuya.reactnativesweeper.view.laserMap.layer.CurrentPointLayer;
import com.tuya.reactnativesweeper.view.laserMap.layer.LaserBaseLayer;
import com.tuya.reactnativesweeper.view.laserMap.layer.MapLayer;
import com.tuya.reactnativesweeper.view.laserMap.layer.PathLayer;
import com.tuya.reactnativesweeper.view.laserMap.layer.PileLayer;
import com.tuya.reactnativesweeper.view.laserMap.layer.PlanPathLayer;
import com.tuya.reactnativesweeper.view.sweepercommon.d;
import com.tuya.smart.android.common.utils.L;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LaserMapView
extends AppCompatImageView
implements d {
    private static final String TAG = "LaserMapView";
    private LaserMapListener mListener;
    private Matrix currentMatrix;
    private Matrix innerMatrix;
    private Matrix outerMatrix;
    private float width;
    private float height;
    private float preScale;
    private boolean isMapLoadFinish;
    private PointF mOriginPoint;
    private List<LaserBaseLayer> layers;
    private MapLayer bitmapLayer;
    private PlanPathLayer planPathLayer;
    private PathLayer pathLayer;
    private CurrentPointLayer currentPointLayer;
    private PileLayer pileLayer;

    public LaserMapView(Context context) {
        this(context, null);
    }

    public LaserMapView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public LaserMapView(Context context, AttributeSet attributeSet, int n2) {
        LaserMapView laserMapView = this;
        super(context, attributeSet, n2);
        laserMapView.currentMatrix = new Matrix();
        laserMapView.innerMatrix = new Matrix();
        laserMapView.outerMatrix = new Matrix();
        laserMapView.preScale = 1.0f;
        laserMapView.init();
    }

    private void refresh() {
        this.postInvalidate();
    }

    private void init() {
        LaserMapView laserMapView = this;
        laserMapView.post(new Runnable(){

            @Override
            public void run() {
                1 v0 = this;
                LaserMapView laserMapView = v0.LaserMapView.this;
                LaserMapView.access$002(laserMapView, laserMapView.getWidth());
                LaserMapView laserMapView2 = v0.LaserMapView.this;
                LaserMapView.access$102(laserMapView2, laserMapView2.getHeight());
            }
        });
        laserMapView.layers = new ArrayList<LaserBaseLayer>();
        laserMapView.bitmapLayer = new MapLayer();
        laserMapView.planPathLayer = new PlanPathLayer();
        laserMapView.pathLayer = new PathLayer();
        laserMapView.currentPointLayer = new CurrentPointLayer();
        laserMapView.pileLayer = new PileLayer();
        laserMapView.layers.add(this.bitmapLayer);
        laserMapView.layers.add(this.planPathLayer);
        laserMapView.layers.add(this.pathLayer);
        laserMapView.layers.add(this.pileLayer);
        laserMapView.layers.add(this.currentPointLayer);
    }

    private void updateLayerOrigin() {
        if (b.a(this.layers)) {
            return;
        }
        Iterator<LaserBaseLayer> iterator = this.layers.iterator();
        while (iterator.hasNext()) {
            iterator.next().setOriginPoint(this.mOriginPoint);
        }
    }

    private void refreshAllView() {
        f.c().a(true);
    }

    private void changeCurrentMatrix() {
        LaserMapView laserMapView = this;
        laserMapView.currentMatrix.set(this.innerMatrix);
        laserMapView.currentMatrix.postConcat(this.outerMatrix);
    }

    static /* synthetic */ float access$002(LaserMapView laserMapView, float f2) {
        laserMapView.width = f2;
        return f2;
    }

    static /* synthetic */ float access$102(LaserMapView laserMapView, float f2) {
        laserMapView.height = f2;
        return f2;
    }

    static /* synthetic */ float access$502(LaserMapView laserMapView, float f2) {
        laserMapView.preScale = f2;
        return f2;
    }

    public void setListener(LaserMapListener laserMapListener) {
        this.mListener = laserMapListener;
    }

    protected void onDetachedFromWindow() {
        LaserMapView laserMapView = iterator;
        super.onDetachedFromWindow();
        if (!b.a(laserMapView.layers)) {
            Iterator<LaserBaseLayer> iterator = ((LaserMapView)((Object)iterator)).layers.iterator();
            while (iterator.hasNext()) {
                ((LaserBaseLayer)iterator.next()).release();
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        LaserMapView laserMapView = this;
        super.onDraw(canvas);
        Iterator<LaserBaseLayer> iterator = laserMapView.layers.iterator();
        while (iterator.hasNext()) {
            iterator.next().draw(canvas, this.currentMatrix, this.outerMatrix);
        }
    }

    public void setCurrentPointIcon(Bitmap bitmap) {
        LaserMapView laserMapView = this;
        laserMapView.currentPointLayer.setCurrentPointIcon(bitmap);
        laserMapView.refresh();
    }

    public void setPileIcon(Bitmap bitmap) {
        LaserMapView laserMapView = this;
        laserMapView.pileLayer.setPileIcon(bitmap);
        laserMapView.refresh();
    }

    public void setPilePosition(PointF pointF) {
        LaserMapView laserMapView = this;
        laserMapView.pileLayer.setPilePosition(pointF);
        laserMapView.refresh();
    }

    public void setPathList(List<PointF> list) {
        this.pathLayer.setPathList(list);
        if (!b.a(list)) {
            List<PointF> list2 = list;
            this.currentPointLayer.setCurrentPointPosition(list2.get(list2.size() - 1));
        }
        this.refresh();
    }

    public void setPathList(List<LaserPoint> list, boolean bl) {
        List<LaserPoint> list2 = list;
        PointF pointF = list2.get(list2.size() - 1);
        if (bl) {
            List<LaserPoint> list3 = list;
            list3.remove(list3.size() - 1);
        }
        this.pathLayer.setNewPathList(list);
        if (!b.a(list)) {
            this.currentPointLayer.setCurrentPointPosition(pointF);
        }
        this.refresh();
    }

    public void setPathWidth(float f2) {
        LaserMapView laserMapView = this;
        laserMapView.pathLayer.setPathWidth(f2);
        laserMapView.refresh();
    }

    public void setPathColor(String string) {
        LaserMapView laserMapView = this;
        laserMapView.pathLayer.setPathColor(string);
        laserMapView.refresh();
    }

    public void setPlanPathList(List<PointF> list) {
        LaserMapView laserMapView = this;
        laserMapView.planPathLayer.setPlanPathList(list);
        laserMapView.refresh();
    }

    public void setPlanPathColor(String string) {
        LaserMapView laserMapView = this;
        laserMapView.planPathLayer.setPlanPathColor(string);
        laserMapView.refresh();
    }

    public void setPlanPathWidth(float f2) {
        LaserMapView laserMapView = this;
        laserMapView.planPathLayer.setPlanPathWidth(f2);
        laserMapView.refresh();
    }

    public void drawMap(Bitmap object, int n2, int n3, PointF pointF) {
        if (pointF != null && object != null) {
            float f2;
            float f3;
            boolean bl = false;
            PointF pointF2 = this.mOriginPoint;
            if (pointF2 != null && (pointF2.x != pointF.x || pointF2.y != pointF.y)) {
                bl = true;
            }
            this.mOriginPoint = pointF;
            this.innerMatrix.reset();
            float f4 = 4.0f;
            float f5 = n2;
            float f6 = this.width;
            if (f3 * f4 > f2) {
                f4 = f6 / f5;
            }
            LaserMapView laserMapView = this;
            f5 = laserMapView.width / 2.0f - (float)(n2 / 2);
            f6 = laserMapView.height / 2.0f - (float)(n3 / 2);
            L.i((String)TAG, (String)("setBitmap is called origin=" + this.mOriginPoint.toString() + " width=" + n2 + " height=" + n3 + " scaleX= " + f4 + " originChange= " + bl + " mapBytes=" + object.getByteCount()));
            laserMapView.innerMatrix.postTranslate(f5, f6);
            float f7 = f4;
            laserMapView.innerMatrix.postScale(f7, f7, this.getPivotX(), this.getPivotY());
            laserMapView.bitmapLayer.setBitmap((Bitmap)object);
            laserMapView.changeCurrentMatrix();
            laserMapView.updateLayerOrigin();
            if (bl) {
                this.refreshAllView();
            }
            LaserMapView laserMapView2 = this;
            boolean bl2 = laserMapView2.isMapLoadFinish ^ true;
            laserMapView2.isMapLoadFinish = true;
            laserMapView2.refresh();
            object = laserMapView2.mListener;
            if (object != null) {
                if (bl2) {
                    object.onMapInit();
                } else {
                    object.onMapRefresh();
                }
            }
            return;
        }
    }

    @Override
    public void postTranslate(float f2, float f3) {
        if (!this.isMapLoadFinish) {
            return;
        }
        LaserMapView laserMapView = this;
        laserMapView.outerMatrix.postTranslate(f2, f3);
        laserMapView.changeCurrentMatrix();
        laserMapView.refresh();
    }

    @Override
    public void postScale(float f2, PointF pointF) {
        if (!this.isMapLoadFinish) {
            return;
        }
        LaserMapView laserMapView = this;
        float f3 = this.preScale;
        this.outerMatrix.postScale(f2 / f3, f2 / f3, pointF.x, pointF.y);
        laserMapView.preScale = f2;
        laserMapView.changeCurrentMatrix();
        laserMapView.refresh();
    }

    public void reset(final a.a a2) {
        Matrix matrix;
        Matrix matrix2 = matrix;
        matrix = new Matrix();
        a a3 = new a(this.outerMatrix, matrix2);
        a3.a(new a.a(){

            @Override
            public void onAnimationUpdate(Matrix matrix) {
                2 v0 = this;
                v0.LaserMapView.this.outerMatrix.set(matrix);
                v0.LaserMapView.this.changeCurrentMatrix();
                v0.LaserMapView.this.refresh();
            }

            @Override
            public void onAnimationEnd() {
                2 v0 = this;
                LaserMapView.access$502(v0.LaserMapView.this, 1.0f);
                v0.a2.onAnimationEnd();
            }
        });
        a3.start();
    }

    public PointF calculateInView(PointF pointF) {
        PointF pointF2;
        PointF pointF3 = ((LaserMapView)object).mOriginPoint;
        if (pointF3 == null) {
            return null;
        }
        LaserMapView laserMapView = object;
        float[] fArray = new float[2];
        Object object = fArray;
        object[0] = pointF.x + pointF3.x;
        fArray[1] = pointF.y + pointF3.y;
        laserMapView.currentMatrix.mapPoints((float[])object);
        pointF = pointF2;
        pointF();
        pointF.x = (float)object[0];
        pointF2.y = (float)object[1];
        return pointF2;
    }

    public PointF calculateXYInMap(PointF pointF) {
        PointF pointF2;
        Matrix matrix;
        float[] fArray = new float[2];
        float[] fArray2 = fArray;
        fArray2[0] = pointF.x;
        fArray[1] = pointF.y;
        pointF = matrix;
        pointF();
        laserMapView.currentMatrix.invert((Matrix)pointF);
        matrix.mapPoints(fArray2);
        LaserMapView laserMapView = pointF2;
        laserMapView();
        ((PointF)laserMapView).x = fArray2[0];
        pointF2.y = fArray2[1];
        return pointF2;
    }

    public Matrix getCurrentImageMatrix() {
        return this.outerMatrix;
    }

    public float getPreScale() {
        return this.preScale;
    }

    public boolean isInit() {
        return this.isMapLoadFinish;
    }
}

