/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.googlemap.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.os.Build;
import android.os.Handler;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.core.content.PermissionChecker;
import androidx.core.view.GestureDetectorCompat;
import androidx.core.view.MotionEventCompat;
import androidx.lifecycle.MutableLiveData;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapView;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.Polyline;
import com.tuya.smart.googlemap.manager.GoogleMapManager;
import com.tuya.smart.googlemap.view.GoogleMapCallout;
import com.tuya.smart.googlemap.view.GoogleMapCircle;
import com.tuya.smart.googlemap.view.GoogleMapMarker;
import com.tuya.smart.googlemap.view.GoogleMapPolygon;
import com.tuya.smart.googlemap.view.GoogleMapPolyline;
import com.tuya.smart.googlemap.view.LatLngBoundsUtils;
import com.tuya.smart.googlemap.view.MapFeature;
import com.tuya.smart.googlemap.view.RegionChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GoogleMapView
extends MapView
implements GoogleMap.InfoWindowAdapter,
GoogleMap.OnMarkerDragListener,
OnMapReadyCallback {
    public GoogleMap map;
    private MutableLiveData<Boolean> isMapReady;
    private ProgressBar mapLoadingProgressBar;
    private RelativeLayout mapLoadingLayout;
    private ImageView cacheImageView;
    private Boolean isMapLoaded = false;
    private Integer loadingBackgroundColor = null;
    private Integer loadingIndicatorColor = null;
    private LatLngBounds boundsToMove;
    private boolean showUserLocation = false;
    private boolean isMonitoringRegion = false;
    private boolean isTouchDown = false;
    private boolean handlePanDrag = false;
    private boolean cacheEnabled = false;
    private boolean loadingEnabled = false;
    private static final String[] PERMISSIONS = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
    private final List<MapFeature> features = new ArrayList<MapFeature>();
    private final Map<Marker, GoogleMapMarker> markerMap = new HashMap<Marker, GoogleMapMarker>();
    private final Map<Polyline, GoogleMapPolyline> polylineMap = new HashMap<Polyline, GoogleMapPolyline>();
    private final Map<Polygon, GoogleMapPolygon> polygonMap = new HashMap<Polygon, GoogleMapPolygon>();
    private final Map<Circle, GoogleMapCircle> circleMap = new HashMap<Circle, GoogleMapCircle>();
    private ScaleGestureDetector scaleDetector;
    private GestureDetectorCompat gestureDetector;
    private GoogleMapManager manager;
    private LifecycleEventListener lifecycleListener;
    private View.OnLayoutChangeListener onLayoutChangeListener;
    private boolean paused = false;
    private ThemedReactContext context;
    private ReadableMap mRegion;
    EventDispatcher eventDispatcher;
    private LatLngBounds lastBoundsEmitted;
    Handler timerHandler = new Handler();
    Runnable timerRunnable = new Runnable(){

        @Override
        public void run() {
            if (GoogleMapView.this.map == null) {
                return;
            }
            LatLngBounds bounds = GoogleMapView.this.map.getProjection().getVisibleRegion().latLngBounds;
            if (GoogleMapView.this.lastBoundsEmitted == null || LatLngBoundsUtils.BoundsAreDifferent(bounds, GoogleMapView.this.lastBoundsEmitted)) {
                LatLng center = GoogleMapView.this.map.getCameraPosition().target;
                GoogleMapView.this.lastBoundsEmitted = bounds;
                GoogleMapView.this.eventDispatcher.dispatchEvent((Event)new RegionChangeEvent(GoogleMapView.this.getId(), bounds, center, true));
            }
            GoogleMapView.this.timerHandler.postDelayed((Runnable)this, 100L);
        }
    };

    public MutableLiveData<Boolean> getIsMapReady() {
        return this.isMapReady;
    }

    public GoogleMapView(ThemedReactContext context, Activity activity, GoogleMapManager manager) {
        super((Context)activity);
        this.manager = manager;
        this.context = context;
        this.isMapReady = new MutableLiveData();
        super.onCreate(null);
        super.onResume();
        super.getMapAsync((OnMapReadyCallback)this);
        final GoogleMapView view = this;
        this.scaleDetector = new ScaleGestureDetector((Context)context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureDetector.SimpleOnScaleGestureListener(){

            public boolean onScaleBegin(ScaleGestureDetector detector) {
                view.startMonitoringRegion();
                return true;
            }
        });
        this.gestureDetector = new GestureDetectorCompat((Context)context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                view.startMonitoringRegion();
                return false;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (GoogleMapView.this.handlePanDrag) {
                    GoogleMapView.this.onPanDrag(e2);
                }
                view.startMonitoringRegion();
                return false;
            }
        });
        this.onLayoutChangeListener = new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (!GoogleMapView.this.paused) {
                    GoogleMapView.this.cacheView();
                }
            }
        };
        this.addOnLayoutChangeListener(this.onLayoutChangeListener);
        this.eventDispatcher = ((UIManagerModule)context.getNativeModule(UIManagerModule.class)).getEventDispatcher();
    }

    public void onMapReady(final GoogleMap map) {
        this.map = map;
        this.map.setInfoWindowAdapter((GoogleMap.InfoWindowAdapter)this);
        this.map.setOnMarkerDragListener((GoogleMap.OnMarkerDragListener)this);
        this.isMapReady.postValue((Object)true);
        this.manager.pushEvent((View)this, "onMapReady", (WritableMap)new WritableNativeMap());
        final GoogleMapView view = this;
        map.setOnMarkerClickListener(new GoogleMap.OnMarkerClickListener(){

            public boolean onMarkerClick(Marker marker) {
                WritableMap event = GoogleMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "marker-press");
                GoogleMapView.this.manager.pushEvent((View)view, "onMarkerPress", event);
                event = GoogleMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "marker-press");
                GoogleMapView.this.manager.pushEvent((View)GoogleMapView.this.markerMap.get(marker), "onPress", event);
                return false;
            }
        });
        map.setOnInfoWindowClickListener(new GoogleMap.OnInfoWindowClickListener(){

            public void onInfoWindowClick(Marker marker) {
                WritableMap event = GoogleMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "callout-press");
                GoogleMapView.this.manager.pushEvent((View)view, "onCalloutPress", event);
                event = GoogleMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "callout-press");
                GoogleMapMarker markerView = (GoogleMapMarker)((Object)GoogleMapView.this.markerMap.get(marker));
                GoogleMapView.this.manager.pushEvent((View)markerView, "onCalloutPress", event);
                event = GoogleMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "callout-press");
                GoogleMapCallout infoWindow = markerView.getCalloutView();
                if (infoWindow != null) {
                    GoogleMapView.this.manager.pushEvent((View)infoWindow, "onPress", event);
                }
            }
        });
        map.setOnMapClickListener(new GoogleMap.OnMapClickListener(){

            public void onMapClick(LatLng point) {
                WritableMap event = GoogleMapView.this.makeClickEventData(point);
                event.putString("action", "press");
                GoogleMapView.this.manager.pushEvent((View)view, "onPress", event);
            }
        });
        map.setOnMapLongClickListener(new GoogleMap.OnMapLongClickListener(){

            public void onMapLongClick(LatLng point) {
                WritableMap event = GoogleMapView.this.makeClickEventData(point);
                event.putString("action", "long-press");
                GoogleMapView.this.manager.pushEvent((View)view, "onLongPress", GoogleMapView.this.makeClickEventData(point));
            }
        });
        map.setOnCameraChangeListener(new GoogleMap.OnCameraChangeListener(){

            public void onCameraChange(CameraPosition position) {
                LatLngBounds bounds = map.getProjection().getVisibleRegion().latLngBounds;
                LatLng center = position.target;
                GoogleMapView.this.lastBoundsEmitted = bounds;
                GoogleMapView.this.eventDispatcher.dispatchEvent((Event)new RegionChangeEvent(GoogleMapView.this.getId(), bounds, center, GoogleMapView.this.isTouchDown));
                view.stopMonitoringRegion();
            }
        });
        map.setOnMapLoadedCallback(new GoogleMap.OnMapLoadedCallback(){

            public void onMapLoaded() {
                GoogleMapView.this.isMapLoaded = true;
                GoogleMapView.this.cacheView();
            }
        });
        this.lifecycleListener = new LifecycleEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @SuppressLint(value={"MissingPermission"})
            public void onHostResume() {
                if (GoogleMapView.this.hasPermissions()) {
                    map.setMyLocationEnabled(GoogleMapView.this.showUserLocation);
                }
                GoogleMapView googleMapView = GoogleMapView.this;
                synchronized (googleMapView) {
                    GoogleMapView.this.onResume();
                    GoogleMapView.this.paused = false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @SuppressLint(value={"MissingPermission"})
            public void onHostPause() {
                if (GoogleMapView.this.hasPermissions()) {
                    map.setMyLocationEnabled(false);
                }
                GoogleMapView googleMapView = GoogleMapView.this;
                synchronized (googleMapView) {
                    GoogleMapView.this.onPause();
                    GoogleMapView.this.paused = true;
                }
            }

            public void onHostDestroy() {
                GoogleMapView.this.doDestroy();
            }
        };
        this.context.addLifecycleEventListener(this.lifecycleListener);
    }

    private boolean hasPermissions() {
        return PermissionChecker.checkSelfPermission((Context)this.getContext(), (String)PERMISSIONS[0]) == 0 || PermissionChecker.checkSelfPermission((Context)this.getContext(), (String)PERMISSIONS[1]) == 0;
    }

    public synchronized void doDestroy() {
        if (this.lifecycleListener != null) {
            this.context.removeLifecycleEventListener(this.lifecycleListener);
            this.lifecycleListener = null;
        }
        if (!this.paused) {
            this.onPause();
        }
        this.onDestroy();
    }

    public void setRegion(ReadableMap region) {
        if (region == null) {
            return;
        }
        this.mRegion = region;
        if (this.map == null) {
            return;
        }
        Double lng = region.getDouble("longitude");
        Double lat = region.getDouble("latitude");
        Double lngDelta = region.getDouble("longitudeDelta");
        Double latDelta = region.getDouble("latitudeDelta");
        LatLngBounds bounds = new LatLngBounds(new LatLng(lat - latDelta / 2.0, lng - lngDelta / 2.0), new LatLng(lat + latDelta / 2.0, lng + lngDelta / 2.0));
        if (super.getHeight() <= 0 || super.getWidth() <= 0) {
            this.map.moveCamera(CameraUpdateFactory.newLatLngZoom((LatLng)new LatLng(lat.doubleValue(), lng.doubleValue()), (float)10.0f));
            this.boundsToMove = bounds;
        } else {
            this.map.moveCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)0));
            this.boundsToMove = null;
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void setShowsUserLocation(boolean showUserLocation) {
        if (this.map == null) {
            return;
        }
        this.showUserLocation = showUserLocation;
        if (this.hasPermissions()) {
            this.map.setMyLocationEnabled(showUserLocation);
        }
    }

    public void setToolbarEnabled(boolean toolbarEnabled) {
        if (this.map == null) {
            return;
        }
        if (this.hasPermissions()) {
            this.map.getUiSettings().setMapToolbarEnabled(toolbarEnabled);
        }
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
        this.cacheView();
    }

    public void enableMapLoading(boolean loadingEnabled) {
        if (loadingEnabled && !this.isMapLoaded.booleanValue()) {
            this.getMapLoadingLayoutView().setVisibility(0);
        }
    }

    public void setLoadingBackgroundColor(Integer loadingBackgroundColor) {
        this.loadingBackgroundColor = loadingBackgroundColor;
        if (this.mapLoadingLayout != null) {
            if (loadingBackgroundColor == null) {
                this.mapLoadingLayout.setBackgroundColor(-1);
            } else {
                this.mapLoadingLayout.setBackgroundColor(this.loadingBackgroundColor.intValue());
            }
        }
    }

    public void setLoadingIndicatorColor(Integer loadingIndicatorColor) {
        this.loadingIndicatorColor = loadingIndicatorColor;
        if (this.mapLoadingProgressBar != null) {
            Integer color = loadingIndicatorColor;
            if (color == null) {
                color = Color.parseColor((String)"#606060");
            }
            if (Build.VERSION.SDK_INT >= 21) {
                ColorStateList progressTintList = ColorStateList.valueOf((int)loadingIndicatorColor);
                ColorStateList secondaryProgressTintList = ColorStateList.valueOf((int)loadingIndicatorColor);
                ColorStateList indeterminateTintList = ColorStateList.valueOf((int)loadingIndicatorColor);
                this.mapLoadingProgressBar.setProgressTintList(progressTintList);
                this.mapLoadingProgressBar.setSecondaryProgressTintList(secondaryProgressTintList);
                this.mapLoadingProgressBar.setIndeterminateTintList(indeterminateTintList);
            } else {
                PorterDuff.Mode mode = PorterDuff.Mode.SRC_IN;
                if (Build.VERSION.SDK_INT <= 10) {
                    mode = PorterDuff.Mode.MULTIPLY;
                }
                if (this.mapLoadingProgressBar.getIndeterminateDrawable() != null) {
                    this.mapLoadingProgressBar.getIndeterminateDrawable().setColorFilter(color.intValue(), mode);
                }
                if (this.mapLoadingProgressBar.getProgressDrawable() != null) {
                    this.mapLoadingProgressBar.getProgressDrawable().setColorFilter(color.intValue(), mode);
                }
            }
        }
    }

    public void setHandlePanDrag(boolean handlePanDrag) {
        this.handlePanDrag = handlePanDrag;
    }

    public void addFeature(View child, int index) {
        if (child instanceof GoogleMapMarker) {
            GoogleMapMarker annotation = (GoogleMapMarker)child;
            annotation.addToMap(this.map);
            this.features.add(index, annotation);
            Marker marker = (Marker)annotation.getFeature();
            this.markerMap.put(marker, annotation);
        } else if (child instanceof GoogleMapPolyline) {
            GoogleMapPolyline polylineView = (GoogleMapPolyline)child;
            polylineView.addToMap(this.map);
            this.features.add(index, polylineView);
            Polyline polyline = (Polyline)polylineView.getFeature();
            this.polylineMap.put(polyline, polylineView);
        } else if (child instanceof GoogleMapPolygon) {
            GoogleMapPolygon polygonView = (GoogleMapPolygon)child;
            polygonView.addToMap(this.map);
            this.features.add(index, polygonView);
            Polygon polygon = (Polygon)polygonView.getFeature();
            this.polygonMap.put(polygon, polygonView);
        } else if (child instanceof GoogleMapCircle) {
            GoogleMapCircle circleView = (GoogleMapCircle)child;
            circleView.addToMap(this.map);
            this.features.add(index, circleView);
            Circle circle = (Circle)circleView.getFeature();
            this.circleMap.put(circle, circleView);
        }
    }

    public int getFeatureCount() {
        return this.features.size();
    }

    public View getFeatureAt(int index) {
        return (View)this.features.get(index);
    }

    public void removeFeatureAt(int index) {
        if (this.map == null) {
            return;
        }
        MapFeature feature = this.features.remove(index);
        if (feature instanceof GoogleMapMarker) {
            this.markerMap.remove(feature.getFeature());
        } else if (feature instanceof GoogleMapPolyline) {
            this.polylineMap.remove(feature.getFeature());
        } else if (feature instanceof GoogleMapPolygon) {
            this.polygonMap.remove(feature.getFeature());
        } else if (feature instanceof GoogleMapCircle) {
            this.circleMap.remove(feature.getFeature());
        }
        feature.removeFromMap(this.map);
    }

    public WritableMap makeClickEventData(LatLng point) {
        WritableNativeMap event = new WritableNativeMap();
        WritableNativeMap coordinate = new WritableNativeMap();
        coordinate.putDouble("latitude", point.latitude);
        coordinate.putDouble("longitude", point.longitude);
        event.putMap("coordinate", (WritableMap)coordinate);
        Projection projection = this.map.getProjection();
        Point screenPoint = projection.toScreenLocation(point);
        WritableNativeMap position = new WritableNativeMap();
        position.putDouble("x", (double)screenPoint.x);
        position.putDouble("y", (double)screenPoint.y);
        event.putMap("position", (WritableMap)position);
        return event;
    }

    public void updateExtraData(Object extraData) {
        if (this.map == null) {
            return;
        }
        if (this.boundsToMove != null) {
            HashMap data = (HashMap)extraData;
            float width = ((Float)data.get("width")).floatValue();
            float height = ((Float)data.get("height")).floatValue();
            this.map.moveCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)this.boundsToMove, (int)((int)width), (int)((int)height), (int)0));
            this.boundsToMove = null;
        }
    }

    public void animateToRegion(LatLngBounds bounds, int duration) {
        if (this.map == null) {
            return;
        }
        this.startMonitoringRegion();
        this.map.animateCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)0), duration, null);
    }

    public void animateToCoordinate(LatLng coordinate, int duration) {
        if (this.map == null) {
            return;
        }
        this.startMonitoringRegion();
        this.map.animateCamera(CameraUpdateFactory.newLatLng((LatLng)coordinate), duration, null);
    }

    public void fitToElements(boolean animated) {
        if (this.map == null) {
            return;
        }
        LatLngBounds.Builder builder = new LatLngBounds.Builder();
        for (MapFeature feature : this.features) {
            if (!(feature instanceof GoogleMapMarker)) continue;
            Marker marker = (Marker)feature.getFeature();
            builder.include(marker.getPosition());
        }
        LatLngBounds bounds = builder.build();
        CameraUpdate cu = CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)50);
        if (animated) {
            this.startMonitoringRegion();
            this.map.animateCamera(cu);
        } else {
            this.map.moveCamera(cu);
        }
    }

    public void fitToCoordinates(ReadableArray coordinatesArray, ReadableMap edgePadding, boolean animated) {
        if (this.map == null) {
            return;
        }
        LatLngBounds.Builder builder = new LatLngBounds.Builder();
        for (int i = 0; i < coordinatesArray.size(); ++i) {
            ReadableMap latLng = coordinatesArray.getMap(i);
            Double lat = latLng.getDouble("latitude");
            Double lng = latLng.getDouble("longitude");
            builder.include(new LatLng(lat.doubleValue(), lng.doubleValue()));
        }
        LatLngBounds bounds = builder.build();
        CameraUpdate cu = CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)50);
        if (edgePadding != null) {
            this.map.setPadding(edgePadding.getInt("left"), edgePadding.getInt("top"), edgePadding.getInt("right"), edgePadding.getInt("bottom"));
        }
        if (animated) {
            this.map.animateCamera(cu);
        } else {
            this.map.moveCamera(cu);
        }
        this.map.setPadding(0, 0, 0, 0);
    }

    public View getInfoWindow(Marker marker) {
        GoogleMapMarker markerView = this.markerMap.get(marker);
        return markerView.getCallout();
    }

    public View getInfoContents(Marker marker) {
        GoogleMapMarker markerView = this.markerMap.get(marker);
        return markerView.getInfoContents();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.scaleDetector.onTouchEvent(ev);
        this.gestureDetector.onTouchEvent(ev);
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 0: {
                this.isTouchDown = true;
                break;
            }
            case 2: {
                this.startMonitoringRegion();
                break;
            }
            case 1: {
                this.isTouchDown = false;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public void startMonitoringRegion() {
        if (this.isMonitoringRegion) {
            return;
        }
        this.timerHandler.postDelayed(this.timerRunnable, 100L);
        this.isMonitoringRegion = true;
    }

    public void stopMonitoringRegion() {
        if (!this.isMonitoringRegion) {
            return;
        }
        this.timerHandler.removeCallbacks(this.timerRunnable);
        this.isMonitoringRegion = false;
    }

    public void onMarkerDragStart(Marker marker) {
        WritableMap event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent((View)this, "onMarkerDragStart", event);
        GoogleMapMarker markerView = this.markerMap.get(marker);
        event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent((View)markerView, "onDragStart", event);
    }

    public void onMarkerDrag(Marker marker) {
        WritableMap event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent((View)this, "onMarkerDrag", event);
        GoogleMapMarker markerView = this.markerMap.get(marker);
        event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent((View)markerView, "onDrag", event);
    }

    public void onMarkerDragEnd(Marker marker) {
        WritableMap event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent((View)this, "onMarkerDragEnd", event);
        GoogleMapMarker markerView = this.markerMap.get(marker);
        event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent((View)markerView, "onDragEnd", event);
    }

    private ProgressBar getMapLoadingProgressBar() {
        if (this.mapLoadingProgressBar == null) {
            this.mapLoadingProgressBar = new ProgressBar(this.getContext());
            this.mapLoadingProgressBar.setIndeterminate(true);
        }
        this.setLoadingIndicatorColor(this.loadingIndicatorColor);
        return this.mapLoadingProgressBar;
    }

    private RelativeLayout getMapLoadingLayoutView() {
        if (this.mapLoadingLayout == null) {
            this.mapLoadingLayout = new RelativeLayout(this.getContext());
            this.mapLoadingLayout.setBackgroundColor(-3355444);
            this.addView((View)this.mapLoadingLayout, new ViewGroup.LayoutParams(-1, -1));
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
            params.addRule(13);
            this.mapLoadingLayout.addView((View)this.getMapLoadingProgressBar(), (ViewGroup.LayoutParams)params);
            this.mapLoadingLayout.setVisibility(4);
        }
        this.setLoadingBackgroundColor(this.loadingBackgroundColor);
        return this.mapLoadingLayout;
    }

    private ImageView getCacheImageView() {
        if (this.cacheImageView == null) {
            this.cacheImageView = new ImageView(this.getContext());
            this.addView((View)this.cacheImageView, new ViewGroup.LayoutParams(-1, -1));
            this.cacheImageView.setVisibility(4);
        }
        return this.cacheImageView;
    }

    private void removeCacheImageView() {
        if (this.cacheImageView != null) {
            ((ViewGroup)this.cacheImageView.getParent()).removeView((View)this.cacheImageView);
            this.cacheImageView = null;
        }
    }

    private void removeMapLoadingProgressBar() {
        if (this.mapLoadingProgressBar != null) {
            ((ViewGroup)this.mapLoadingProgressBar.getParent()).removeView((View)this.mapLoadingProgressBar);
            this.mapLoadingProgressBar = null;
        }
    }

    private void removeMapLoadingLayoutView() {
        this.removeMapLoadingProgressBar();
        if (this.mapLoadingLayout != null) {
            ((ViewGroup)this.mapLoadingLayout.getParent()).removeView((View)this.mapLoadingLayout);
            this.mapLoadingLayout = null;
        }
    }

    private void cacheView() {
        if (this.cacheEnabled) {
            final ImageView cacheImageView = this.getCacheImageView();
            final RelativeLayout mapLoadingLayout = this.getMapLoadingLayoutView();
            cacheImageView.setVisibility(4);
            mapLoadingLayout.setVisibility(0);
            if (this.isMapLoaded.booleanValue()) {
                if (this.map == null) {
                    return;
                }
                this.map.snapshot(new GoogleMap.SnapshotReadyCallback(){

                    public void onSnapshotReady(Bitmap bitmap) {
                        cacheImageView.setImageBitmap(bitmap);
                        cacheImageView.setVisibility(0);
                        mapLoadingLayout.setVisibility(4);
                    }
                });
            }
        } else {
            this.removeCacheImageView();
            if (this.isMapLoaded.booleanValue()) {
                this.removeMapLoadingLayoutView();
            }
        }
    }

    public void onPanDrag(MotionEvent ev) {
        if (this.map == null) {
            return;
        }
        Point point = new Point((int)ev.getX(), (int)ev.getY());
        LatLng coords = this.map.getProjection().fromScreenLocation(point);
        WritableMap event = this.makeClickEventData(coords);
        this.manager.pushEvent((View)this, "onPanDrag", event);
    }

    public double[][] getMapBoundaries() {
        LatLngBounds bounds = this.map.getProjection().getVisibleRegion().latLngBounds;
        LatLng northEast = bounds.northeast;
        LatLng southWest = bounds.southwest;
        return new double[][]{{northEast.longitude, northEast.latitude}, {southWest.longitude, southWest.latitude}};
    }

    public void setMapBoundaries(ReadableMap northEast, ReadableMap southWest) {
        if (this.map == null) {
            return;
        }
        LatLngBounds.Builder builder = new LatLngBounds.Builder();
        Double latNE = northEast.getDouble("latitude");
        Double lngNE = northEast.getDouble("longitude");
        builder.include(new LatLng(latNE.doubleValue(), lngNE.doubleValue()));
        Double latSW = southWest.getDouble("latitude");
        Double lngSW = southWest.getDouble("longitude");
        builder.include(new LatLng(latSW.doubleValue(), lngSW.doubleValue()));
        LatLngBounds bounds = builder.build();
        this.map.setLatLngBoundsForCameraTarget(bounds);
    }
}

