/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.googlemap.manager;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.model.Marker;
import com.tuya.smart.googlemap.manager.MapMarkerManager;
import com.tuya.smart.googlemap.view.GoogleMapCallout;
import com.tuya.smart.googlemap.view.GoogleMapMarker;
import com.tuya.smart.googlemap.view.SizeReportingShadowNode;
import java.util.HashMap;
import java.util.Map;

public class GoogleMapMarkerManager
extends MapMarkerManager<GoogleMapMarker> {
    public static final int SHOW_INFO_WINDOW = 1;
    public static final int HIDE_INFO_WINDOW = 2;
    private ThemedReactContext mReactContext;

    @Override
    public GoogleMapMarker createViewInstance(ThemedReactContext context) {
        this.mReactContext = context;
        try {
            MapsInitializer.initialize((Context)context);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.emitMapError("Map initialize error", "map_init_error");
        }
        return new GoogleMapMarker((Context)context);
    }

    protected void emitMapError(String message, String type) {
        WritableMap error = Arguments.createMap();
        error.putString("message", message);
        error.putString("type", type);
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.mReactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("onError", (Object)error);
    }

    @Override
    public void setCoordinate(GoogleMapMarker view, ReadableMap map) {
        view.setCoordinate(map);
    }

    @Override
    public void setTitle(GoogleMapMarker view, String title) {
        view.setTitle(title);
    }

    @Override
    public void setDescription(GoogleMapMarker view, String description) {
        view.setSnippet(description);
    }

    @Override
    public void setAnchor(GoogleMapMarker view, ReadableMap map) {
        double x = map != null && map.hasKey("x") ? map.getDouble("x") : 0.5;
        double y = map != null && map.hasKey("y") ? map.getDouble("y") : 1.0;
        view.setAnchor(x, y);
    }

    @Override
    public void setCalloutAnchor(GoogleMapMarker view, ReadableMap map) {
        double x = map != null && map.hasKey("x") ? map.getDouble("x") : 0.5;
        double y = map != null && map.hasKey("y") ? map.getDouble("y") : 0.0;
        view.setCalloutAnchor(x, y);
    }

    @Override
    public void setImage(GoogleMapMarker view, @Nullable String source) {
        view.setImage(source);
    }

    @Override
    public void setPinColor(GoogleMapMarker view, int pinColor) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)pinColor, (float[])hsv);
        view.setMarkerHue(hsv[0]);
    }

    @Override
    public void setMarkerRotation(GoogleMapMarker view, float rotation) {
        view.setRotation(rotation);
    }

    @Override
    public void setFlat(GoogleMapMarker view, boolean flat) {
        view.setFlat(flat);
    }

    @Override
    public void setDraggable(GoogleMapMarker view, boolean draggable) {
        view.setDraggable(draggable);
    }

    public void addView(GoogleMapMarker parent, View child, int index) {
        if (child instanceof GoogleMapCallout) {
            parent.setCalloutView((GoogleMapCallout)child);
        } else {
            super.addView((ViewGroup)parent, child, index);
            parent.update();
        }
    }

    public void removeViewAt(GoogleMapMarker parent, int index) {
        super.removeViewAt((ViewGroup)parent, index);
        parent.update();
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of((Object)"showCallout", (Object)1, (Object)"hideCallout", (Object)2);
    }

    public void receiveCommand(GoogleMapMarker view, int commandId, @Nullable ReadableArray args) {
        if (view == null || view.getFeature() == null) {
            return;
        }
        switch (commandId) {
            case 1: {
                ((Marker)view.getFeature()).showInfoWindow();
                break;
            }
            case 2: {
                ((Marker)view.getFeature()).hideInfoWindow();
            }
        }
    }

    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        Map map = MapBuilder.of((Object)"onPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onPress"), (Object)"onCalloutPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onCalloutPress"), (Object)"onDragStart", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDragStart"), (Object)"onDrag", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDrag"), (Object)"onDragEnd", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDragEnd"));
        map.putAll(MapBuilder.of((Object)"onDragStart", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDragStart"), (Object)"onDrag", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDrag"), (Object)"onDragEnd", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDragEnd")));
        return map;
    }

    public LayoutShadowNode createShadowNodeInstance() {
        return new SizeReportingShadowNode();
    }

    public void updateExtraData(GoogleMapMarker view, Object extraData) {
        HashMap data = (HashMap)extraData;
        float width = ((Float)data.get("width")).floatValue();
        float height = ((Float)data.get("height")).floatValue();
        view.update((int)width, (int)height);
    }
}

