/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.googlemap.manager;

import android.content.Context;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.tuya.smart.googlemap.manager.MapManager;
import com.tuya.smart.googlemap.view.GoogleMapView;
import com.tuya.smart.googlemap.view.SizeReportingShadowNode;
import java.util.Map;

public class GoogleMapManager
extends MapManager<GoogleMapView> {
    public static final int ANIMATE_TO_REGION = 1;
    public static final int ANIMATE_TO_COORDINATE = 2;
    public static final int FIT_TO_ELEMENTS = 3;
    private static final int FIT_TO_COORDINATES = 7;
    private final Map<String, Integer> MAP_TYPES = MapBuilder.of((Object)"standard", (Object)1, (Object)"satellite", (Object)2, (Object)"hybrid", (Object)4, (Object)"terrain", (Object)3);

    @Override
    protected GoogleMapView createViewInstance(ThemedReactContext context) {
        super.createViewInstance(context);
        try {
            MapsInitializer.initialize((Context)context);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.emitMapError("Map initialize error", "map_init_error");
        }
        return new GoogleMapView(context, context.getCurrentActivity(), this);
    }

    public void onDropViewInstance(GoogleMapView view) {
        try {
            view.doDestroy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onDropViewInstance((View)view);
    }

    @Override
    public void setRegion(final GoogleMapView view, final ReadableMap region) {
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.setRegion(region);
            }
        });
    }

    @Override
    public void setMapType(final GoogleMapView view, final @Nullable String mapType) {
        if (view == null || view.map == null) {
            return;
        }
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                int typeId = (Integer)GoogleMapManager.this.MAP_TYPES.get(mapType);
                view.map.setMapType(typeId);
            }
        });
    }

    @Override
    public void setShowsUserLocation(final GoogleMapView view, final boolean showUserLocation) {
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.setShowsUserLocation(showUserLocation);
            }
        });
    }

    @Override
    public void setToolbarEnabled(final GoogleMapView view, final boolean toolbarEnabled) {
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.setToolbarEnabled(toolbarEnabled);
            }
        });
    }

    @Override
    public void setHandlePanDrag(final GoogleMapView view, final boolean handlePanDrag) {
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.setHandlePanDrag(handlePanDrag);
            }
        });
    }

    @Override
    public void setShowTraffic(final GoogleMapView view, final boolean showTraffic) {
        if (view == null || view.map == null) {
            return;
        }
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.map.setTrafficEnabled(showTraffic);
            }
        });
    }

    @Override
    public void setShowBuildings(final GoogleMapView view, final boolean showBuildings) {
        if (view == null || view.map == null) {
            return;
        }
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.map.setBuildingsEnabled(showBuildings);
            }
        });
    }

    @Override
    public void setShowIndoors(final GoogleMapView view, final boolean showIndoors) {
        if (view == null || view.map == null) {
            return;
        }
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.map.setIndoorEnabled(showIndoors);
            }
        });
    }

    @Override
    public void setShowsCompass(final GoogleMapView view, final boolean showsCompass) {
        if (view == null || view.map == null) {
            return;
        }
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.map.getUiSettings().setCompassEnabled(showsCompass);
            }
        });
    }

    @Override
    public void setScrollEnabled(final GoogleMapView view, final boolean scrollEnabled) {
        if (view == null || view.map == null) {
            return;
        }
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.map.getUiSettings().setScrollGesturesEnabled(scrollEnabled);
            }
        });
    }

    @Override
    public void setZoomEnabled(final GoogleMapView view, final boolean zoomEnabled) {
        if (view == null || view.map == null) {
            return;
        }
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.map.getUiSettings().setZoomGesturesEnabled(zoomEnabled);
            }
        });
    }

    @Override
    public void setRotateEnabled(final GoogleMapView view, final boolean rotateEnabled) {
        if (view == null || view.map == null) {
            return;
        }
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.map.getUiSettings().setRotateGesturesEnabled(rotateEnabled);
            }
        });
    }

    @Override
    public void setCacheEnabled(final GoogleMapView view, final boolean cacheEnabled) {
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.setCacheEnabled(cacheEnabled);
            }
        });
    }

    @Override
    public void setLoadingEnabled(final GoogleMapView view, final boolean loadingEnabled) {
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.enableMapLoading(loadingEnabled);
            }
        });
    }

    @Override
    public void setLoadingBackgroundColor(GoogleMapView view, @Nullable Integer loadingBackgroundColor) {
        view.setLoadingBackgroundColor(loadingBackgroundColor);
    }

    @Override
    public void setLoadingIndicatorColor(GoogleMapView view, @Nullable Integer loadingIndicatorColor) {
        view.setLoadingIndicatorColor(loadingIndicatorColor);
    }

    @Override
    public void setPitchEnabled(final GoogleMapView view, final boolean pitchEnabled) {
        if (view == null || view.map == null) {
            return;
        }
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.map.getUiSettings().setTiltGesturesEnabled(pitchEnabled);
            }
        });
    }

    public void receiveCommand(final GoogleMapView view, int commandId, final @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                ReadableMap region = args.getMap(0);
                Integer duration = args.getInt(1);
                Double lng = region.getDouble("longitude");
                Double lat = region.getDouble("latitude");
                Double lngDelta = region.getDouble("longitudeDelta");
                Double latDelta = region.getDouble("latitudeDelta");
                LatLngBounds bounds = new LatLngBounds(new LatLng(lat - latDelta / 2.0, lng - lngDelta / 2.0), new LatLng(lat + latDelta / 2.0, lng + lngDelta / 2.0));
                view.animateToRegion(bounds, duration);
                break;
            }
            case 2: {
                ReadableMap region = args.getMap(0);
                Integer duration = args.getInt(1);
                Double lng = region.getDouble("longitude");
                Double lat = region.getDouble("latitude");
                view.animateToCoordinate(new LatLng(lat.doubleValue(), lng.doubleValue()), duration);
                break;
            }
            case 3: {
                view.fitToElements(args.getBoolean(0));
                break;
            }
            case 7: {
                view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

                    public void onChanged(Boolean aBoolean) {
                        view.fitToCoordinates(args.getArray(0), args.getMap(1), args.getBoolean(2));
                    }
                });
            }
        }
    }

    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        Map map = MapBuilder.of((Object)"onMapReady", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMapReady"), (Object)"onPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onPress"), (Object)"onLongPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onLongPress"), (Object)"onMarkerPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerPress"), (Object)"onMarkerSelect", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerSelect"), (Object)"onMarkerDeselect", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDeselect"), (Object)"onCalloutPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onCalloutPress"));
        map.putAll(MapBuilder.of((Object)"onMarkerDragStart", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDragStart"), (Object)"onMarkerDrag", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDrag"), (Object)"onMarkerDragEnd", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDragEnd"), (Object)"onPanDrag", (Object)MapBuilder.of((Object)"registrationName", (Object)"onPanDrag")));
        return map;
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of((Object)"animateToRegion", (Object)1, (Object)"animateToCoordinate", (Object)2, (Object)"fitToElements", (Object)3, (Object)"fitToCoordinates", (Object)7);
    }

    public LayoutShadowNode createShadowNodeInstance() {
        return new SizeReportingShadowNode();
    }

    public void addView(final GoogleMapView parent, final View child, final int index) {
        parent.getIsMapReady().observe((LifecycleOwner)parent.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                parent.addFeature(child, index);
            }
        });
    }

    public int getChildCount(GoogleMapView view) {
        return view.getFeatureCount();
    }

    public View getChildAt(GoogleMapView view, int index) {
        return view.getFeatureAt(index);
    }

    public void removeViewAt(final GoogleMapView parent, final int index) {
        parent.getIsMapReady().observe((LifecycleOwner)parent.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                parent.removeFeatureAt(index);
            }
        });
    }

    public void updateExtraData(final GoogleMapView view, final Object extraData) {
        view.getIsMapReady().observe((LifecycleOwner)view.getContext(), (Observer)new Observer<Boolean>(){

            public void onChanged(Boolean aBoolean) {
                view.updateExtraData(extraData);
            }
        });
    }
}

