/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.googlemap.manager;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.View;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.tuya.smart.googlemap.manager.MapManager;
import com.tuya.smart.googlemap.view.GoogleMapView;
import com.tuya.smart.googlemap.view.SizeReportingShadowNode;
import java.util.Map;

public class GoogleMapManager
extends MapManager<GoogleMapView> {
    public static final int ANIMATE_TO_REGION = 1;
    public static final int ANIMATE_TO_COORDINATE = 2;
    public static final int FIT_TO_ELEMENTS = 3;
    private final Map<String, Integer> MAP_TYPES = MapBuilder.of((Object)"standard", (Object)1, (Object)"satellite", (Object)2, (Object)"hybrid", (Object)4, (Object)"terrain", (Object)3);

    @Override
    protected GoogleMapView createViewInstance(ThemedReactContext context) {
        super.createViewInstance(context);
        try {
            MapsInitializer.initialize((Context)context);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.emitMapError("Map initialize error", "map_init_error");
        }
        return new GoogleMapView(context, context.getCurrentActivity(), this);
    }

    public void onDropViewInstance(GoogleMapView view) {
        view.doDestroy();
        super.onDropViewInstance((View)view);
    }

    @Override
    public void setRegion(GoogleMapView view, ReadableMap region) {
        view.setRegion(region);
    }

    @Override
    public void setMapType(GoogleMapView view, @Nullable String mapType) {
        int typeId = this.MAP_TYPES.get(mapType);
        view.map.setMapType(typeId);
    }

    @Override
    public void setShowsUserLocation(GoogleMapView view, boolean showUserLocation) {
        view.setShowsUserLocation(showUserLocation);
    }

    @Override
    public void setToolbarEnabled(GoogleMapView view, boolean toolbarEnabled) {
        view.setToolbarEnabled(toolbarEnabled);
    }

    @Override
    public void setHandlePanDrag(GoogleMapView view, boolean handlePanDrag) {
        view.setHandlePanDrag(handlePanDrag);
    }

    @Override
    public void setShowTraffic(GoogleMapView view, boolean showTraffic) {
        view.map.setTrafficEnabled(showTraffic);
    }

    @Override
    public void setShowBuildings(GoogleMapView view, boolean showBuildings) {
        view.map.setBuildingsEnabled(showBuildings);
    }

    @Override
    public void setShowIndoors(GoogleMapView view, boolean showIndoors) {
        view.map.setIndoorEnabled(showIndoors);
    }

    @Override
    public void setShowsCompass(GoogleMapView view, boolean showsCompass) {
        view.map.getUiSettings().setCompassEnabled(showsCompass);
    }

    @Override
    public void setScrollEnabled(GoogleMapView view, boolean scrollEnabled) {
        view.map.getUiSettings().setScrollGesturesEnabled(scrollEnabled);
    }

    @Override
    public void setZoomEnabled(GoogleMapView view, boolean zoomEnabled) {
        view.map.getUiSettings().setZoomGesturesEnabled(zoomEnabled);
    }

    @Override
    public void setRotateEnabled(GoogleMapView view, boolean rotateEnabled) {
        view.map.getUiSettings().setRotateGesturesEnabled(rotateEnabled);
    }

    @Override
    public void setCacheEnabled(GoogleMapView view, boolean cacheEnabled) {
        view.setCacheEnabled(cacheEnabled);
    }

    @Override
    public void setLoadingEnabled(GoogleMapView view, boolean loadingEnabled) {
        view.enableMapLoading(loadingEnabled);
    }

    @Override
    public void setLoadingBackgroundColor(GoogleMapView view, @Nullable Integer loadingBackgroundColor) {
        view.setLoadingBackgroundColor(loadingBackgroundColor);
    }

    @Override
    public void setLoadingIndicatorColor(GoogleMapView view, @Nullable Integer loadingIndicatorColor) {
        view.setLoadingIndicatorColor(loadingIndicatorColor);
    }

    @Override
    public void setPitchEnabled(GoogleMapView view, boolean pitchEnabled) {
        view.map.getUiSettings().setTiltGesturesEnabled(pitchEnabled);
    }

    public void receiveCommand(GoogleMapView view, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                ReadableMap region = args.getMap(0);
                Integer duration = args.getInt(1);
                Double lng = region.getDouble("longitude");
                Double lat = region.getDouble("latitude");
                Double lngDelta = region.getDouble("longitudeDelta");
                Double latDelta = region.getDouble("latitudeDelta");
                LatLngBounds bounds = new LatLngBounds(new LatLng(lat - latDelta / 2.0, lng - lngDelta / 2.0), new LatLng(lat + latDelta / 2.0, lng + lngDelta / 2.0));
                view.animateToRegion(bounds, duration);
                break;
            }
            case 2: {
                ReadableMap region = args.getMap(0);
                Integer duration = args.getInt(1);
                Double lng = region.getDouble("longitude");
                Double lat = region.getDouble("latitude");
                view.animateToCoordinate(new LatLng(lat.doubleValue(), lng.doubleValue()), duration);
                break;
            }
            case 3: {
                view.fitToElements(args.getBoolean(0));
            }
        }
    }

    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        Map map = MapBuilder.of((Object)"onMapReady", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMapReady"), (Object)"onPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onPress"), (Object)"onLongPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onLongPress"), (Object)"onMarkerPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerPress"), (Object)"onMarkerSelect", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerSelect"), (Object)"onMarkerDeselect", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDeselect"), (Object)"onCalloutPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onCalloutPress"));
        map.putAll(MapBuilder.of((Object)"onMarkerDragStart", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDragStart"), (Object)"onMarkerDrag", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDrag"), (Object)"onMarkerDragEnd", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDragEnd"), (Object)"onPanDrag", (Object)MapBuilder.of((Object)"registrationName", (Object)"onPanDrag")));
        return map;
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of((Object)"animateToRegion", (Object)1, (Object)"animateToCoordinate", (Object)2, (Object)"fitToElements", (Object)3);
    }

    public LayoutShadowNode createShadowNodeInstance() {
        return new SizeReportingShadowNode();
    }

    public void addView(GoogleMapView parent, View child, int index) {
        parent.addFeature(child, index);
    }

    public int getChildCount(GoogleMapView view) {
        return view.getFeatureCount();
    }

    public View getChildAt(GoogleMapView view, int index) {
        return view.getFeatureAt(index);
    }

    public void removeViewAt(GoogleMapView parent, int index) {
        parent.removeFeatureAt(index);
    }

    public void updateExtraData(GoogleMapView view, Object extraData) {
        view.updateExtraData(extraData);
    }
}

