/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.amap.view;

import android.content.Context;
import com.amap.api.maps2d.AMap;
import com.amap.api.maps2d.model.LatLng;
import com.amap.api.maps2d.model.Polygon;
import com.amap.api.maps2d.model.PolygonOptions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.tuya.smart.amap.view.MapFeature;
import java.util.ArrayList;
import java.util.List;

public class AMapPolygon
extends MapFeature<AMap> {
    private PolygonOptions polygonOptions;
    private Polygon polygon;
    private List<LatLng> coordinates;
    private int strokeColor;
    private int fillColor;
    private float strokeWidth;
    private boolean geodesic;
    private float zIndex;

    public AMapPolygon(Context context) {
        super(context);
    }

    public void setCoordinates(ReadableArray coordinates) {
        this.coordinates = new ArrayList<LatLng>(coordinates.size());
        for (int i = 0; i < coordinates.size(); ++i) {
            ReadableMap coordinate = coordinates.getMap(i);
            this.coordinates.add(i, new LatLng(coordinate.getDouble("latitude"), coordinate.getDouble("longitude")));
        }
        if (this.polygon != null) {
            this.polygon.setPoints(this.coordinates);
        }
    }

    public void setFillColor(int color) {
        this.fillColor = color;
        if (this.polygon != null) {
            this.polygon.setFillColor(color);
        }
    }

    public void setStrokeColor(int color) {
        this.strokeColor = color;
        if (this.polygon != null) {
            this.polygon.setStrokeColor(color);
        }
    }

    public void setStrokeWidth(float width) {
        this.strokeWidth = width;
        if (this.polygon != null) {
            this.polygon.setStrokeWidth(width);
        }
    }

    public void setGeodesic(boolean geodesic) {
        this.geodesic = geodesic;
        if (this.polygon != null) {
            // empty if block
        }
    }

    public void setZIndex(float zIndex) {
        this.zIndex = zIndex;
        if (this.polygon != null) {
            this.polygon.setZIndex(zIndex);
        }
    }

    public PolygonOptions getPolygonOptions() {
        if (this.polygonOptions == null) {
            this.polygonOptions = this.createPolygonOptions();
        }
        return this.polygonOptions;
    }

    private PolygonOptions createPolygonOptions() {
        PolygonOptions options = new PolygonOptions();
        options.addAll(this.coordinates);
        options.fillColor(this.fillColor);
        options.strokeColor(this.strokeColor);
        options.strokeWidth(this.strokeWidth);
        options.zIndex(this.zIndex);
        return options;
    }

    @Override
    public Object getFeature() {
        return this.polygon;
    }

    @Override
    public void addToMap(AMap map) {
        this.polygon = map.addPolygon(this.getPolygonOptions());
    }

    @Override
    public void removeFromMap(AMap map) {
        this.polygon.remove();
    }
}

