/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.log;

import com.alibaba.fastjson.JSON;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.android.network.util.TimeStampManager;
import com.tuya.smart.sdk.api.ITemporaryCallBack;
import com.tuya.smart.stat.db.LBean;
import com.tuya.smart.stat.db.LSet;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class TuyaLogSdk {
    private Class analysisManagerClass = null;
    private Method eventMethod;
    private Method beginEventMethod;
    private Method trackEventMethod;
    private Method endEventMethod;
    private Method tempEventMethod;
    private Method tempPushMethod;
    public static final String TYPE_EVENT_NOTE = "Event";

    public TuyaLogSdk() {
        try {
            this.analysisManagerClass = Class.forName("com.tuya.smart.statsdk.AnalysisManager");
        }
        catch (Exception ignore) {
            L.i((String)TYPE_EVENT_NOTE, (String)"do not have AnalysisManager, maybe this app is customer's app");
        }
    }

    public void event(String eventId, Map<String, Object> map) {
        try {
            if (this.analysisManagerClass != null && this.eventMethod == null) {
                this.eventMethod = this.analysisManagerClass.getMethod("reportEvent", String.class, String.class, Map.class);
            }
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            this.eventMethod.invoke(null, eventId, TYPE_EVENT_NOTE, map);
        }
        catch (Exception ignore) {
            L.d((String)TYPE_EVENT_NOTE, (String)"do not have AnalysisManager, record log failed");
        }
    }

    public void eventOnDebugTool(String eventId, Map<String, String> map) {
        try {
            LBean lBean = new LBean();
            lBean.setEventId(eventId);
            lBean.setT(TimeStampManager.instance().getCurrentTimeStamp());
            lBean.setLog(JSON.toJSONString(map));
            LSet.insertL((LBean)lBean);
        }
        catch (Exception ignore) {
            L.d((String)TYPE_EVENT_NOTE, (String)"do not have AnalysisManager, record log failed");
        }
    }

    public void beginEvent(String event, Object object, Map<String, Object> publicMap, Map<String, Object> privateMap) {
        try {
            if (this.beginEventMethod == null) {
                this.beginEventMethod = this.analysisManagerClass.getMethod("beginEvent", String.class, Object.class, Map.class, Map.class, Long.class);
            }
            if (publicMap == null) {
                publicMap = new HashMap<String, Object>();
            }
            if (privateMap == null) {
                privateMap = new HashMap<String, Object>();
            }
            this.beginEventMethod.invoke(null, event, object, publicMap, privateMap, 120L);
        }
        catch (Exception ignore) {
            L.d((String)TYPE_EVENT_NOTE, (String)"do not have AnalysisManager, record log failed");
        }
    }

    public void endEvent(Object object, Map<String, Object> publicMap, Map<String, Object> privateMap) {
        try {
            if (this.endEventMethod == null) {
                this.endEventMethod = this.analysisManagerClass.getMethod("endEvent", Object.class, Map.class, Map.class);
            }
            if (publicMap == null) {
                publicMap = new HashMap<String, Object>();
            }
            if (privateMap == null) {
                privateMap = new HashMap<String, Object>();
            }
            this.endEventMethod.invoke(null, object, publicMap, privateMap);
        }
        catch (Exception ignore) {
            L.d((String)TYPE_EVENT_NOTE, (String)"do not have AnalysisManager, record log failed");
        }
    }

    public void trackEvent(Object object, Map<String, Object> publicMap, Map<String, Object> privateMap) {
        try {
            if (this.trackEventMethod == null) {
                this.trackEventMethod = this.analysisManagerClass.getMethod("trackEvent", Object.class, Map.class, Map.class);
            }
            if (publicMap == null) {
                publicMap = new HashMap<String, Object>();
            }
            if (privateMap == null) {
                privateMap = new HashMap<String, Object>();
            }
            this.trackEventMethod.invoke(null, object, publicMap, privateMap);
        }
        catch (Exception ignore) {
            L.d((String)TYPE_EVENT_NOTE, (String)"do not have AnalysisManager, record log failed");
        }
    }

    public void temporaryEvent(String eventId, String repeatKey, Map<String, Object> map, int limit, ITemporaryCallBack callBack) {
        if (this.analysisManagerClass != null) {
            try {
                if (this.tempEventMethod == null) {
                    this.tempEventMethod = this.analysisManagerClass.getMethod("temporaryEvent", String.class, String.class, Map.class, Integer.TYPE, ITemporaryCallBack.class);
                }
                if (map == null) {
                    map = new HashMap<String, Object>();
                }
                this.tempEventMethod.invoke(null, eventId, repeatKey, map, limit, callBack);
            }
            catch (Throwable ignore) {
                L.d((String)TYPE_EVENT_NOTE, (String)"do not have AnalysisManager, record log failed");
            }
        }
    }

    public void pushTemporaryEvent(String eventId, String repeatKey, ITemporaryCallBack callBack) {
        if (this.analysisManagerClass != null) {
            try {
                if (this.tempPushMethod == null) {
                    this.tempPushMethod = this.analysisManagerClass.getMethod("pushTemporaryEvent", String.class, String.class, ITemporaryCallBack.class);
                }
                this.tempPushMethod.invoke(null, eventId, repeatKey, callBack);
            }
            catch (Throwable ignore) {
                L.d((String)TYPE_EVENT_NOTE, (String)"do not have AnalysisManager, record log failed");
            }
        }
    }
}

