/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.sdk.log;

import android.app.Application;
import com.tuya.sdk.core.AbstractComponentService;
import com.tuya.sdk.log.TuyaLogSdk;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.components.annotation.TuyaComponentsService;
import com.tuya.smart.interior.log.ITuyaLogPlugin;
import com.tuya.smart.sdk.api.ITemporaryCallBack;
import java.util.Map;

@TuyaComponentsService(value=ITuyaLogPlugin.class)
class TuyaLogPlugin
extends AbstractComponentService
implements ITuyaLogPlugin {
    public static final String TAG = "TuyaLogSdk";
    private TuyaLogSdk mSdk;

    public TuyaLogPlugin() {
        if (this.hasAnalysisManager()) {
            this.mSdk = new TuyaLogSdk();
        } else {
            L.w((String)TAG, (String)"has not AnalysisManager, could not send log");
        }
    }

    private boolean hasAnalysisManager() {
        try {
            Class.forName("com.tuya.smart.statsdk.AnalysisManager");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void event(String eventId, Map<String, Object> map) {
        if (this.mSdk != null) {
            this.mSdk.event(eventId, map);
        } else {
            L.d((String)TAG, (String)"has not AnalysisManager, could not send log");
        }
    }

    public void eventOnDebugTool(String eventId, Map<String, String> map) {
        if (this.mSdk != null) {
            this.mSdk.eventOnDebugTool(eventId, map);
        } else {
            L.d((String)TAG, (String)"has not AnalysisManager, could not send log");
        }
    }

    public void beginEvent(String event, Object object, Map<String, Object> publicMap, Map<String, Object> privateMap) {
        if (this.mSdk != null) {
            this.mSdk.beginEvent(event, object, publicMap, privateMap);
        } else {
            L.d((String)TAG, (String)"has not AnalysisManager, could not send log");
        }
    }

    public void trackEvent(Object object, Map<String, Object> publicMap, Map<String, Object> privateMap) {
        if (this.mSdk != null) {
            this.mSdk.trackEvent(object, publicMap, privateMap);
        } else {
            L.d((String)TAG, (String)"has not AnalysisManager, could not send log");
        }
    }

    public void endEvent(Object object, Map<String, Object> publicMap, Map<String, Object> privateMap) {
        if (this.mSdk != null) {
            this.mSdk.endEvent(object, publicMap, privateMap);
        } else {
            L.d((String)TAG, (String)"has not AnalysisManager, could not send log");
        }
    }

    public void temporaryEvent(String eventId, String repeatKey, Map<String, Object> map, int limit, ITemporaryCallBack callBack) {
        if (this.mSdk != null) {
            this.mSdk.temporaryEvent(eventId, repeatKey, map, limit, callBack);
        } else {
            L.d((String)TAG, (String)"has not AnalysisManager, could not send log");
        }
    }

    public void pushTemporaryEvent(String eventId, String repeatKey, ITemporaryCallBack callBack) {
        if (this.mSdk != null) {
            this.mSdk.pushTemporaryEvent(eventId, repeatKey, callBack);
        } else {
            L.d((String)TAG, (String)"has not AnalysisManager, could not send log");
        }
    }

    public void dependencies() {
    }

    public void init(Application application) {
    }
}

