/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils.thread;

import android.os.Handler;
import android.os.HandlerThread;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.camera.utils.DiffServiceUtil;
import com.tuya.smart.ipc.panel.api.IIpcDiffPlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class UPThreadPoolManager {
    private static final String TAG = UPThreadPoolManager.class.getName();
    private static UPThreadPoolManager mInstance = new UPThreadPoolManager();
    private Map<String, ThreadHolder> map = new HashMap<String, ThreadHolder>();
    private Set<String> deadSet = new HashSet<String>();
    long currentTimeMillis = System.currentTimeMillis();

    public static synchronized UPThreadPoolManager getInstance() {
        if (mInstance == null) {
            mInstance = new UPThreadPoolManager();
        }
        return mInstance;
    }

    private UPThreadPoolManager() {
        L.d((String)"UPThreadPoolManager", (String)("start time " + this.currentTimeMillis));
    }

    public void execute(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        IIpcDiffPlugin service = DiffServiceUtil.getDiffPlugin();
        if (service != null) {
            service.execute(runnable);
        }
    }

    public void execute(Object keyObj, Runnable runnable) {
        ThreadHolder threadHolder;
        String key = this.getThreadName(keyObj);
        if (!this.deadSet.contains(key) && !this.map.containsKey(key)) {
            L.d((String)TAG, (String)"new thread");
            this.map.put(key, new ThreadHolder(key));
            this.deadSet.add(key);
        }
        if ((threadHolder = this.map.get(key)) != null) {
            threadHolder.execute(runnable);
        }
        L.d((String)TAG, (String)("thread num: " + this.map.size()));
    }

    public void quite(Object keyObj) {
        String key = this.getThreadName(keyObj);
        ThreadHolder threadHolder = this.map.get(key);
        if (threadHolder != null) {
            threadHolder.quite();
            this.map.remove(this.getThreadName(keyObj));
            L.d((String)TAG, (String)"quite");
        }
        L.d((String)TAG, (String)("thread num: " + this.map.size()));
    }

    public void remove(Runnable runnable) {
        if (runnable == null) {
            return;
        }
    }

    public void shutDown() {
    }

    private String getThreadName(Object object) {
        String name = object + "-thread";
        try {
            if (name.contains(".")) {
                name = name.substring(name.lastIndexOf(".") + 1, name.length());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        L.d((String)TAG, (String)name);
        return name;
    }

    private static class ThreadHolder {
        private HandlerThread thread;
        private Handler handler;

        public ThreadHolder(String name) {
            this.thread = new HandlerThread(name);
            this.thread.start();
            this.handler = new Handler(this.thread.getLooper());
        }

        public void execute(Runnable runnable) {
            if (this.handler != null) {
                this.handler.post(runnable);
            }
        }

        public void quite() {
            if (this.thread != null) {
                this.thread.quit();
            }
            this.handler = null;
            this.thread = null;
        }
    }
}

