/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils.permission;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.media.AudioRecord;
import android.os.Build;
import android.os.Environment;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.camera.utils.AppUtils;
import com.tuya.smart.camera.utils.SharedPreferencesUtil;
import com.tuya.smart.utils.ToastUtil;
import java.io.File;

public final class PermissionChecker {
    private static final String TAG = "PermissionChecker";
    public static final int EXTERNAL_STORAGE_REQ_CODE = 10;
    public static final int EXTERNAL_AUDIO_REQ_CODE = 11;
    public static final String[] PERMISSIONS = new String[]{"android.permission.RECORD_AUDIO", "android.permission.WRITE_EXTERNAL_STORAGE"};

    private PermissionChecker() {
    }

    public static boolean lacksPermissions(Context context, String ... permissions) {
        for (String permission2 : permissions) {
            if (!PermissionChecker.lacksPermission(context, permission2)) continue;
            return true;
        }
        return false;
    }

    public static boolean lacksPermission(Context context, String permission2) {
        return ContextCompat.checkSelfPermission((Context)context, (String)permission2) == -1;
    }

    public static int permissionState(Context context, String permission2) {
        return ContextCompat.checkSelfPermission((Context)context, (String)permission2);
    }

    public static boolean shouldShowRequestPermissionRationale(Activity activity, String permission2) {
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2);
    }

    public static synchronized boolean requestPermission(Context context, String permission2, int requestCode, int tip) {
        boolean result;
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        int targetSdkVersion = 0;
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            targetSdkVersion = info.applicationInfo.targetSdkVersion;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        if (targetSdkVersion >= 23) {
            result = ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
        } else {
            boolean bl = result = androidx.core.content.PermissionChecker.checkSelfPermission((Context)context, (String)permission2) == 0;
        }
        if (!result) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)context), (String)permission2)) {
                SharedPreferencesUtil sharedPreferencesUtil = new SharedPreferencesUtil(AppUtils.getContext(), "ipc_permission");
                if (PERMISSIONS[0].equals(permission2)) {
                    sharedPreferencesUtil.putBooleanValue("audio_permisson", true);
                } else if (PERMISSIONS[1].equals(permission2)) {
                    sharedPreferencesUtil.putBooleanValue("storage_permisson", true);
                }
                ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])new String[]{permission2}, (int)requestCode);
                return false;
            }
            ToastUtil.showToast((Context)context, (String)context.getResources().getString(tip));
            return false;
        }
        return true;
    }

    public static synchronized boolean hasStoragePermission() {
        String filePath = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "a.log";
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                boolean iscreate = file.createNewFile();
                if (iscreate) {
                    if (!file.delete()) {
                        L.e((String)TAG, (String)("hasStoragePermission method, file not exists, delete fail, path: " + filePath));
                    }
                    return true;
                }
                return false;
            }
            if (!file.delete()) {
                L.e((String)TAG, (String)("hasStoragePermission method, file exists, delete fail, path: " + filePath));
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasRecordPermission() {
        int minBufferSize = AudioRecord.getMinBufferSize((int)8000, (int)16, (int)2);
        int bufferSizeInBytes = 640;
        byte[] audioData = new byte[bufferSizeInBytes];
        AudioRecord audioRecord = null;
        try {
            audioRecord = new AudioRecord(0, 8000, 16, 2, minBufferSize);
            audioRecord.startRecording();
        }
        catch (Exception e) {
            if (audioRecord != null) {
                audioRecord.release();
            }
            return false;
        }
        if (audioRecord.getRecordingState() != 3) {
            audioRecord.stop();
            audioRecord.release();
            return false;
        }
        int readSize = audioRecord.read(audioData, 0, bufferSizeInBytes);
        audioRecord.stop();
        audioRecord.release();
        return readSize > 0;
    }
}

