/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils.homekey;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.tuya.smart.android.common.utils.L;

public class HomeListener {
    private static final String TAG = "HomeListener";
    private IntentFilter mHomeBtnIntentFilter;
    private HomeBtnReceiver mHomeBtnReceiver;
    private Context mContext;
    private KeyFun mKeyFun;

    public HomeListener(Context context) {
        this.mContext = context;
        this.mHomeBtnIntentFilter = new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        this.mHomeBtnReceiver = new HomeBtnReceiver();
    }

    public void startListen() {
        if (this.mContext != null) {
            this.mContext.registerReceiver((BroadcastReceiver)this.mHomeBtnReceiver, this.mHomeBtnIntentFilter);
        } else {
            L.e((String)TAG, (String)"mContext is null and startListen fail");
        }
    }

    public void stopListen() {
        if (this.mContext != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mHomeBtnReceiver);
        } else {
            L.e((String)TAG, (String)"mContext is null and stopListen fail");
        }
    }

    public void setInterface(KeyFun keyFun) {
        this.mKeyFun = keyFun;
    }

    class HomeBtnReceiver
    extends BroadcastReceiver {
        HomeBtnReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String reason;
            String action = intent.getAction();
            if (action.equals("android.intent.action.CLOSE_SYSTEM_DIALOGS") && (reason = intent.getStringExtra("reason")) != null && null != HomeListener.this.mKeyFun) {
                if ("homekey".equals(reason)) {
                    HomeListener.this.mKeyFun.home();
                } else if ("recentapps".equals(reason)) {
                    HomeListener.this.mKeyFun.recent();
                } else if ("assist".equals(reason)) {
                    HomeListener.this.mKeyFun.longHome();
                }
            }
        }
    }

    public static interface KeyFun {
        public void home();

        public void recent();

        public void longHome();
    }
}

