/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.camera.utils.AppUtils;
import com.tuya.smart.camera.utils.AudioUtils;

public class HeadsetPlugReceiver
extends BroadcastReceiver {
    private static final String TAG = "HeadsetPlugReceiver";
    private AudioManager audioManager;

    public void onReceive(Context context, Intent intent) {
        this.audioManager = (AudioManager)context.getSystemService("audio");
        String action = intent.getAction();
        if ("android.intent.action.HEADSET_PLUG".equals(action)) {
            int state = intent.getIntExtra("state", -1);
            if (state == 0) {
                AudioUtils.choiceAudioModel(AppUtils.getContext());
            } else if (state == 1) {
                AudioUtils.changeToReceiver(AppUtils.getContext());
            }
        } else if ("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED".equals(action)) {
            int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
            this.updateBluetoothIndication(state);
        } else if ("android.media.AUDIO_BECOMING_NOISY".equals(action)) {
            AudioUtils.changeToSpeaker(AppUtils.getContext());
        }
    }

    public void updateBluetoothIndication(int bluetoothHeadsetState) {
        if (bluetoothHeadsetState == 2) {
            L.d((String)TAG, (String)"BluetoothProfile.STATE_CONNECTED");
            if (this.audioManager == null) {
                return;
            }
            AudioUtils.changeToHeadset(AppUtils.getContext());
        } else {
            if (this.audioManager == null) {
                return;
            }
            AudioUtils.changeToSpeaker(AppUtils.getContext());
        }
    }
}

