/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils;

import android.content.Context;
import android.icu.util.TimeZone;
import android.os.Build;
import android.text.TextUtils;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.camera.utils.R;
import com.tuya.smart.camera.utils.SharedPreferencesUtil;
import com.tuya.smart.home.sdk.TuyaHomeSdk;
import com.tuya.smart.sdk.bean.DeviceBean;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

public final class TimeZoneUtils {
    private static final String TAG = "TimeZoneUtils";

    private TimeZoneUtils() {
    }

    public static String getTimezoneGCMById(String timezoneId) {
        int timeZoneByRawOffset;
        if (Build.VERSION.SDK_INT >= 24) {
            TimeZone timeZone = TimeZone.getTimeZone((String)timezoneId);
            timeZoneByRawOffset = timeZone.getRawOffset() + timeZone.getDSTSavings();
        } else {
            java.util.TimeZone timeZone = SimpleTimeZone.getTimeZone(timezoneId);
            timeZoneByRawOffset = timeZone.getRawOffset() + timeZone.getDSTSavings();
        }
        return TimeZoneUtils.getTimeZoneByRawOffset(timeZoneByRawOffset);
    }

    private static String getTimeZoneByRawOffset(int rawOffset) {
        String timeDisplay = rawOffset >= 0 ? "+" : "";
        int hour = rawOffset / 1000 / 3600;
        int minute = Math.abs(rawOffset - hour * 1000 * 3600) / 1000 / 60;
        timeDisplay = timeDisplay + String.format(Locale.US, "%02d:%02d", hour, minute);
        return timeDisplay;
    }

    public static long getCurrentTimeByTimeZone(String timeZoneId) {
        int timeZoneByRawOffset;
        if (Build.VERSION.SDK_INT >= 24) {
            TimeZone timeZone = TimeZone.getTimeZone((String)timeZoneId);
            timeZoneByRawOffset = timeZone.getRawOffset() + timeZone.getDSTSavings();
        } else {
            java.util.TimeZone timeZone = SimpleTimeZone.getTimeZone(timeZoneId);
            timeZoneByRawOffset = timeZone.getRawOffset() + timeZone.getDSTSavings();
        }
        return System.currentTimeMillis() + (long)timeZoneByRawOffset;
    }

    public static java.util.TimeZone getTimeZone(Context context, String devId) {
        java.util.TimeZone timeZone = java.util.TimeZone.getDefault();
        DeviceBean deviceBean = TuyaHomeSdk.getDataInstance().getDeviceBean(devId);
        if (deviceBean != null && !TextUtils.isEmpty((CharSequence)deviceBean.getTimezoneId())) {
            boolean useDeviceTimeZone = SharedPreferencesUtil.isUseDevTimeZone();
            if (useDeviceTimeZone) {
                timeZone = java.util.TimeZone.getTimeZone(deviceBean.getTimezoneId());
            }
        } else {
            L.i((String)TAG, (String)"empty time zone, use default");
        }
        return timeZone;
    }

    public static String timeAMPM(long time, Context context, String devId) {
        Date date = new Date(time);
        Calendar instance = Calendar.getInstance(TimeZoneUtils.getTimeZone(context, devId));
        instance.setTime(date);
        System.out.println(instance.get(11) + "");
        int i = R.string.timer_am;
        if (date.getHours() > 11) {
            i = R.string.timer_pm;
        }
        return context.getResources().getString(i);
    }

    public static String timeHMFormat(long time, boolean is24, Context context, String devId) {
        String formatStr = is24 ? "HH:mm" : "hh:mm";
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        sdf.setTimeZone(TimeZoneUtils.getTimeZone(context, devId));
        return sdf.format(new Date(time));
    }

    public static String timeHMSFormat(long time, boolean is24, Context context, String devId) {
        String formatStr = is24 ? "HH:mm:ss" : "hh:mm:ss a";
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        sdf.setTimeZone(TimeZoneUtils.getTimeZone(context, devId));
        return sdf.format(new Date(time));
    }
}

