/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils;

import android.os.Environment;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class OSUtils {
    private static final ROM ROM_TYPE = OSUtils.initRomType();
    private static final String KEY_DISPLAY_ID = "ro.build.display.id";
    private static final String KEY_BASE_OS_VERSION = "ro.build.version.base_os";
    private static final String KEY_CLIENT_ID_BASE = "ro.com.google.clientidbase";
    private static final String KEY_MIUI_VERSION = "ro.build.version.incremental";
    private static final String KEY_MIUI_VERSION_NANE = "ro.miui.ui.version.name";
    private static final String KEY_MIUI_VERSION_CODE = "ro.miui.ui.version.code";
    private static final String VALUE_MIUI_CLIENT_ID_BASE = "android-xiaomi";
    private static final String KEY_EMUI_VERSION = "ro.build.version.emui";
    private static final String KEY_EMUI_API_LEVEL = "ro.build.hw_emui_api_level";
    private static final String KEY_EMUI_SYSTEM_VERSION = "ro.confg.hw_systemversion";
    private static final String KEY_FLYME_PUBLISHED = "ro.flyme.published";
    private static final String KEY_FLYME_SETUP = "ro.meizu.setupwizard.flyme";
    private static final String VALUE_FLYME_DISPLAY_ID_CONTAIN = "Flyme";
    private static final String KEY_COLOROS_VERSION = "ro.oppo.theme.version";
    private static final String KEY_COLOROS_THEME_VERSION = "ro.oppo.version";
    private static final String KEY_COLOROS_ROM_VERSION = "ro.rom.different.version";
    private static final String VALUE_COLOROS_BASE_OS_VERSION_CONTAIN = "OPPO";
    private static final String VALUE_COLOROS_CLIENT_ID_BASE = "android-oppo";
    private static final String KEY_FUNTOUCHOS_BOARD_VERSION = "ro.vivo.board.version";
    private static final String KEY_FUNTOUCHOS_OS_NAME = "ro.vivo.os.name";
    private static final String KEY_FUNTOUCHOS_OS_VERSION = "ro.vivo.os.version";
    private static final String KEY_FUNTOUCHOS_DISPLAY_ID = "ro.vivo.os.build.display.id";
    private static final String KEY_FUNTOUCHOS_ROM_VERSION = "ro.vivo.rom.version";
    private static final String VALUE_FUNTOUCHOS_CLIENT_ID_BASE = "android-vivo";
    private static final String VALUE_SAMSUNG_BASE_OS_VERSION_CONTAIN = "samsung";
    private static final String VALUE_SAMSUNG_CLIENT_ID_BASE = "android-samsung";
    private static final String KEY_SONY_PROTOCOL_TYPE = "ro.sony.irremote.protocol_type";
    private static final String KEY_SONY_ENCRYPTED_DATA = "ro.sony.fota.encrypteddata";
    private static final String VALUE_SONY_CLIENT_ID_BASE = "android-sonyericsson";
    private static final String KEY_EUI_VERSION = "ro.letv.release.version";
    private static final String KEY_EUI_VERSION_DATE = "ro.letv.release.version_date";
    private static final String KEY_EUI_NAME = "ro.product.letv_name";
    private static final String KEY_EUI_MODEL = "ro.product.letv_model";
    private static final String KEY_AMIGO_ROM_VERSION = "ro.gn.gnromvernumber";
    private static final String KEY_AMIGO_SYSTEM_UI_SUPPORT = "ro.gn.amigo.systemui.support";
    private static final String VALUE_AMIGO_DISPLAY_ID_CONTAIN = "amigo";
    private static final String VALUE_AMIGO_CLIENT_ID_BASE = "android-gionee";
    private static final String KEY_YULONG_VERSION_RELEASE = "ro.yulong.version.release";
    private static final String KEY_YULONG_VERSION_TAG = "ro.yulong.version.tag";
    private static final String VALUE_YULONG_CLIENT_ID_BASE = "android-coolpad";
    private static final String KEY_SENSE_BUILD_STAGE = "htc.build.stage";
    private static final String KEY_SENSE_BLUETOOTH_SAP = "ro.htc.bluetooth.sap";
    private static final String VALUE_SENSE_CLIENT_ID_BASE = "android-htc-rev";
    private static final String KEY_LG_SW_VERSION = "ro.lge.swversion";
    private static final String KEY_LG_SW_VERSION_SHORT = "ro.lge.swversion_short";
    private static final String KEY_LG_FACTORY_VERSION = "ro.lge.factoryversion";
    private static final String KEY_LENOVO_DEVICE = "ro.lenovo.device";
    private static final String KEY_LENOVO_PLATFORM = "ro.lenovo.platform";
    private static final String KEY_LENOVO_ADB = "ro.lenovo.adb";
    private static final String VALUE_LENOVO_CLIENT_ID_BASE = "android-lenovo";

    private OSUtils() {
    }

    public static ROM getRomType() {
        return ROM_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ROM initRomType() {
        ROM rom;
        block133: {
            rom = ROM.Other;
            FileInputStream is = null;
            try {
                Properties buildProperties = new Properties();
                is = new FileInputStream(new File(Environment.getRootDirectory(), "build.prop"));
                buildProperties.load(is);
                if (buildProperties.containsKey(KEY_MIUI_VERSION_NANE) || buildProperties.containsKey(KEY_MIUI_VERSION_CODE)) {
                    String versionStr;
                    String versionName;
                    rom = ROM.MIUI;
                    if (buildProperties.containsKey(KEY_MIUI_VERSION_NANE) && !TextUtils.isEmpty((CharSequence)(versionName = buildProperties.getProperty(KEY_MIUI_VERSION_NANE))) && versionName.matches("[Vv]\\d+")) {
                        try {
                            rom.setBaseVersion(Integer.parseInt(versionName.split("[Vv]")[1]));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (buildProperties.containsKey(KEY_MIUI_VERSION) && !TextUtils.isEmpty((CharSequence)(versionStr = buildProperties.getProperty(KEY_MIUI_VERSION))) && versionStr.matches("[\\d.]+")) {
                        rom.setVersion(versionStr);
                    }
                    break block133;
                }
                if (buildProperties.containsKey(KEY_EMUI_VERSION) || buildProperties.containsKey(KEY_EMUI_API_LEVEL) || buildProperties.containsKey(KEY_EMUI_SYSTEM_VERSION)) {
                    rom = ROM.EMUI;
                    if (buildProperties.containsKey(KEY_EMUI_VERSION)) {
                        String versionStr = buildProperties.getProperty(KEY_EMUI_VERSION);
                        Matcher matcher = Pattern.compile("EmotionUI_([\\d.]+)").matcher(versionStr);
                        if (!TextUtils.isEmpty((CharSequence)versionStr) && matcher.find()) {
                            try {
                                String version = matcher.group(1);
                                rom.setVersion(version);
                                rom.setBaseVersion(Integer.parseInt(version.split("\\.")[0]));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else if (buildProperties.containsKey(KEY_FLYME_SETUP) || buildProperties.containsKey(KEY_FLYME_PUBLISHED)) {
                    rom = ROM.Flyme;
                    if (buildProperties.containsKey(KEY_DISPLAY_ID)) {
                        String versionStr = buildProperties.getProperty(KEY_DISPLAY_ID);
                        Matcher matcher = Pattern.compile("Flyme[^\\d]*([\\d.]+)[^\\d]*").matcher(versionStr);
                        if (!TextUtils.isEmpty((CharSequence)versionStr) && matcher.find()) {
                            try {
                                String version = matcher.group(1);
                                rom.setVersion(version);
                                rom.setBaseVersion(Integer.parseInt(version.split("\\.")[0]));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else if (buildProperties.containsKey(KEY_COLOROS_VERSION) || buildProperties.containsKey(KEY_COLOROS_THEME_VERSION) || buildProperties.containsKey(KEY_COLOROS_ROM_VERSION)) {
                    rom = ROM.ColorOS;
                    if (buildProperties.containsKey(KEY_COLOROS_ROM_VERSION)) {
                        String versionStr = buildProperties.getProperty(KEY_COLOROS_ROM_VERSION);
                        Matcher matcher = Pattern.compile("ColorOS([\\d.]+)").matcher(versionStr);
                        if (!TextUtils.isEmpty((CharSequence)versionStr) && matcher.find()) {
                            try {
                                String version = matcher.group(1);
                                rom.setVersion(version);
                                rom.setBaseVersion(Integer.parseInt(version.split("\\.")[0]));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else if (buildProperties.containsKey(KEY_FUNTOUCHOS_OS_NAME) || buildProperties.containsKey(KEY_FUNTOUCHOS_OS_VERSION) || buildProperties.containsKey(KEY_FUNTOUCHOS_DISPLAY_ID)) {
                    String versionStr;
                    rom = ROM.FuntouchOS;
                    if (buildProperties.containsKey(KEY_FUNTOUCHOS_OS_VERSION) && !TextUtils.isEmpty((CharSequence)(versionStr = buildProperties.getProperty(KEY_FUNTOUCHOS_OS_VERSION))) && versionStr.matches("[\\d.]+")) {
                        try {
                            rom.setVersion(versionStr);
                            rom.setBaseVersion(Integer.parseInt(versionStr.split("\\.")[0]));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (buildProperties.containsKey(KEY_EUI_VERSION) || buildProperties.containsKey(KEY_EUI_NAME) || buildProperties.containsKey(KEY_EUI_MODEL)) {
                    rom = ROM.EUI;
                    if (buildProperties.containsKey(KEY_EUI_VERSION)) {
                        String versionStr = buildProperties.getProperty(KEY_EUI_VERSION);
                        Matcher matcher = Pattern.compile("([\\d.]+)[^\\d]*").matcher(versionStr);
                        if (!TextUtils.isEmpty((CharSequence)versionStr) && matcher.find()) {
                            try {
                                String version = matcher.group(1);
                                rom.setVersion(version);
                                rom.setBaseVersion(Integer.parseInt(version.split("\\.")[0]));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else if (buildProperties.containsKey(KEY_AMIGO_ROM_VERSION) || buildProperties.containsKey(KEY_AMIGO_SYSTEM_UI_SUPPORT)) {
                    rom = ROM.AmigoOS;
                    if (buildProperties.containsKey(KEY_DISPLAY_ID)) {
                        String versionStr = buildProperties.getProperty(KEY_DISPLAY_ID);
                        Matcher matcher = Pattern.compile("amigo([\\d.]+)[a-zA-Z]*").matcher(versionStr);
                        if (!TextUtils.isEmpty((CharSequence)versionStr) && matcher.find()) {
                            try {
                                String version = matcher.group(1);
                                rom.setVersion(version);
                                rom.setBaseVersion(Integer.parseInt(version.split("\\.")[0]));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else if (buildProperties.containsKey(KEY_SONY_PROTOCOL_TYPE) || buildProperties.containsKey(KEY_SONY_ENCRYPTED_DATA)) {
                    rom = ROM.Sony;
                } else if (buildProperties.containsKey(KEY_YULONG_VERSION_RELEASE) || buildProperties.containsKey(KEY_YULONG_VERSION_TAG)) {
                    rom = ROM.YuLong;
                } else if (buildProperties.containsKey(KEY_SENSE_BUILD_STAGE) || buildProperties.containsKey(KEY_SENSE_BLUETOOTH_SAP)) {
                    rom = ROM.Sense;
                } else if (buildProperties.containsKey(KEY_LG_SW_VERSION) || buildProperties.containsKey(KEY_LG_SW_VERSION_SHORT) || buildProperties.containsKey(KEY_LG_FACTORY_VERSION)) {
                    rom = ROM.LG;
                } else if (buildProperties.containsKey(KEY_LENOVO_DEVICE) || buildProperties.containsKey(KEY_LENOVO_PLATFORM) || buildProperties.containsKey(KEY_LENOVO_ADB)) {
                    rom = ROM.Lenovo;
                } else if (buildProperties.containsKey(KEY_DISPLAY_ID)) {
                    String displayId = buildProperties.getProperty(KEY_DISPLAY_ID);
                    if (!TextUtils.isEmpty((CharSequence)displayId)) {
                        if (displayId.contains(VALUE_FLYME_DISPLAY_ID_CONTAIN)) {
                            ROM rOM = ROM.Flyme;
                            return rOM;
                        }
                        if (displayId.contains(VALUE_AMIGO_DISPLAY_ID_CONTAIN)) {
                            ROM rOM = ROM.AmigoOS;
                            return rOM;
                        }
                    }
                } else if (buildProperties.containsKey(KEY_BASE_OS_VERSION)) {
                    String baseOsVersion = buildProperties.getProperty(KEY_BASE_OS_VERSION);
                    if (!TextUtils.isEmpty((CharSequence)baseOsVersion)) {
                        if (baseOsVersion.contains(VALUE_COLOROS_BASE_OS_VERSION_CONTAIN)) {
                            ROM rOM = ROM.ColorOS;
                            return rOM;
                        }
                        if (baseOsVersion.contains(VALUE_SAMSUNG_BASE_OS_VERSION_CONTAIN)) {
                            ROM rOM = ROM.SamSung;
                            return rOM;
                        }
                    }
                } else if (buildProperties.containsKey(KEY_CLIENT_ID_BASE)) {
                    String clientIdBase;
                    switch (clientIdBase = buildProperties.getProperty(KEY_CLIENT_ID_BASE)) {
                        case "android-xiaomi": {
                            ROM rOM = ROM.MIUI;
                            return rOM;
                        }
                        case "android-oppo": {
                            ROM rOM = ROM.ColorOS;
                            return rOM;
                        }
                        case "android-vivo": {
                            ROM rOM = ROM.FuntouchOS;
                            return rOM;
                        }
                        case "android-samsung": {
                            ROM rOM = ROM.SamSung;
                            return rOM;
                        }
                        case "android-sonyericsson": {
                            ROM rOM = ROM.Sony;
                            return rOM;
                        }
                        case "android-coolpad": {
                            ROM rOM = ROM.YuLong;
                            return rOM;
                        }
                        case "android-htc-rev": {
                            ROM rOM = ROM.Sense;
                            return rOM;
                        }
                        case "android-lenovo": {
                            ROM rOM = ROM.Lenovo;
                            return rOM;
                        }
                        case "android-gionee": {
                            ROM rOM = ROM.AmigoOS;
                            return rOM;
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return rom;
    }

    public static enum ROM {
        MIUI,
        Flyme,
        EMUI,
        ColorOS,
        FuntouchOS,
        SmartisanOS,
        EUI,
        Sense,
        AmigoOS,
        _360OS,
        NubiaUI,
        H2OS,
        YunOS,
        YuLong,
        SamSung,
        Sony,
        Lenovo,
        LG,
        Google,
        Other;

        private int baseVersion = -1;
        private String version;

        void setVersion(String version) {
            this.version = version;
        }

        void setBaseVersion(int baseVersion) {
            this.baseVersion = baseVersion;
        }

        public int getBaseVersion() {
            return this.baseVersion;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

