/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils;

import android.content.ComponentName;
import android.content.Intent;
import android.os.Build;
import com.tuya.smart.camera.utils.AppUtils;
import com.tuya.smart.camera.utils.IntentUtils;

public final class OSSystemSettingUtils {
    private OSSystemSettingUtils() {
    }

    public static void goToSetting() {
        Intent intent = null;
        intent = "HUAWEI".equals(Build.MANUFACTURER) ? OSSystemSettingUtils.huaweiSetting() : ("Meizu".equals(Build.MANUFACTURER) ? OSSystemSettingUtils.meizuSetting() : ("Xiaomi".equals(Build.MANUFACTURER) ? OSSystemSettingUtils.xiaomiSetting() : OSSystemSettingUtils.getSettingIntent()));
        IntentUtils.startActivity(intent);
    }

    private static Intent getSettingIntent() {
        return new Intent("android.settings.SETTINGS").addFlags(0x10000000);
    }

    private static Intent xiaomiSetting() {
        Intent intent = new Intent();
        String packageName = AppUtils.getPackageName();
        intent.setAction("miui.intent.action.APP_PERM_EDITOR");
        intent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity");
        intent.putExtra("extra_pkgname", packageName);
        return intent;
    }

    private static Intent meizuSetting() {
        Intent intent = new Intent();
        String packageName = AppUtils.getPackageName();
        intent.setFlags(0x10000000);
        intent.setAction("com.meizu.safe.security.SHOW_APPSEC");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.putExtra("packageName", packageName);
        return intent;
    }

    private static Intent huaweiSetting() {
        Intent intent = new Intent();
        intent.setFlags(0x10000000);
        String packageName = AppUtils.getPackageName();
        intent.putExtra("packageName", packageName);
        intent.setComponent(new ComponentName("com.huawei.systemmanager", "com.huawei.permissionmanager.ui.MainActivity"));
        return intent;
    }
}

