/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils;

import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.text.TextUtils;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MediaScannerUtils {
    private Context context;
    private MediaScannerConnection.MediaScannerConnectionClient client;
    private MediaScannerConnection mMediaScanner;

    public MediaScannerUtils(Context context) {
        this.context = context;
    }

    public void notifyAlbum(final String allPath, final String mimeType) {
        if (TextUtils.isEmpty((CharSequence)allPath)) {
            return;
        }
        this.client = new MediaScannerConnection.MediaScannerConnectionClient(){

            public void onMediaScannerConnected() {
                if (null != MediaScannerUtils.this.mMediaScanner) {
                    MediaScannerUtils.this.mMediaScanner.scanFile(allPath, mimeType);
                }
            }

            public void onScanCompleted(String path, Uri uri) {
                if (null != MediaScannerUtils.this.mMediaScanner) {
                    MediaScannerUtils.this.mMediaScanner.disconnect();
                }
            }
        };
        this.mMediaScanner = new MediaScannerConnection(this.context, this.client);
        ThreadPoolExecutor singleThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new ThreadPoolExecutor.AbortPolicy());
        singleThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                MediaScannerUtils.this.mMediaScanner.connect();
            }
        });
        singleThreadPool.shutdown();
    }
}

