/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils;

import com.tuya.smart.camera.utils.HexUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MD5Utils {
    private static final int SIXTEEN_K = 16384;

    private MD5Utils() {
    }

    public static byte[] computeMD5Hash(InputStream is) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            byte[] var5;
            int bytesRead;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[16384];
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            byte[] byArray = var5 = messageDigest.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException var14) {
            throw new IllegalStateException(var14);
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception var13) {
                var13.printStackTrace();
            }
        }
    }

    public static String md5AsBase64(InputStream is) throws IOException {
        return HexUtil.bytesToHexString(MD5Utils.computeMD5Hash(is));
    }

    public static byte[] computeMD5Hash(byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(input);
        }
        catch (NoSuchAlgorithmException var2) {
            throw new IllegalStateException(var2);
        }
    }

    public static String md5AsBase64(byte[] input) {
        return HexUtil.bytesToHexString(MD5Utils.computeMD5Hash(input));
    }

    public static byte[] computeMD5Hash(File file) throws IOException {
        return MD5Utils.computeMD5Hash(new FileInputStream(file));
    }

    public static String md5AsBase64(File file) throws IOException {
        return HexUtil.bytesToHexString(MD5Utils.computeMD5Hash(file));
    }

    public static String md5AsBase64(String str) {
        return MD5Utils.md5AsBase64(str.getBytes());
    }

    public static String md5AsBase64For16(String str) {
        return MD5Utils.md5AsBase64(str).substring(8, 24);
    }

    public static String str2md5(String key) {
        String cacheKey;
        try {
            MessageDigest mDigest = MessageDigest.getInstance("MD5");
            mDigest.update(key.getBytes());
            cacheKey = MD5Utils.bytesToHexString(mDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            cacheKey = String.valueOf(key.hashCode());
        }
        return cacheKey;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }
}

