/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JsonUtil {
    private JsonUtil() {
    }

    public static Map<String, Object> toMap(String jsonString) throws JSONException {
        JSONObject object = new JSONObject(jsonString);
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (object != JSONObject.NULL) {
            retMap = JsonUtil.toMap(object);
        }
        return retMap;
    }

    public static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            List<Object> value = object.get(key);
            if (value instanceof JSONArray) {
                value = JsonUtil.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JsonUtil.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = JsonUtil.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JsonUtil.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }
}

