/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils;

import android.os.Environment;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.camera.utils.DiffServiceUtil;
import com.tuya.smart.ipc.panel.api.IIpcDiffPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class IPCCameraUtils {
    private static final String TAG = "IPCCameraUtils";
    public static final String SNAPSHOT_PATH = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Camera/";
    public static final String COVER_SNAPSHOT_PATH = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Camera/Cover/";
    public static final String RECORD_PATH = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Camera/Thumbnail/";
    public static final String CACHE_PATH = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Camera/Cache/";
    public static final String SEPARATE_LINE = "/";
    private static final int CONVERSION_RATIO = 1024;

    private IPCCameraUtils() {
    }

    public static String recordSnapshotPath(String devId) {
        return IPCCameraUtils.recordSnapshotPath(SNAPSHOT_PATH, devId);
    }

    public static String silenceSnapshotPath(String devId) {
        return IPCCameraUtils.recordSnapshotPath(COVER_SNAPSHOT_PATH, devId);
    }

    private static String recordSnapshotPath(String dicPath, String devId) {
        String videoPath = dicPath + devId + SEPARATE_LINE;
        File file = new File(videoPath);
        if (!file.exists() && !file.mkdirs()) {
            L.e((String)TAG, (String)("recordSnapshotPath create the directory fail, videoPath is " + videoPath));
        }
        return videoPath;
    }

    public static String recordPath(String devId) {
        String videoPath = RECORD_PATH + devId + SEPARATE_LINE;
        File file = new File(videoPath);
        if (!file.exists() && !file.mkdirs()) {
            L.e((String)TAG, (String)("recordPath create the directory fail, videoPath is " + videoPath));
        }
        return videoPath;
    }

    public static String translateSpaceGB(String space) {
        float spaceWithGB = (float)Long.parseLong(space) * 1.0f / 1.0737418E9f;
        float spaceShow = (float)Math.round(spaceWithGB * 100.0f) * 1.0f / 100.0f;
        String tempStr = String.format(Locale.US, "%.2f", Float.valueOf(spaceShow));
        return tempStr + "GB";
    }

    @Deprecated
    public static Map<String, Object> toMap(String jsonString) throws JSONException {
        JSONObject object = new JSONObject(jsonString);
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (object != JSONObject.NULL) {
            retMap = IPCCameraUtils.toMap(object);
        }
        return retMap;
    }

    @Deprecated
    public static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            List<Object> value = object.get(key);
            if (value instanceof JSONArray) {
                value = IPCCameraUtils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = IPCCameraUtils.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    @Deprecated
    public static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = IPCCameraUtils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = IPCCameraUtils.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    public static int transformP2pType(int type) {
        int sdkProvider = type;
        IIpcDiffPlugin service = DiffServiceUtil.getDiffPlugin();
        if (service != null) {
            sdkProvider = service.transformType(type);
        }
        return sdkProvider;
    }
}

