/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils;

import android.text.TextUtils;
import java.io.ByteArrayOutputStream;

public final class HexUtil {
    private static String hexString = "0123456789ABCDEF";

    private HexUtil() {
    }

    public static String encode(String str) {
        byte[] bytes = str.getBytes();
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(hexString.charAt((bytes[i] & 0xF0) >> 4));
            sb.append(hexString.charAt((bytes[i] & 0xF) >> 0));
        }
        return sb.toString();
    }

    public static String decode(String bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length() / 2);
        for (int i = 0; i < bytes.length(); i += 2) {
            baos.write(hexString.indexOf(bytes.charAt(i)) << 4 | hexString.indexOf(bytes.charAt(i + 1)));
        }
        return new String(baos.toByteArray());
    }

    private static byte uniteBytes(byte src0, byte src1) {
        byte b0 = Byte.decode("0x" + new String(new byte[]{src0}));
        b0 = (byte)(b0 << 4);
        byte b1 = Byte.decode("0x" + new String(new byte[]{src1}));
        return (byte)(b0 | b1);
    }

    public static byte[] hexString2Bytes(String src) {
        byte[] ret = new byte[6];
        byte[] tmp = src.getBytes();
        for (int i = 0; i < 6; ++i) {
            ret[i] = HexUtil.uniteBytes(tmp[i * 2], tmp[i * 2 + 1]);
        }
        return ret;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src != null && src.length > 0) {
            for (int i = 0; i < src.length; ++i) {
                int v = src[i] & 0xFF;
                String hv = Integer.toHexString(v);
                if (hv.length() < 2) {
                    stringBuilder.append(0);
                }
                stringBuilder.append(hv);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString != null && !"".equals(hexString)) {
            hexString = hexString.toUpperCase();
            int length = hexString.length() / 2;
            char[] hexChars = hexString.toCharArray();
            byte[] d = new byte[length];
            for (int i = 0; i < length; ++i) {
                int pos = i * 2;
                d[i] = (byte)(HexUtil.charToByte(hexChars[pos]) << 4 | HexUtil.charToByte(hexChars[pos + 1]));
            }
            return d;
        }
        return null;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static boolean checkHexString(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            if (HexUtil.checkHexChar(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkHexChar(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }
}

