/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import com.tuya.smart.camera.utils.R;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class DateUtils {
    public static final String FORMAT_SHORT = "yyyy-MM-dd";
    public static final String FORMAT_SHORT1 = "yyyy/MM/dd";
    public static final String FORMAT_LONG = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_MID = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_MID_12 = "yyyy-MM-dd a hh:mm";
    public static final String FORMAT_ONE = "yyyyMMdd";
    public static final String FORMAT_MM_DD_HH_MM = "MM-dd HH:mm";
    public static final String FORMAT_MMDD = "MM.dd";
    public static final String FORMAT_HHMM = "HH:mm";
    public static final String FORMAT_HHMM_12 = "hh:mm";
    public static final String FORMAT_HHMMSS_24 = "HH:mm:ss";
    public static final String FORMAT_HHMMSSA_12 = "hh:mm:ss a";
    public static final String FORMAT_HHMMSS_12 = "hh:mm:ss";
    private static final int JUDGE_NUM = 10;
    private static final int SECOND_IN_HOUR = 3600;
    private static final int MINUTE_IN_HOUR = 60;

    private DateUtils() {
    }

    public static String getDayString(int year, int month, int day) {
        StringBuilder dayBuilder = new StringBuilder();
        dayBuilder.append(DateUtils.getYearMonthString(year, month));
        if (day < 10) {
            dayBuilder.append("0");
        }
        dayBuilder.append(String.valueOf(day));
        return dayBuilder.toString();
    }

    public static String getYearMonthString(int year, int month) {
        StringBuilder yearMonth = new StringBuilder();
        yearMonth.append(String.valueOf(year));
        if (month < 10) {
            yearMonth.append("0");
        }
        yearMonth.append(String.valueOf(month));
        return yearMonth.toString();
    }

    public static float timeString2Float(String timeString) {
        if (timeString.length() > 6) {
            timeString = timeString.substring(timeString.length() - 6, timeString.length());
        }
        int[] time = new int[3];
        for (int i = 0; i < time.length; ++i) {
            String curS = timeString.substring(i * 2, i * 2 + 2);
            time[i] = Integer.parseInt(curS);
        }
        return (float)time[0] + (float)(time[1] * 60 + time[2]) * 1.0f / 3600.0f;
    }

    public static float scaleToOffsetWidth(float scale, int scaleMargin, int scaleNum) {
        return scale * (float)scaleNum * (float)scaleMargin;
    }

    public static long timeString2S(String timeString) {
        int[] time = new int[3];
        for (int i = 0; i < time.length; ++i) {
            String curS = timeString.substring(i * 2, i * 2 + 2);
            time[i] = Integer.parseInt(curS);
        }
        return time[0] * 3600 + time[1] * 60 + time[2];
    }

    public static int getSecondFromTime(String time) {
        String second = time.substring(time.length() - 2, time.length());
        if (second.startsWith("0")) {
            second = second.substring(1, 2);
        }
        return Integer.parseInt(second);
    }

    public static int getMinuteFromTime(String time) {
        String second = time.substring(time.length() - 4, time.length() - 2);
        if (second.startsWith("0")) {
            second = second.substring(1, 2);
        }
        return Integer.parseInt(second);
    }

    public static int getHourFromTime(String time) {
        String second = time.substring(time.length() - 6, time.length() - 4);
        if (second.startsWith("0")) {
            second = second.substring(1, 2);
        }
        return Integer.parseInt(second);
    }

    @Deprecated
    public static Map<String, Object> toMap(String jsonString) throws JSONException {
        JSONObject object = new JSONObject(jsonString);
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (object != JSONObject.NULL) {
            retMap = DateUtils.toMap(object);
        }
        return retMap;
    }

    @Deprecated
    public static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            List<Object> value = object.get(key);
            if (value instanceof JSONArray) {
                value = DateUtils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = DateUtils.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = DateUtils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = DateUtils.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    public static String transforToAlarmConfig(long startTime, long endTime) {
        String alarmConfig = startTime + "|" + endTime;
        return alarmConfig;
    }

    public static String transforToOpticalScalingConfig(String mode, int rate) {
        String alarmConfig = mode + "|" + rate;
        return alarmConfig;
    }

    public static long getTodayStart(long currentTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(currentTime);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTimeInMillis();
    }

    @Deprecated
    public static long getTodayEnd(long currentTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(currentTime));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.add(5, 1);
        return calendar.getTimeInMillis();
    }

    public static String getTimeByCurrentSecond(int currentSecond) {
        int minute = (currentSecond /= 60) % 60;
        int hour = currentSecond / 60;
        if (hour >= 24) {
            hour %= 24;
        }
        return (hour < 10 ? "0" + hour : Integer.valueOf(hour)) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute));
    }

    public static String getTimeByCurrentHours(int currentSecond) {
        currentSecond *= 10;
        int minute = (currentSecond /= 60) % 60;
        int hour = currentSecond / 60;
        if (hour >= 24) {
            hour %= 24;
        }
        return (hour < 10 ? "0" + hour : Integer.valueOf(hour)) + ":" + (minute < 10 ? "0" + minute : Integer.valueOf(minute));
    }

    public static String getDatePattern() {
        return FORMAT_SHORT;
    }

    public static String getNow() {
        return DateUtils.format(new Date(), FORMAT_SHORT);
    }

    public static String getNow(String format) {
        return DateUtils.format(new Date(), format);
    }

    public static String format(Date date) {
        return DateUtils.format(date, DateUtils.getDatePattern());
    }

    public static String format(Date date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return returnValue;
    }

    public static Date parse(String strDate) {
        return DateUtils.parse(strDate, DateUtils.getDatePattern());
    }

    public static Date parse(String strDate, String pattern) {
        return DateUtils.parse(strDate, pattern, TimeZone.getDefault());
    }

    public static Date parse(String strDate, String pattern, TimeZone zone) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        df.setTimeZone(zone);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long dateToStemp(String strDate) {
        Date date = DateUtils.parse(strDate);
        if (null != date) {
            return date.getTime();
        }
        return 0L;
    }

    public static long dateToStemp(String strDate, String format) {
        Date date = DateUtils.parse(strDate, format);
        if (null != date) {
            return date.getTime();
        }
        return 0L;
    }

    public static long dateToStemp(String strDate, String format, TimeZone zone) {
        Date date = DateUtils.parse(strDate, format, zone);
        if (null != date) {
            return date.getTime();
        }
        return 0L;
    }

    public static String parseDateToString(String s, String format) {
        long lt = Long.parseLong(s);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        Date date = new Date(lt);
        String res = simpleDateFormat.format(date);
        return res;
    }

    public static String parseDateToString(long s, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        Date date = new Date(s);
        String res = simpleDateFormat.format(date);
        return res;
    }

    public static String parseDateToString(long s, String format, TimeZone zone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        simpleDateFormat.setTimeZone(zone);
        Date date = new Date(s);
        String res = simpleDateFormat.format(date);
        return res;
    }

    public static String parseDateToString(long s) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_SHORT);
        Date date = new Date(s);
        String res = simpleDateFormat.format(date);
        return res;
    }

    public static String parseDateSecondToString(String s) {
        long lt = Long.parseLong(s) * 1000L;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_LONG);
        Date date = new Date(lt);
        String res = simpleDateFormat.format(date);
        return res;
    }

    public static String parseDateMinuteToString(long s) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_MID);
        Date date = new Date(s);
        String res = simpleDateFormat.format(date);
        return res;
    }

    public static String[] parseDate(String date) {
        String[] data = new String[]{date.substring(0, 6), date.substring(6, 8)};
        return data;
    }

    public static long utc2Local(long utcTime) {
        TimeZone destZone = TimeZone.getDefault();
        TimeZone srcZone = TimeZone.getTimeZone("UTC");
        long timeOffset = (long)(destZone.getRawOffset() - srcZone.getRawOffset()) / 1000L;
        Date dateTmp = new Date(utcTime + timeOffset);
        return dateTmp.getTime();
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }

    public static boolean compareDaies(Date d1, Date d2) {
        return d1.after(d2);
    }

    public static synchronized String getDayHourMinute(long timeStamp) {
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_MM_DD_HH_MM);
        return format.format(timeStamp);
    }

    public static String timeFormat(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_HHMMSS_24);
        Date date = new Date(time);
        return sdf.format(date);
    }

    public static String timeHMFormat(long time, boolean is24) {
        String formatStr = is24 ? FORMAT_HHMM : FORMAT_HHMM_12;
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        Date date = new Date(time);
        return sdf.format(date);
    }

    public static String timeHMSFormat(long time, boolean is24) {
        String formatStr = is24 ? FORMAT_HHMMSS_24 : FORMAT_HHMMSSA_12;
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        Date date = new Date(time);
        return sdf.format(date);
    }

    public static boolean is24hoursModel(Context context) {
        ContentResolver cv = context.getContentResolver();
        String strTimeFormat = Settings.System.getString((ContentResolver)cv, (String)"time_12_24");
        return "24".equals(strTimeFormat);
    }

    public static int timeAMPM(long time) {
        Date date = new Date(time);
        if (date.getHours() > 11) {
            return R.string.timer_pm;
        }
        return R.string.timer_am;
    }

    public static String formatCalender(int data) {
        if (data < 10) {
            return "0" + String.valueOf(data);
        }
        return String.valueOf(data);
    }

    public static String timeTranslateAMPM(String time, Context context) {
        int hour = Integer.parseInt(time.substring(0, time.indexOf(":")));
        String time_12Model = time;
        if (!DateUtils.is24hoursModel(context)) {
            time_12Model = context.getString(R.string.timer_am);
            if (hour >= 12) {
                time_12Model = context.getString(R.string.timer_pm);
                time_12Model = (hour -= 12) >= 10 ? time_12Model + hour : time_12Model + " 0" + hour;
                time_12Model = time_12Model + ":" + time.substring(time.indexOf(":") + 1, time.length());
            } else {
                time_12Model = hour >= 10 ? time_12Model + hour : time_12Model + " 0" + hour;
                time_12Model = time_12Model + ":" + time.substring(time.indexOf(":") + 1, time.length());
            }
        }
        return time_12Model;
    }

    public static String timeTranslateAMPM(int hour, int min, Context context) {
        if (hour == -1 || min == -1) {
            return "";
        }
        String time_12Model = context.getString(R.string.timer_am);
        if (!DateUtils.is24hoursModel(context)) {
            if (hour >= 12) {
                time_12Model = context.getString(R.string.timer_pm);
                time_12Model = (hour -= 12) >= 10 ? time_12Model + hour : time_12Model + " 0" + hour;
                time_12Model = time_12Model + ":" + DateUtils.getTimeString(min);
            } else {
                time_12Model = hour >= 10 ? time_12Model + hour : time_12Model + " 0" + hour;
                time_12Model = time_12Model + ":" + DateUtils.getTimeString(min);
            }
        } else {
            time_12Model = hour + ":" + DateUtils.getTimeString(min);
        }
        return time_12Model;
    }

    private static String getTimeString(int minute) {
        StringBuilder stringBuilder = new StringBuilder();
        if (minute < 10) {
            stringBuilder.append(0);
        }
        stringBuilder.append(minute);
        return stringBuilder.toString();
    }

    public static String time2Seconds(int seconds) {
        int temp = 0;
        StringBuilder timer = new StringBuilder();
        temp = seconds / 3600;
        timer.append(temp < 10 ? "0" + temp + ":" : "" + temp + ":");
        temp = seconds % 3600 / 60;
        timer.append(temp < 10 ? "0" + temp + ":" : "" + temp + ":");
        temp = seconds % 3600 % 60;
        timer.append(temp < 10 ? "0" + temp : "" + temp);
        return timer.toString();
    }
}

