/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils;

import android.graphics.Bitmap;
import com.tuya.smart.android.common.utils.L;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class BitmapUtils {
    private static final String TAG = "BitmapUtils";

    private BitmapUtils() {
    }

    public static Bitmap bytes2Bmp(byte[] b, int width, int height) {
        if (b.length != 0) {
            Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
            ByteBuffer byteBuffer = ByteBuffer.wrap(b, 0, b.length);
            byteBuffer.rewind();
            bmp.copyPixelsFromBuffer((Buffer)byteBuffer);
            return bmp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean savePhotoToSDCard(Bitmap photoBitmap, String path, String name) {
        boolean isSave = false;
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            L.e((String)TAG, (String)("savePhotoToSDCard create file fail, path: " + path));
        }
        File photoFile = new File(path, name);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(photoFile);
            if (photoBitmap != null) {
                if (photoBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream)) {
                    fileOutputStream.flush();
                }
                isSave = true;
            }
        }
        catch (FileNotFoundException e) {
            if (!photoFile.delete()) {
                L.e((String)TAG, (String)("savePhotoToSDCard delete photoFile fail, path: " + path));
            }
            e.printStackTrace();
            isSave = false;
        }
        catch (IOException e) {
            if (!photoFile.delete()) {
                L.e((String)TAG, (String)("savePhotoToSDCard try catch delete file fail, path: " + path));
            }
            e.printStackTrace();
            isSave = false;
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return isSave;
    }

    public static boolean savePhotoToSDCard(Bitmap photoBitmap, String path) {
        return BitmapUtils.savePhotoToSDCard(photoBitmap, path, String.valueOf(System.currentTimeMillis()) + ".png");
    }
}

