/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import com.tuya.smart.camera.utils.AppUtils;

public final class AudioUtils {
    private static AudioManager audioManager = (AudioManager)AppUtils.getContext().getSystemService("audio");

    private AudioUtils() {
    }

    public static void changeToSpeaker(Context context) {
        try {
            audioManager.setMode(3);
            audioManager.stopBluetoothSco();
            audioManager.setBluetoothScoOn(false);
            audioManager.setSpeakerphoneOn(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void changeToHeadset(Context context) {
        try {
            audioManager.setMode(3);
            audioManager.startBluetoothSco();
            audioManager.setBluetoothScoOn(true);
            audioManager.setSpeakerphoneOn(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void changeToReceiver(Context context) {
        try {
            audioManager.setSpeakerphoneOn(false);
            if (Build.VERSION.SDK_INT >= 11) {
                audioManager.setMode(3);
            } else {
                audioManager.setMode(2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static void dispose(Context context) {
        try {
            audioManager.unloadSoundEffects();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void dispose(Context context, AudioManager.OnAudioFocusChangeListener focusRequest) {
        try {
            audioManager.setMode(0);
            if (audioManager.isBluetoothScoOn()) {
                audioManager.setBluetoothScoOn(false);
                audioManager.stopBluetoothSco();
            }
            audioManager.unloadSoundEffects();
            if (null != focusRequest) {
                audioManager.abandonAudioFocus(focusRequest);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getModel(Context context) {
    }

    public static void changeToNomal(Context context) {
        try {
            audioManager.setMode(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isWiredHeadsetOn(Context context) {
        try {
            return audioManager.isWiredHeadsetOn();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isBluetoothA2dpOn(Context context) {
        try {
            return audioManager.isBluetoothA2dpOn();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void choiceAudioModel(Context context) {
        if (AudioUtils.isWiredHeadsetOn(context)) {
            AudioUtils.changeToReceiver(context);
        } else if (AudioUtils.isBluetoothA2dpOn(context)) {
            AudioUtils.changeToHeadset(context);
        } else {
            AudioUtils.changeToSpeaker(context);
        }
    }

    public static void choiceAudioModel(Context context, int audioManagerMode) {
        AudioUtils.choiceAudioModel(context);
    }

    public static void pauseMusic(Context context, AudioManager.OnAudioFocusChangeListener focusRequest) {
        try {
            audioManager.requestAudioFocus(focusRequest, 3, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

