/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import com.tuya.smart.sdk.TuyaSdk;
import com.tuya.smart.utils.ActivityStackUtil;
import java.util.List;

public final class AppUtils {
    private AppUtils() {
    }

    public static Context getContext() {
        return TuyaSdk.getApplication();
    }

    public static boolean isServiceRunning(String serviceClassName) {
        ActivityManager activityManager = (ActivityManager)AppUtils.getContext().getSystemService("activity");
        List services = activityManager.getRunningServices(Integer.MAX_VALUE);
        for (ActivityManager.RunningServiceInfo runningServiceInfo : services) {
            if (!runningServiceInfo.service.getClassName().equals(serviceClassName)) continue;
            return true;
        }
        return false;
    }

    @RequiresPermission(value="android.permission.GET_TASKS")
    public static boolean isAppOnForeground() {
        return AppUtils.isAppOnForeground(AppUtils.getPackageName());
    }

    @RequiresPermission(value="android.permission.GET_TASKS")
    public static boolean isAppOnForeground(String packageName) {
        ActivityManager activityManager = (ActivityManager)AppUtils.getContext().getSystemService("activity");
        List tasksInfo = activityManager.getRunningTasks(1);
        if (tasksInfo.size() > 0) {
            return ((ActivityManager.RunningTaskInfo)tasksInfo.get((int)0)).topActivity.getPackageName().equals(packageName);
        }
        return false;
    }

    public static String getTopActivityName() {
        ActivityManager activityManager = (ActivityManager)AppUtils.getContext().getSystemService("activity");
        if (activityManager != null) {
            return ((ActivityManager.RunningTaskInfo)activityManager.getRunningTasks((int)1).get((int)0)).topActivity.getClassName();
        }
        return null;
    }

    public static String getPackageName() {
        return AppUtils.getContext().getPackageName();
    }

    public static String getVersionName() {
        return AppUtils.getVersionName(AppUtils.getPackageName());
    }

    public static String getVersionName(@NonNull String packageName) {
        try {
            PackageInfo packageInfo = AppUtils.getContext().getPackageManager().getPackageInfo(packageName, 0);
            return packageInfo.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getVersionCode() {
        return AppUtils.getVersionCode(AppUtils.getPackageName());
    }

    public static int getVersionCode(@NonNull String packageName) {
        try {
            PackageInfo packageInfo = AppUtils.getContext().getPackageManager().getPackageInfo(packageName, 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String getAppName() {
        return AppUtils.getAppName(AppUtils.getPackageName());
    }

    public static String getAppName(@NonNull String packageName) {
        PackageManager pm = AppUtils.getContext().getPackageManager();
        try {
            ApplicationInfo info = pm.getApplicationInfo(packageName, 0);
            return info.loadLabel(pm).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAppSignature() {
        return AppUtils.getAppSignature(AppUtils.getPackageName());
    }

    public static String getAppSignature(@NonNull String packageName) {
        try {
            PackageInfo packinfo = AppUtils.getContext().getPackageManager().getPackageInfo(packageName, 64);
            return packinfo.signatures[0].toCharsString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAppInstalled(String packageName) {
        try {
            AppUtils.getContext().getPackageManager().getPackageInfo(packageName, 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static void launchApp(Activity activity, String packageName, int requestCode) {
        Intent launchIntent = AppUtils.getContext().getPackageManager().getLaunchIntentForPackage(packageName);
        try {
            activity.startActivityForResult(launchIntent, requestCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean checkAndStartInstalledApp(Activity activity, String packageName) {
        if (AppUtils.isAppInstalled(packageName)) {
            Intent intent = AppUtils.getContext().getPackageManager().getLaunchIntentForPackage(packageName);
            try {
                activity.startActivity(intent);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isAppDebug() {
        return AppUtils.isAppDebug(AppUtils.getPackageName());
    }

    public static boolean isAppDebug(String packageName) {
        try {
            PackageManager pm = AppUtils.getContext().getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(packageName, 0);
            return ai != null && (ai.flags & 2) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void killCurrentProcess() {
        Process.killProcess((int)Process.myPid());
        System.exit(0);
    }

    public static boolean isAppOnBackground() {
        return null == ActivityStackUtil.getForeActivity();
    }
}

