/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.camera.utils;

import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;

public final class AnimatorUtil {
    private AnimatorUtil() {
    }

    public static void showAndHiddenAnimation(final View view, AnimationState state, long duration) {
        float start = 0.0f;
        float end = 0.0f;
        if (state == AnimationState.STATE_SHOW) {
            end = 1.0f;
            if (view.getVisibility() == 0) {
                return;
            }
            view.setVisibility(0);
        } else if (state == AnimationState.STATE_HIDDEN) {
            start = 1.0f;
            if (view.getVisibility() != 0) {
                return;
            }
            view.setVisibility(4);
        }
        AlphaAnimation animation = new AlphaAnimation(start, end);
        animation.setDuration(duration);
        animation.setFillAfter(true);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                view.clearAnimation();
            }
        });
        view.setAnimation((Animation)animation);
        animation.start();
    }

    public static enum AnimationState {
        STATE_SHOW,
        STATE_HIDDEN;

    }
}

